/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.jmx;

import java.lang.reflect.InvocationTargetException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.handlers.jmx.DynamicMBeanImpl;
import org.apache.felix.ipojo.handlers.jmx.JmxConfigFieldMap;
import org.apache.felix.ipojo.parser.MethodMetadata;
import org.apache.felix.ipojo.util.Callback;

public class DynamicMBeanWRegisterImpl
extends DynamicMBeanImpl
implements MBeanRegistration {
    private MethodMetadata m_preRegisterMeth;
    private MethodMetadata m_postRegisterMeth;
    private MethodMetadata m_preDeregisterMeth;
    private MethodMetadata m_postDeregisterMeth;
    private ObjectName m_objName;

    public DynamicMBeanWRegisterImpl(JmxConfigFieldMap properties, InstanceManager instanceManager, MethodMetadata preRegisterMeth, MethodMetadata postRegisterMeth, MethodMetadata preDeregisterMeth, MethodMetadata postDeregisterMeth) {
        super(properties, instanceManager);
        this.m_preRegisterMeth = preRegisterMeth;
        this.m_postRegisterMeth = postRegisterMeth;
        this.m_preDeregisterMeth = preDeregisterMeth;
        this.m_postDeregisterMeth = postDeregisterMeth;
    }

    public ObjectName getObjectName() {
        return this.m_objName;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.m_objName = (ObjectName)this.callMethod(this.m_preRegisterMeth, "preRegister", new Object[]{server, name});
        return this.m_objName;
    }

    public void postRegister(Boolean registrationDone) {
        this.callMethod(this.m_postRegisterMeth, "postRegister", new Object[]{registrationDone});
    }

    public void preDeregister() throws Exception {
        this.callMethod(this.m_preDeregisterMeth, "preDeregister", null);
    }

    public void postDeregister() {
        this.callMethod(this.m_postDeregisterMeth, "postDeregister", null);
    }

    private Object callMethod(MethodMetadata methodMetadata, String methodName, Object[] params) {
        Callback mc = new Callback(methodMetadata, this.m_instanceManager);
        try {
            if (params == null || params.length == 0) {
                return mc.call();
            }
            return mc.call(params);
        }
        catch (NoSuchMethodException e) {
            System.err.println("No such method : " + methodName);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.err.println("Illegal Access Exception");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.err.println("Invocation Target Exception");
            e.printStackTrace();
        }
        return null;
    }
}

