/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util;

import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.Type;

public class Elements {
    public static Element buildElement(Type type) {
        String name = type.getClassName();
        int index = name.lastIndexOf(46);
        String local = name.substring(index + 1);
        String namespace = name.substring(0, index);
        return Elements.buildElement(namespace, local);
    }

    public static Element buildElement(String namespace, String name) {
        return new Element(name, namespace);
    }

    public static Element buildElement(String binding) {
        String[] split = binding.split(":");
        if (split.length == 1) {
            return Elements.buildElement("", binding);
        }
        if (split.length > 2) {
            throw new IllegalArgumentException(String.format("@HandlerBinding(\"%s\") is invalid: only 1 ':' char is authorized, please use the @HandlerBinding(namespace=\"...\", value=\"...\") form instead.", binding));
        }
        return Elements.buildElement(split[0], split[1]);
    }

    public static Element getPropertiesElement(ComponentWorkbench workbench) {
        Element properties = workbench.getIds().get("properties");
        if (properties == null) {
            properties = Elements.buildElement("", "properties");
            workbench.getIds().put("properties", properties);
            workbench.getElements().put(properties, null);
        }
        return properties;
    }
}

