/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.manipulation;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveInstanceDescription;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.test.scenarios.manipulation.service.FooService;
import org.osgi.framework.ServiceReference;

public class GetComponentInstanceTest
extends OSGiTestCase {
    IPOJOHelper helper;
    static /* synthetic */ Class class$0;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
    }

    public void tearDown() {
        this.helper.dispose();
    }

    public void testGetComponentInstance() {
        String factName = "Manipulation-FooProviderType-1";
        String compName = "FooProvider-1";
        ServiceReference ref = null;
        Factory fact = this.helper.getFactory(factName);
        GetComponentInstanceTest.assertNotNull((String)"Cannot find the factory FooProvider-1", (Object)fact);
        Properties props = new Properties();
        props.put("instance.name", compName);
        ComponentInstance ci = null;
        try {
            ci = fact.createComponentInstance((Dictionary)props);
        }
        catch (Exception e1) {
            GetComponentInstanceTest.fail((String)e1.getMessage());
        }
        GetComponentInstanceTest.assertEquals((String)"Check instance name", (String)compName, (String)ci.getInstanceName());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.felix.ipojo.test.scenarios.manipulation.service.FooService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ref = this.helper.getServiceReferenceByName(clazz.getName(), compName);
        GetComponentInstanceTest.assertNotNull((String)"FS not available", (Object)ref);
        FooService fs = (FooService)this.getServiceObject(ref);
        Pojo pojo = (Pojo)fs;
        ComponentInstance instance = pojo.getComponentInstance();
        GetComponentInstanceTest.assertEquals((String)"Check component instance name", (String)instance.getInstanceName(), (String)compName);
        GetComponentInstanceTest.assertEquals((String)"Check component factory name", (String)instance.getFactory().getName(), (String)factName);
        GetComponentInstanceTest.assertNotNull((String)"Instance description not null", (Object)instance.getInstanceDescription());
        PrimitiveInstanceDescription id = (PrimitiveInstanceDescription)instance.getInstanceDescription();
        GetComponentInstanceTest.assertTrue((String)"Check instance state", (id.getState() == 2 ? 1 : 0) != 0);
        GetComponentInstanceTest.assertEquals((String)"Check created pojo count", (int)id.getCreatedObjects().length, (int)1);
        GetComponentInstanceTest.assertEquals((String)"Check instance description name", (String)id.getName(), (String)compName);
        ci.dispose();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.apache.felix.ipojo.test.scenarios.manipulation.service.FooService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ref = this.getServiceReference(clazz2.getName());
        GetComponentInstanceTest.assertNull((String)"FS available, but component instance stopped", (Object)ref);
    }
}

