/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import java.util.ArrayList;
import org.apache.felix.ipojo.architecture.Architecture;
import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ManifestMetadataParser;
import org.apache.felix.ipojo.parser.ParseException;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class Instantiate
extends OSGiTestCase {
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
    }

    public void testInstantiateSimple() {
        Element[] meta = Instantiate.getInstanceMetadata(this.context.getBundle(), "org.apache.felix.ipojo.test.scenarios.component.InstantiateSimple");
        Instantiate.assertNotNull((Object)meta);
        Instantiate.assertEquals((int)1, (int)meta.length);
        Instantiate.assertNull((Object)meta[0].getAttribute("name"));
        Instantiate.assertEquals((int)0, (int)meta[0].getElements().length);
    }

    public void testInstantiateWithName() {
        Element[] meta = Instantiate.getInstanceMetadata(this.context.getBundle(), "org.apache.felix.ipojo.test.scenarios.component.InstantiateWithName");
        Instantiate.assertNotNull((Object)meta);
        Instantiate.assertEquals((int)1, (int)meta.length);
        Instantiate.assertNotNull((Object)meta[0].getAttribute("name"));
        Instantiate.assertEquals((String)"myInstantiatedInstance", (String)meta[0].getAttribute("name"));
        Instantiate.assertEquals((int)0, (int)meta[0].getElements().length);
    }

    public void testInstanceCreation() throws InvalidSyntaxException {
        String in = "org.apache.felix.ipojo.test.scenarios.component.InstantiateSimple-0";
        ServiceReference ref = this.helper.getServiceReferenceByName(Architecture.class.getName(), in);
        Instantiate.assertNotNull((Object)ref);
    }

    public void testInstanceCreationWithName() {
        String in = "myInstantiatedInstance";
        ServiceReference ref = this.helper.getServiceReferenceByName(Architecture.class.getName(), in);
        Instantiate.assertNotNull((Object)ref);
    }

    public static Element[] getInstanceMetadata(Bundle bundle, String component) {
        ArrayList<Element> list;
        block6: {
            String elem = (String)bundle.getHeaders().get("iPOJO-Components");
            if (elem == null) {
                throw new IllegalArgumentException("Cannot find iPOJO-Components descriptor in the specified bundle (" + bundle.getSymbolicName() + "). Not an iPOJO bundle.");
            }
            list = new ArrayList<Element>();
            try {
                Element element = ManifestMetadataParser.parseHeaderMetadata((String)elem);
                Element[] childs = element.getElements("instance");
                int i = 0;
                while (i < childs.length) {
                    String name = childs[i].getAttribute("component");
                    if (name != null && name.equalsIgnoreCase(component)) {
                        list.add(childs[i]);
                    }
                    ++i;
                }
                if (!list.isEmpty()) break block6;
                return null;
            }
            catch (ParseException e) {
                throw new IllegalStateException("Cannot parse the components from specified bundle (" + bundle.getSymbolicName() + "): " + e.getMessage());
            }
        }
        return list.toArray(new Element[list.size()]);
    }
}

