/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.logback.internal;

import java.util.AbstractMap;
import java.util.function.Supplier;
import org.apache.felix.logback.internal.LogbackLogListener;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.admin.LoggerAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.bridge.SLF4JBridgeHandler;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator {
    private volatile ServiceTracker<LoggerAdmin, LRST> lat;

    public void start(final BundleContext bundleContext) throws Exception {
        this.lat = new ServiceTracker<LoggerAdmin, LRST>(bundleContext, LoggerAdmin.class, null){

            public LRST addingService(ServiceReference<LoggerAdmin> reference) {
                return (LRST)((Object)Activator.tccl(() -> {
                    LoggerAdmin loggerAdmin = (LoggerAdmin)bundleContext.getService(reference);
                    LRST lrst = new LRST(bundleContext, loggerAdmin);
                    lrst.open();
                    return lrst;
                }));
            }

            public void removedService(ServiceReference<LoggerAdmin> reference, LRST lrst) {
                Activator.tccl(() -> {
                    lrst.close();
                    return null;
                });
            }
        };
        this.lat.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.lat.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R> R tccl(Supplier<R> action) {
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(Activator.class.getClassLoader());
            R r = action.get();
            return r;
        }
        finally {
            currentThread.setContextClassLoader(original);
        }
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    class Pair
    extends AbstractMap.SimpleEntry<LogReaderService, LogbackLogListener> {
        private static final long serialVersionUID = 1L;

        public Pair(LogReaderService logReaderService, LogbackLogListener logbackLogListener) {
            super(logReaderService, logbackLogListener);
        }
    }

    class LRST
    extends ServiceTracker<LogReaderService, Pair> {
        private final LoggerAdmin loggerAdmin;

        public LRST(BundleContext context, LoggerAdmin loggerAdmin) {
            super(context, LogReaderService.class, null);
            this.loggerAdmin = loggerAdmin;
        }

        public Pair addingService(ServiceReference<LogReaderService> reference) {
            return (Pair)Activator.tccl(() -> {
                LogReaderService logReaderService = (LogReaderService)this.context.getService(reference);
                LogbackLogListener logbackLogListener = new LogbackLogListener(this.loggerAdmin);
                logReaderService.addLogListener((LogListener)logbackLogListener);
                return new Pair(logReaderService, logbackLogListener);
            });
        }

        public void removedService(ServiceReference<LogReaderService> reference, Pair pair) {
            Activator.tccl(() -> {
                ((LogReaderService)pair.getKey()).removeLogListener((LogListener)pair.getValue());
                return null;
            });
        }
    }
}

