/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.annotations.AnnotationProcessor;
import org.apache.felix.scrplugin.annotations.ScannedClass;
import org.apache.felix.scrplugin.description.ClassDescription;

public class AnnotationProcessorManager
implements AnnotationProcessor {
    private final List<AnnotationProcessor> processors = new ArrayList<AnnotationProcessor>();

    public AnnotationProcessorManager(Log log, ClassLoader classLoader) throws SCRDescriptorFailureException {
        HashMap<String, AnnotationProcessor> processorMap = new HashMap<String, AnnotationProcessor>();
        for (AnnotationProcessor processor : ServiceLoader.load(AnnotationProcessor.class, classLoader)) {
            String key = processor.getClass().getName();
            if (processorMap.containsKey(key)) continue;
            processorMap.put(key, processor);
        }
        for (AnnotationProcessor pro : processorMap.values()) {
            this.processors.add(pro);
        }
        Collections.sort(this.processors, new Comparator<AnnotationProcessor>(){

            @Override
            public int compare(AnnotationProcessor o1, AnnotationProcessor o2) {
                return Integer.valueOf(o1.getRanking()).compareTo(o2.getRanking());
            }
        });
        if (this.processors.size() == 0) {
            throw new SCRDescriptorFailureException("No annotation processors found in classpath.");
        }
        log.debug("..using annotation processors: ");
        for (AnnotationProcessor pro : this.processors) {
            log.debug("  - " + pro.getName() + " - " + pro.getRanking());
        }
    }

    @Override
    public void process(ScannedClass scannedClass, ClassDescription describedClass) throws SCRDescriptorException, SCRDescriptorFailureException {
        for (AnnotationProcessor ap : this.processors) {
            ap.process(scannedClass, describedClass);
        }
    }

    @Override
    public int getRanking() {
        return 0;
    }

    @Override
    public String getName() {
        return "Annotation Processor Manager";
    }
}

