/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public abstract class ClassModifier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMethods(String className, String referenceName, String fieldName, String typeName, boolean createBind, boolean createUnbind, final ClassLoader classLoader, String outputDirectory, Log logger) throws SCRDescriptorException {
        String fileName = outputDirectory + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
        ClassNode cn = new ClassNode();
        try {
            FileInputStream fis = new FileInputStream(fileName);
            try {
                ClassReader reader = new ClassReader(fis);
                reader.accept(cn, 0);
            }
            finally {
                fis.close();
            }
            int mask = cn.version > 50 ? 3 : 0;
            ClassWriter writer = new ClassWriter(mask){

                @Override
                protected String getCommonSuperClass(String type1, String type2) {
                    Class<?> d;
                    Class<?> c;
                    try {
                        c = classLoader.loadClass(type1.replace('/', '.'));
                        d = classLoader.loadClass(type2.replace('/', '.'));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.toString(), e);
                    }
                    if (c.isAssignableFrom(d)) {
                        return type1;
                    }
                    if (d.isAssignableFrom(c)) {
                        return type2;
                    }
                    if (c.isInterface() || d.isInterface()) {
                        return "java/lang/Object";
                    }
                    while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                    }
                    return c.getName().replace('.', '/');
                }
            };
            cn.accept(writer);
            if (createBind) {
                logger.debug("Adding bind " + className + " " + fieldName);
                ClassModifier.createMethod(writer, className, referenceName, fieldName, typeName, true);
            }
            if (createUnbind) {
                logger.debug("Adding unbind " + className + " " + fieldName);
                ClassModifier.createMethod(writer, className, referenceName, fieldName, typeName, false);
            }
            FileOutputStream fos = new FileOutputStream(fileName);
            try {
                fos.write(writer.toByteArray());
            }
            finally {
                fos.close();
            }
        }
        catch (Exception e) {
            throw new SCRDescriptorException("Unable to add methods to " + className, typeName, e);
        }
    }

    private static void createMethod(ClassWriter cw, String className, String referenceName, String fieldName, String typeName, boolean bind) {
        Type type = Type.getType("L" + typeName.replace('.', '/') + ";");
        String methodName = (bind ? "" : "un") + "bind" + referenceName.substring(0, 1).toUpperCase() + referenceName.substring(1);
        MethodVisitor mv = cw.visitMethod(4, methodName, "(" + type.toString() + ")V", null, null);
        mv.visitVarInsn(25, 0);
        if (bind) {
            mv.visitVarInsn(type.getOpcode(21), 1);
            mv.visitFieldInsn(181, className.replace('.', '/'), fieldName, type.toString());
        } else {
            mv.visitFieldInsn(180, className.replace('.', '/'), fieldName, type.toString());
            mv.visitVarInsn(25, 1);
            Label jmpLabel = new Label();
            mv.visitJumpInsn(166, jmpLabel);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(1);
            mv.visitFieldInsn(181, className.replace('.', '/'), fieldName, type.toString());
            mv.visitLabel(jmpLabel);
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
    }
}

