/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public abstract class ClassModifier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMethods(String className, String referenceName, String referenceType, String fieldName, String fieldType, boolean createBind, boolean createUnbind, final ClassLoader classLoader, String outputDirectory, Log logger) throws SCRDescriptorException {
        String fileName = outputDirectory + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
        ClassNode cn = new ClassNode();
        try {
            FileInputStream fis = new FileInputStream(fileName);
            try {
                ClassReader reader = new ClassReader((InputStream)fis);
                reader.accept((ClassVisitor)cn, 0);
            }
            finally {
                fis.close();
            }
            int mask = cn.version > 50 ? 3 : 0;
            ClassWriter writer = new ClassWriter(mask){

                protected String getCommonSuperClass(String type1, String type2) {
                    Class<?> d;
                    Class<?> c;
                    try {
                        c = classLoader.loadClass(type1.replace('/', '.'));
                        d = classLoader.loadClass(type2.replace('/', '.'));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.toString(), e);
                    }
                    if (c.isAssignableFrom(d)) {
                        return type1;
                    }
                    if (d.isAssignableFrom(c)) {
                        return type2;
                    }
                    if (c.isInterface() || d.isInterface()) {
                        return "java/lang/Object";
                    }
                    while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                    }
                    return c.getName().replace('.', '/');
                }
            };
            cn.accept((ClassVisitor)writer);
            if (createBind) {
                logger.debug("Adding bind " + className + " " + fieldName);
                ClassModifier.createMethod(writer, className, referenceName, referenceType, fieldName, fieldType, true);
            }
            if (createUnbind) {
                logger.debug("Adding unbind " + className + " " + fieldName);
                ClassModifier.createMethod(writer, className, referenceName, referenceType, fieldName, fieldType, false);
            }
            FileOutputStream fos = new FileOutputStream(fileName);
            try {
                fos.write(writer.toByteArray());
            }
            finally {
                fos.close();
            }
        }
        catch (Exception e) {
            throw new SCRDescriptorException("Unable to add methods to " + className, referenceType, e);
        }
    }

    private static void createMethod(ClassWriter cw, String className, String referenceName, String referenceTypeName, String fieldName, String fieldTypeName, boolean bind) {
        Type referenceType = Type.getType((String)("L" + referenceTypeName.replace('.', '/') + ";"));
        Type fieldType = Type.getType((String)("L" + fieldTypeName.replace('.', '/') + ";"));
        String methodName = (bind ? "" : "un") + "bind" + referenceName.substring(0, 1).toUpperCase() + referenceName.substring(1);
        MethodVisitor mv = cw.visitMethod(4, methodName, "(" + referenceType.toString() + ")V", null, null);
        mv.visitVarInsn(25, 0);
        if (bind) {
            mv.visitVarInsn(referenceType.getOpcode(21), 1);
            mv.visitFieldInsn(181, className.replace('.', '/'), fieldName, fieldType.toString());
        } else {
            mv.visitFieldInsn(180, className.replace('.', '/'), fieldName, fieldType.toString());
            mv.visitVarInsn(25, 1);
            Label jmpLabel = new Label();
            mv.visitJumpInsn(166, jmpLabel);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(1);
            mv.visitFieldInsn(181, className.replace('.', '/'), fieldName, fieldType.toString());
            mv.visitLabel(jmpLabel);
        }
        mv.visitInsn(177);
        mv.visitMaxs(2, 2);
    }
}

