/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.upnp.internal;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.osgi.framework.Constants;
import org.osgi.framework.ServiceReference;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;
import org.osgi.util.tracker.ServiceTracker;

class ConfigurationPrinterImpl
implements ConfigurationPrinter,
Constants {
    private final ServiceTracker tracker;

    ConfigurationPrinterImpl(ServiceTracker tracker) {
        this.tracker = tracker;
    }

    public String getTitle() {
        return "UPnP Devices";
    }

    public void printConfiguration(PrintWriter pw) {
        TreeMap<String, ServiceReference> componentMap = new TreeMap<String, ServiceReference>();
        ServiceReference[] refs = this.tracker.getServiceReferences();
        for (int i = 0; refs != null && i < refs.length; ++i) {
            ServiceReference ref = refs[i];
            if (null == ref.getProperty("UPnP.device.UDN")) continue;
            componentMap.put(ConfigurationPrinterImpl.nameOf(ref).toString() + ref.getProperty("service.id"), ref);
        }
        if (componentMap.isEmpty()) {
            pw.println("Status: No UPnP devices found");
            return;
        }
        pw.println("Status: " + componentMap.size() + " UPnP devices found");
        pw.println();
        Iterator ci = componentMap.values().iterator();
        while (ci.hasNext()) {
            this.print(pw, (ServiceReference)ci.next());
        }
    }

    private static final Object nameOf(ServiceReference ref) {
        Object name = ref.getProperty("UPnP.device.friendlyName");
        if (null == name) {
            name = ref.getProperty("UPnP.device.UDN");
        }
        return name;
    }

    private void print(PrintWriter pw, ServiceReference ref) {
        pw.println(ConfigurationPrinterImpl.nameOf(ref));
        pw.println("  Properties:");
        Object[] properties = ref.getPropertyKeys();
        Arrays.sort(properties);
        for (int i = 0; i < properties.length; ++i) {
            Object key = properties[i];
            if ("objectClass".equals(key) || "service.id".equals(key)) continue;
            Object val = ref.getProperty((String)key);
            val = WebConsoleUtil.toString((Object)val);
            pw.print("    ");
            pw.print((String)key);
            pw.print(" = ");
            pw.println(val);
        }
        UPnPDevice dev = (UPnPDevice)this.tracker.getService(ref);
        if (null == dev) {
            return;
        }
        UPnPService[] services = dev.getServices();
        if (null != services && services.length > 0) {
            pw.println("  Services:");
            for (int i = 0; i < services.length; ++i) {
                this.print(pw, services[i]);
            }
        }
        pw.println();
    }

    private void print(PrintWriter pw, UPnPService serv) {
        UPnPStateVariable[] vars;
        pw.print("    Service: ");
        pw.print(serv.getId());
        pw.print(", ver ");
        pw.print(serv.getVersion());
        pw.print(" (type = ");
        pw.print(serv.getType());
        pw.println(')');
        UPnPAction[] actions = serv.getActions();
        if (actions != null && actions.length > 0) {
            pw.print("    Actions: ");
            for (int i = 0; i < actions.length; ++i) {
                pw.print(actions[i].getName());
                if (i >= actions.length - 1) continue;
                pw.print(", ");
            }
            pw.println();
        }
        if ((vars = serv.getStateVariables()) != null && vars.length > 0) {
            pw.println("    State Vars:");
            for (int i = 0; i < vars.length; ++i) {
                this.print(pw, vars[i]);
            }
        }
    }

    private void print(PrintWriter pw, UPnPStateVariable var) {
        pw.print("       ");
        pw.print(var.getName());
        pw.print(" (");
        pw.print(var.getUPnPDataType());
        pw.print(')');
        if (var.sendsEvents()) {
            pw.print(", sends events");
        }
        if (null != var.getMinimum()) {
            pw.print(", min = ");
            pw.print(var.getMinimum());
        }
        if (null != var.getMaximum()) {
            pw.print(", max = ");
            pw.print(var.getMaximum());
        }
        if (null != var.getStep()) {
            pw.print(", step = ");
            pw.print(var.getStep());
        }
        pw.println();
    }
}

