/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileSpec {
    private Map<String, Source> sources;
    private String[] mimeTypes;

    public FileSpec(List<VirtualFile> files, String[] mimeTypes) throws CompilerException {
        this(files, mimeTypes, true);
    }

    public FileSpec(List<VirtualFile> files, String[] mimeTypes, boolean lastIsRoot) throws CompilerException {
        VirtualFile[] vfiles = new VirtualFile[files.size()];
        files.toArray(vfiles);
        this.init(vfiles, mimeTypes, lastIsRoot);
    }

    private void init(VirtualFile[] files, String[] mimeTypes, boolean lastIsRoot) throws CompilerException {
        this.mimeTypes = mimeTypes;
        this.sources = new LinkedHashMap<String, Source>(files.length);
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            if (!this.isSupported(files[i])) {
                UnsupportedFileType err = new UnsupportedFileType(files[i].getName());
                ThreadLocalToolkit.log(err);
                throw err;
            }
            String name = files[i].getName();
            String shortName = name.substring(name.lastIndexOf(File.separator) + 1, name.lastIndexOf(46));
            Source s = new Source(files[i], "", shortName, this, false, i == length - 1 && lastIsRoot);
            this.sources.put(name, s);
        }
    }

    public List<Source> retrieveSources() {
        ArrayList<Source> sources = new ArrayList<Source>(this.sources.size());
        for (String name : this.sources.keySet()) {
            CompilationUnit u;
            Source s = this.sources.get(name);
            CompilationUnit compilationUnit = u = s != null ? s.getCompilationUnit() : null;
            if (s != null && !s.exists()) {
                s = null;
            } else if (!(u != null && !u.isDone() || s != null && s.isUpdated() || u == null)) {
                s = s.copy();
                assert (s != null);
            }
            if (s == null) continue;
            sources.add(s);
        }
        return sources;
    }

    private boolean isSupported(VirtualFile file) {
        int length = this.mimeTypes.length;
        for (int i = 0; i < length; ++i) {
            if (!this.mimeTypes[i].equals(file.getMimeType())) continue;
            return true;
        }
        return false;
    }

    String[] getMimeTypes() {
        return this.mimeTypes;
    }

    Collection<Source> sources() {
        return this.sources.values();
    }

    public static class UnsupportedFileType
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -149187184530224369L;
        public final String name;

        public UnsupportedFileType(String name) {
            this.name = name;
        }
    }
}

