/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import macromedia.asc.embedding.Main;
import macromedia.asc.util.ObjectList;

public class Shell {
    private static int counter;
    private static boolean exit;
    private static Map targets;
    private static Map processes;

    public static void main(String[] args) throws IOException {
        String s;
        exit = false;
        counter = 1;
        targets = new HashMap();
        processes = new HashMap();
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        Shell.intro();
        Shell.prompt();
        while ((s = r.readLine()) != null) {
            try {
                Shell.process(s);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (exit) break;
            Shell.prompt();
        }
    }

    private static void process(String s) {
        block44: {
            if (s.startsWith("asc")) {
                StringTokenizer t = new StringTokenizer(s.substring("asc".length()).trim(), " ");
                String[] args = new String[t.countTokens()];
                int i = 0;
                while (t.hasMoreTokens()) {
                    args[i] = t.nextToken();
                    ++i;
                }
                if (args.length == 1) {
                    try {
                        int id = Integer.parseInt(args[0]);
                        Target target = (Target)targets.get("" + id);
                        if (target == null) {
                            System.out.println("ash: Target " + id + " not found");
                            break block44;
                        }
                        Shell.asc(target.args, id);
                    }
                    catch (NumberFormatException ex) {
                        System.out.println("ash: Assigned " + counter + " as the compile target id");
                        Shell.asc(args, counter++);
                    }
                } else {
                    System.out.println("ash: Assigned " + counter + " as the compile target id");
                    Shell.asc(args, counter++);
                }
            } else if (s.startsWith("run")) {
                String id = s.substring("run".length()).trim();
                if (targets.containsKey(id)) {
                    Shell.run(id);
                } else {
                    System.out.println("ash: Target " + id + " not found");
                }
            } else if (s.startsWith("trace")) {
                String mode = s.substring("trace".length()).trim();
                if ("on".equalsIgnoreCase(mode)) {
                    Shell.trace(true);
                } else if ("off".equalsIgnoreCase(mode)) {
                    Shell.trace(false);
                }
            } else if (s.equals("mm.cfg")) {
                Shell.mmcfg();
            } else if (s.startsWith("clear")) {
                String id = s.substring("clear".length()).trim();
                if (id.length() == 0) {
                    HashSet keys = new HashSet(targets.keySet());
                    Iterator i = keys.iterator();
                    while (i.hasNext()) {
                        Shell.clear((String)i.next());
                    }
                } else if (targets.containsKey(id)) {
                    Shell.clear(id);
                } else {
                    System.out.println("ash: Target " + id + " not found");
                }
            } else if (s.startsWith("info")) {
                String id = s.substring("info".length()).trim();
                if (id.length() == 0) {
                    HashSet keys = new HashSet(targets.keySet());
                    Iterator i = keys.iterator();
                    while (i.hasNext()) {
                        Shell.info((String)i.next());
                    }
                } else if (targets.containsKey(id)) {
                    Shell.info(id);
                } else {
                    System.out.println("ash: Target " + id + " not found");
                }
            } else if (s.startsWith("touch")) {
                String args = s.substring("touch".length()).trim();
                StringTokenizer stok = new StringTokenizer(args);
                while (stok.hasMoreTokens()) {
                    String f = stok.nextToken();
                    if (!new File(f).canWrite()) {
                        System.out.println("touch: cannot write " + f);
                        continue;
                    }
                    System.out.println("touched file: " + f);
                    new File(f).setLastModified(System.currentTimeMillis());
                }
            } else if (s.equals("quit")) {
                HashSet names = new HashSet(targets.keySet());
                Iterator i = names.iterator();
                while (i.hasNext()) {
                    Shell.process("clear " + (String)i.next());
                }
                exit = true;
            } else if (s.equals("memory")) {
                Shell.peakMemoryUsage();
            } else if (s.equals("gc")) {
                System.gc();
            } else {
                Shell.cmdList();
            }
        }
    }

    private static MemoryUsage getMemoryUsageInBytes() {
        long heapUsed = 0L;
        long nonHeapUsed = 0L;
        try {
            Class<?> mfCls = Class.forName("java.lang.management.ManagementFactory");
            Class<?> mpCls = Class.forName("java.lang.management.MemoryPoolMXBean");
            Class<?> memCls = Class.forName("java.lang.management.MemoryUsage");
            Class<?> typeCls = Class.forName("java.lang.management.MemoryType");
            Class[] emptyCls = new Class[]{};
            Object[] emptyObj = new Object[]{};
            Method getMemPoolMeth = mfCls.getMethod("getMemoryPoolMXBeans", emptyCls);
            Method getPeakUsageMeth = mpCls.getMethod("getPeakUsage", emptyCls);
            Method getTypeMeth = mpCls.getMethod("getType", emptyCls);
            Field heapField = typeCls.getField("HEAP");
            Method resetPeakUsageMeth = mpCls.getMethod("resetPeakUsage", emptyCls);
            Method getUsedMeth = memCls.getMethod("getUsed", emptyCls);
            List list = (List)getMemPoolMeth.invoke(null, emptyObj);
            for (Object memPoolObj : list) {
                Object memUsageObj = getPeakUsageMeth.invoke(memPoolObj, emptyObj);
                Object memTypeObj = getTypeMeth.invoke(memPoolObj, emptyObj);
                Long used = (Long)getUsedMeth.invoke(memUsageObj, emptyObj);
                if (heapField.get(typeCls) == memTypeObj) {
                    heapUsed += used.longValue();
                } else {
                    nonHeapUsed += used.longValue();
                }
                resetPeakUsageMeth.invoke(memPoolObj, emptyObj);
            }
            return new MemoryUsage(heapUsed, nonHeapUsed);
        }
        catch (Exception exception) {
            return new MemoryUsage(heapUsed, nonHeapUsed);
        }
    }

    public static long peakMemoryUsage() {
        return Shell.peakMemoryUsage(true);
    }

    public static long peakMemoryUsage(boolean display) {
        MemoryUsage mem = Shell.getMemoryUsageInBytes();
        long mbHeapUsed = mem.heap / 0x100000L;
        long mbNonHeapUsed = mem.nonHeap / 0x100000L;
        if (display && mem.heap != 0L && mem.nonHeap != 0L) {
            System.out.println(new MemoryUsage(mbHeapUsed, mbNonHeapUsed));
        }
        return mbHeapUsed + mbNonHeapUsed;
    }

    private static void clear(String target) {
        Process p = (Process)processes.remove(target);
        if (p != null) {
            p.destroy();
        }
        Target s = (Target)targets.remove(target);
    }

    private static void info(String target) {
        Target s = (Target)targets.get(target);
        System.out.println("id: " + s.id);
        StringBuilder b = new StringBuilder();
        int size = s.args.length;
        for (int i = 0; i < size; ++i) {
            b.append(s.args[i]);
            b.append(' ');
        }
        System.out.println("asc: " + b);
    }

    private static void run(String target) {
        Process p = (Process)processes.get(target);
        Target t = (Target)targets.get(target);
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < t.args.length; ++i) {
            String arg = t.args[i];
            if (arg.startsWith("-") || arg.equalsIgnoreCase("global.abc") || !arg.endsWith(".as") && !arg.endsWith(".abc")) continue;
            if (arg.endsWith(".as")) {
                arg = arg.substring(0, arg.length() - 3) + ".abc";
            }
            l.add(arg);
        }
        String[] cmdArray = new String[l.size() + 1];
        BufferedInputStream stdout = null;
        BufferedInputStream stderr = null;
        try {
            int j;
            File player = new File(new File(System.getProperty("application.home"), "bin"), "avmplus.exe");
            if (p != null) {
                p.destroy();
            }
            cmdArray[0] = player.getAbsolutePath();
            for (j = 0; j < l.size(); ++j) {
                cmdArray[j + 1] = (String)l.get(j);
            }
            System.out.print("Using ");
            for (j = 0; j < cmdArray.length; ++j) {
                System.out.print(cmdArray[j] + " ");
            }
            System.out.println();
            p = Runtime.getRuntime().exec(cmdArray);
            processes.put(target, p);
            stdout = new BufferedInputStream(p.getInputStream());
            stderr = new BufferedInputStream(p.getErrorStream());
            Shell.streamOutput(stdout, System.out);
            Shell.streamOutput(stdout, System.err);
            p.waitFor();
        }
        catch (Throwable ex) {
            if (p != null) {
                p.destroy();
            }
            if (stdout != null) {
                try {
                    stdout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (stderr != null) {
                try {
                    stderr.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void streamOutput(InputStream in, OutputStream out) throws IOException {
        int len = 8192;
        byte[] bytes = new byte[len];
        while ((len = in.read(bytes, 0, len)) != -1) {
            out.write(bytes, 0, len);
        }
        out.flush();
    }

    private static void asc(String[] args, int id) {
        Target s = new Target();
        s.id = id;
        s.args = args;
        targets.put("" + id, s);
        try {
            Main.show_parsetrees = false;
            Main.show_instructions = false;
            Main.show_linenums = false;
            Main.show_bytes = false;
            Main.show_machinecode = false;
            Main.show_flow = false;
            Main.emit_debug_info = false;
            Main.emit_doc_info = false;
            Main.do_test = false;
            Main.do_help = false;
            Main.filespecFound = false;
            Main.make_movieclip = false;
            Main.lint_mode = false;
            Main.use_static_semantics = false;
            Main.sanity_mode = false;
            Main.emit_metadata = false;
            Main.log = false;
            Main.earliest_dialect = 7;
            Main.latest_dialect = 10;
            Main.dialect = Main.default_dialect = 9;
            Main.optimize = false;
            Main.optimizer_configs = null;
            Main.include_filespecs = new ObjectList();
            Main.import_filespecs = new ObjectList();
            Main.use_namespaces = new ObjectList();
            Main.swf_options = "";
            Main.language = "EN";
            Main.main(args);
            System.setErr(Main.stderr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void trace(boolean on) {
        Shell.modifyPlayerConfiguration("TraceOutputFileEnable=", on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File f) {
        BufferedReader file = null;
        StringBuilder buffer = new StringBuilder((int)f.length());
        String lineSep = System.getProperty("line.separator");
        try {
            file = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String s = null;
            while ((s = file.readLine()) != null) {
                buffer.append(s);
                buffer.append(lineSep);
            }
            String string = buffer.toString();
            return string;
        }
        catch (FileNotFoundException ex) {
            String string = null;
            return string;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, String output) throws FileNotFoundException, IOException {
        File file = new File(fileName);
        if (file == null) {
            throw new FileNotFoundException(fileName);
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        try {
            out.write(output);
            ((Writer)out).flush();
        }
        finally {
            ((Writer)out).close();
        }
    }

    private static void modifyPlayerConfiguration(String key, boolean on) {
        String mmcfg;
        int index;
        File parent = new File(System.getProperty("user.home"));
        File f = new File(parent, "mm.cfg");
        if (f != null && f.exists() && (index = (mmcfg = Shell.readFile(f)).indexOf(key)) != -1) {
            mmcfg = mmcfg.substring(0, index + key.length()) + (on ? "1" : "0") + mmcfg.substring(index + key.length() + 1);
            try {
                Shell.writeFile(f.getAbsolutePath(), mmcfg);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            Shell.mmcfg();
        }
    }

    private static void mmcfg() {
        File parent = new File(System.getProperty("user.home"));
        System.out.println("ash: Trying to open mm.cfg in " + parent);
        File f = new File(parent, "mm.cfg");
        if (f != null && f.exists()) {
            System.out.println(Shell.readFile(f).trim());
        }
    }

    private static void intro() {
        System.out.println("Actionscript compiler SHell (ash)");
        System.out.println("Copyright 2017 The Apache Software Foundation");
        System.out.println("");
    }

    private static void prompt() {
        System.out.print("(ash) ");
    }

    private static void cmdList() {
        System.out.println("List of ash commands:");
        System.out.println("asc arg1 arg2 ...        compile; return a target id");
        System.out.println("run id                   run avmplus");
        System.out.println("clear [id]               clear target(s)");
        System.out.println("info [id]                display compile target info");
        System.out.println("gc                       run garbage collection");
        System.out.println("memory                   display current memory usage");
        System.out.println("mm.cfg                   display mm.cfg information");
        System.out.println("trace on|off             set tracing in mm.cfg");
        System.out.println("touch file1 file2...     modifies file timestamp");
        System.out.println("quit                     quit");
    }

    static class Target {
        public int id;
        public String[] args;

        Target() {
        }
    }

    public static class MemoryUsage {
        public long heap;
        public long nonHeap;
        public long total;

        public MemoryUsage(long heap, long nonHeap) {
            this.heap = heap;
            this.nonHeap = nonHeap;
            this.total = heap + nonHeap;
        }

        public void add(MemoryUsage mem) {
            this.heap += mem.heap;
            this.nonHeap += mem.nonHeap;
            this.total += mem.total;
        }

        public void subtract(MemoryUsage mem) {
            this.heap -= mem.heap;
            this.nonHeap -= mem.nonHeap;
            this.total -= mem.total;
        }

        public String toString() {
            return "Peak Memory Usage: " + this.total + " Mb (Heap: " + this.heap + " Mb, Non-Heap: " + this.nonHeap + " Mb)";
        }
    }
}

