/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.batik.css.parser;

import org.w3c.css.sac.LexicalUnit;

public abstract class CSSLexicalUnit
implements LexicalUnit {
    public static final String UNIT_TEXT_CENTIMETER = "cm";
    public static final String UNIT_TEXT_DEGREE = "deg";
    public static final String UNIT_TEXT_EM = "em";
    public static final String UNIT_TEXT_EX = "ex";
    public static final String UNIT_TEXT_GRADIAN = "grad";
    public static final String UNIT_TEXT_HERTZ = "Hz";
    public static final String UNIT_TEXT_INCH = "in";
    public static final String UNIT_TEXT_KILOHERTZ = "kHz";
    public static final String UNIT_TEXT_MILLIMETER = "mm";
    public static final String UNIT_TEXT_MILLISECOND = "ms";
    public static final String UNIT_TEXT_PERCENTAGE = "%";
    public static final String UNIT_TEXT_PICA = "pc";
    public static final String UNIT_TEXT_PIXEL = "px";
    public static final String UNIT_TEXT_POINT = "pt";
    public static final String UNIT_TEXT_RADIAN = "rad";
    public static final String UNIT_TEXT_REAL = "";
    public static final String UNIT_TEXT_SECOND = "s";
    public static final String UNIT_TEXT_DPI = "dpi";
    public static final String UNIT_TEXT_DPCM = "dpcm";
    public static final String TEXT_RGBCOLOR = "rgb";
    public static final String TEXT_RECT_FUNCTION = "rect";
    public static final String TEXT_COUNTER_FUNCTION = "counter";
    public static final String TEXT_COUNTERS_FUNCTION = "counters";
    protected short lexicalUnitType;
    protected LexicalUnit nextLexicalUnit;
    protected LexicalUnit previousLexicalUnit;
    protected int lineNumber;

    protected CSSLexicalUnit(short t, LexicalUnit prev, int lineNumber) {
        this.lexicalUnitType = t;
        this.previousLexicalUnit = prev;
        if (prev != null) {
            ((CSSLexicalUnit)prev).nextLexicalUnit = this;
        }
        this.lineNumber = lineNumber;
    }

    @Override
    public short getLexicalUnitType() {
        return this.lexicalUnitType;
    }

    @Override
    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public void setNextLexicalUnit(LexicalUnit lu) {
        this.nextLexicalUnit = lu;
    }

    @Override
    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    public void setPreviousLexicalUnit(LexicalUnit lu) {
        this.previousLexicalUnit = lu;
    }

    @Override
    public int getIntegerValue() {
        throw new IllegalStateException();
    }

    @Override
    public float getFloatValue() {
        throw new IllegalStateException();
    }

    @Override
    public String getDimensionUnitText() {
        switch (this.lexicalUnitType) {
            case 19: {
                return UNIT_TEXT_CENTIMETER;
            }
            case 28: {
                return UNIT_TEXT_DEGREE;
            }
            case 43: {
                return UNIT_TEXT_DPI;
            }
            case 44: {
                return UNIT_TEXT_DPCM;
            }
            case 15: {
                return UNIT_TEXT_EM;
            }
            case 16: {
                return UNIT_TEXT_EX;
            }
            case 29: {
                return UNIT_TEXT_GRADIAN;
            }
            case 33: {
                return UNIT_TEXT_HERTZ;
            }
            case 18: {
                return UNIT_TEXT_INCH;
            }
            case 34: {
                return UNIT_TEXT_KILOHERTZ;
            }
            case 20: {
                return UNIT_TEXT_MILLIMETER;
            }
            case 31: {
                return UNIT_TEXT_MILLISECOND;
            }
            case 23: {
                return UNIT_TEXT_PERCENTAGE;
            }
            case 22: {
                return UNIT_TEXT_PICA;
            }
            case 17: {
                return UNIT_TEXT_PIXEL;
            }
            case 21: {
                return UNIT_TEXT_POINT;
            }
            case 30: {
                return UNIT_TEXT_RADIAN;
            }
            case 14: {
                return UNIT_TEXT_REAL;
            }
            case 32: {
                return UNIT_TEXT_SECOND;
            }
        }
        throw new IllegalStateException("No Unit Text for type: " + this.lexicalUnitType);
    }

    @Override
    public String getFunctionName() {
        throw new IllegalStateException();
    }

    @Override
    public LexicalUnit getParameters() {
        throw new IllegalStateException();
    }

    @Override
    public String getStringValue() {
        throw new IllegalStateException();
    }

    @Override
    public LexicalUnit getSubValues() {
        throw new IllegalStateException();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public static CSSLexicalUnit createSimple(short t, LexicalUnit prev) {
        return new SimpleLexicalUnit(t, prev, -1);
    }

    public static CSSLexicalUnit createSimple(short t, LexicalUnit prev, int lineNumber) {
        return new SimpleLexicalUnit(t, prev, lineNumber);
    }

    public static CSSLexicalUnit createInteger(int val, LexicalUnit prev) {
        return new IntegerLexicalUnit(val, prev, -1);
    }

    public static CSSLexicalUnit createInteger(int val, LexicalUnit prev, int lineNumber) {
        return new IntegerLexicalUnit(val, prev, lineNumber);
    }

    public static CSSLexicalUnit createFloat(short t, float val, LexicalUnit prev) {
        return new FloatLexicalUnit(t, val, prev, -1);
    }

    public static CSSLexicalUnit createFloat(short t, float val, LexicalUnit prev, int lineNumber) {
        return new FloatLexicalUnit(t, val, prev, lineNumber);
    }

    public static CSSLexicalUnit createDimension(float val, String dim, LexicalUnit prev) {
        return new DimensionLexicalUnit(val, dim, prev, -1);
    }

    public static CSSLexicalUnit createDimension(float val, String dim, LexicalUnit prev, int lineNumber) {
        return new DimensionLexicalUnit(val, dim, prev, lineNumber);
    }

    public static CSSLexicalUnit createFunction(String f, LexicalUnit params, LexicalUnit prev) {
        return new FunctionLexicalUnit(f, params, prev, -1);
    }

    public static CSSLexicalUnit createFunction(String f, LexicalUnit params, LexicalUnit prev, int lineNumber) {
        return new FunctionLexicalUnit(f, params, prev, lineNumber);
    }

    public static CSSLexicalUnit createPredefinedFunction(short t, LexicalUnit params, LexicalUnit prev) {
        return new PredefinedFunctionLexicalUnit(t, params, prev, -1);
    }

    public static CSSLexicalUnit createPredefinedFunction(short t, LexicalUnit params, LexicalUnit prev, int lineNumber) {
        return new PredefinedFunctionLexicalUnit(t, params, prev, lineNumber);
    }

    public static CSSLexicalUnit createString(short t, String val, LexicalUnit prev) {
        return new StringLexicalUnit(t, val, prev, -1);
    }

    public static CSSLexicalUnit createString(short t, String val, LexicalUnit prev, int lineNumber) {
        return new StringLexicalUnit(t, val, prev, lineNumber);
    }

    public abstract void appendToStringBuffer(StringBuffer var1);

    protected void appendNextToStringBuffer(StringBuffer buf) {
        if (this.nextLexicalUnit != null) {
            buf.append(' ');
            ((CSSLexicalUnit)this.nextLexicalUnit).appendToStringBuffer(buf);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.appendToStringBuffer(buf);
        return buf.toString();
    }

    protected static class StringLexicalUnit
    extends CSSLexicalUnit {
        protected String value;

        public StringLexicalUnit(short t, String val, LexicalUnit prev, int lineNumber) {
            super(t, prev, lineNumber);
            this.value = val;
        }

        @Override
        public String getStringValue() {
            return this.value;
        }

        @Override
        public void appendToStringBuffer(StringBuffer buf) {
            buf.append('\"');
            buf.append(this.value.replace('\"', '\''));
            buf.append('\"');
            this.appendNextToStringBuffer(buf);
        }
    }

    protected static class PredefinedFunctionLexicalUnit
    extends CSSLexicalUnit {
        protected LexicalUnit parameters;

        public PredefinedFunctionLexicalUnit(short t, LexicalUnit params, LexicalUnit prev, int lineNumber) {
            super(t, prev, lineNumber);
            this.parameters = params;
        }

        @Override
        public String getFunctionName() {
            switch (this.lexicalUnitType) {
                case 27: {
                    return CSSLexicalUnit.TEXT_RGBCOLOR;
                }
                case 38: {
                    return CSSLexicalUnit.TEXT_RECT_FUNCTION;
                }
                case 25: {
                    return CSSLexicalUnit.TEXT_COUNTER_FUNCTION;
                }
                case 26: {
                    return CSSLexicalUnit.TEXT_COUNTERS_FUNCTION;
                }
            }
            return super.getFunctionName();
        }

        @Override
        public LexicalUnit getParameters() {
            return this.parameters;
        }

        private String getName() {
            switch (this.getLexicalUnitType()) {
                case 25: {
                    return CSSLexicalUnit.TEXT_COUNTER_FUNCTION;
                }
                case 26: {
                    return CSSLexicalUnit.TEXT_COUNTERS_FUNCTION;
                }
                case 27: {
                    return CSSLexicalUnit.TEXT_RGBCOLOR;
                }
                case 38: {
                    return CSSLexicalUnit.TEXT_RECT_FUNCTION;
                }
            }
            throw new Error("Internal CSS parser error!");
        }

        @Override
        public void appendToStringBuffer(StringBuffer buf) {
            buf.append(this.getName());
            buf.append('(');
            ((CSSLexicalUnit)this.parameters).appendToStringBuffer(buf);
            buf.append(')');
            this.appendNextToStringBuffer(buf);
        }
    }

    protected static class FunctionLexicalUnit
    extends CSSLexicalUnit {
        protected String name;
        protected LexicalUnit parameters;

        public FunctionLexicalUnit(String f, LexicalUnit params, LexicalUnit prev, int lineNumber) {
            super((short)41, prev, lineNumber);
            this.name = f;
            this.parameters = params;
        }

        @Override
        public String getFunctionName() {
            return this.name;
        }

        @Override
        public LexicalUnit getParameters() {
            return this.parameters;
        }

        @Override
        public void appendToStringBuffer(StringBuffer buf) {
            buf.append(this.name);
            buf.append('(');
            ((CSSLexicalUnit)this.parameters).appendToStringBuffer(buf);
            buf.append(')');
            this.appendNextToStringBuffer(buf);
        }
    }

    protected static class DimensionLexicalUnit
    extends CSSLexicalUnit {
        protected float value;
        protected String dimension;

        public DimensionLexicalUnit(float val, String dim, LexicalUnit prev, int lineNumber) {
            super((short)42, prev, lineNumber);
            this.value = val;
            this.dimension = dim;
        }

        @Override
        public float getFloatValue() {
            return this.value;
        }

        @Override
        public String getDimensionUnitText() {
            return this.dimension;
        }

        @Override
        public void appendToStringBuffer(StringBuffer buf) {
            buf.append(this.value);
            buf.append(this.dimension);
            this.appendNextToStringBuffer(buf);
        }
    }

    protected static class FloatLexicalUnit
    extends CSSLexicalUnit {
        protected float value;

        public FloatLexicalUnit(short t, float val, LexicalUnit prev, int lineNumber) {
            super(t, prev, lineNumber);
            this.value = val;
        }

        @Override
        public float getFloatValue() {
            return this.value;
        }

        @Override
        public void appendToStringBuffer(StringBuffer buf) {
            buf.append(this.value);
            this.appendNextToStringBuffer(buf);
            buf.append(this.getDimensionUnitText());
        }
    }

    protected static class IntegerLexicalUnit
    extends CSSLexicalUnit {
        protected int value;

        public IntegerLexicalUnit(int val, LexicalUnit prev, int lineNumber) {
            super((short)13, prev, lineNumber);
            this.value = val;
        }

        @Override
        public int getIntegerValue() {
            return this.value;
        }

        @Override
        public void appendToStringBuffer(StringBuffer buf) {
            buf.append(this.value);
            this.appendNextToStringBuffer(buf);
        }
    }

    protected static class SimpleLexicalUnit
    extends CSSLexicalUnit {
        public SimpleLexicalUnit(short t, LexicalUnit prev, int lineNumber) {
            super(t, prev, lineNumber);
            if (t != 0 && t != 4 && t != 12) {
                throw new Error("Internal CSS parser error!");
            }
        }

        @Override
        public void appendToStringBuffer(StringBuffer buf) {
            switch (this.getLexicalUnitType()) {
                case 0: {
                    buf.append(',');
                    break;
                }
                case 4: {
                    buf.append('/');
                    break;
                }
                case 12: {
                    buf.append("inherit");
                    if (this.nextLexicalUnit == null) break;
                    buf.append(" ");
                }
            }
            if (this.nextLexicalUnit != null) {
                ((CSSLexicalUnit)this.nextLexicalUnit).appendToStringBuffer(buf);
            }
        }
    }
}

