/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.Isolate;
import flash.tools.debugger.SourceLocator;
import flash.tools.debugger.SwfInfo;
import flash.tools.debugger.Value;
import flash.tools.debugger.concrete.DIsolate;
import flash.tools.debugger.concrete.DLocation;
import flash.tools.debugger.concrete.DMessage;
import flash.tools.debugger.concrete.DModule;
import flash.tools.debugger.concrete.DProtocol;
import flash.tools.debugger.concrete.DProtocolNotifierIF;
import flash.tools.debugger.concrete.DStackContext;
import flash.tools.debugger.concrete.DSuspendInfo;
import flash.tools.debugger.concrete.DSwfInfo;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.DWatch;
import flash.tools.debugger.events.BreakEvent;
import flash.tools.debugger.events.ConsoleErrorFault;
import flash.tools.debugger.events.DebugEvent;
import flash.tools.debugger.events.DivideByZeroFault;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.events.FileListModifiedEvent;
import flash.tools.debugger.events.InvalidWithFault;
import flash.tools.debugger.events.IsolateCreateEvent;
import flash.tools.debugger.events.IsolateExitEvent;
import flash.tools.debugger.events.ProtoLimitFault;
import flash.tools.debugger.events.RecursionLimitFault;
import flash.tools.debugger.events.ScriptTimeoutFault;
import flash.tools.debugger.events.StackUnderFlowFault;
import flash.tools.debugger.events.SwfLoadedEvent;
import flash.tools.debugger.events.SwfUnloadedEvent;
import flash.tools.debugger.events.TraceEvent;
import flash.util.Trace;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class DManager
implements DProtocolNotifierIF,
SourceLocator {
    private final HashMap<String, String> m_parms;
    private final HashMap<Integer, DIsolate> m_isolates;
    private Isolate m_activeIsolate = DEFAULT_ISOLATE;
    private LinkedList<DebugEvent> m_event;
    private SourceLocator m_sourceLocator;
    private boolean m_squelchEnabled;
    private int m_playerVersion;
    private boolean m_sourceListModified;
    private byte[] m_actions;
    private String[] m_lastConstantPool;
    private String m_uri;
    private byte[] m_swf;
    private byte[] m_swd;
    private Map<String, String> m_options = new HashMap<String, String>();
    public static final String ARGUMENTS_MARKER = "$arguments";
    public static final String SCOPE_CHAIN_MARKER = "$scopechain";
    private static final DIsolate DEFAULT_ISOLATE = DIsolate.DEFAULT_ISOLATE;
    private Isolate m_inIsolate = DEFAULT_ISOLATE;
    private final Object m_inIsolateLock;
    private final Object m_activeIsolateLock;
    private boolean m_wideLines;
    private DManagerIsolateState m_mainState;
    private HashMap<Integer, DManagerIsolateState> m_isolateState;

    private DManagerIsolateState getIsolateState(int n) {
        if (n == 1) {
            return this.m_mainState;
        }
        DManagerIsolateState dManagerIsolateState = null;
        if (!this.m_isolateState.containsKey(n)) {
            dManagerIsolateState = new DManagerIsolateState();
            this.m_isolateState.put(n, dManagerIsolateState);
        } else {
            dManagerIsolateState = this.m_isolateState.get(n);
        }
        return dManagerIsolateState;
    }

    public DManager() {
        this.m_parms = new HashMap();
        this.m_isolates = new HashMap();
        this.m_isolates.put(1, DEFAULT_ISOLATE);
        this.m_event = new LinkedList();
        this.m_sourceLocator = null;
        this.m_squelchEnabled = false;
        this.m_lastConstantPool = null;
        this.m_playerVersion = -1;
        this.m_isolateState = new HashMap();
        this.m_mainState = new DManagerIsolateState();
        this.m_isolateState.put(1, this.m_mainState);
        this.m_inIsolateLock = new Object();
        this.m_activeIsolateLock = new Object();
        this.m_wideLines = false;
    }

    public void setWideLines(boolean bl) {
        this.m_wideLines = bl;
    }

    public String getURI() {
        return this.m_uri;
    }

    public byte[] getSWF() {
        return this.m_swf;
    }

    public byte[] getSWD() {
        return this.m_swd;
    }

    public byte[] getActions() {
        return this.m_actions;
    }

    public int getVersion() {
        return this.m_playerVersion;
    }

    public SourceLocator getSourceLocator() {
        return this.m_sourceLocator;
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_sourceLocator = sourceLocator;
    }

    public void enableChildAttach(boolean bl, int n) {
        this.getIsolateState((int)n).m_attachChildren = bl;
    }

    public DVariable lastVariable(int n) {
        return this.getIsolateState((int)n).m_lastInGetVariable;
    }

    public void clearLastVariable(int n) {
        this.getIsolateState((int)n).m_lastInGetVariable = null;
    }

    public DVariable lastFunctionCall(int n) {
        return this.getIsolateState((int)n).m_lastInCallFunction;
    }

    public void clearLastFunctionCall(int n) {
        this.getIsolateState((int)n).m_lastInCallFunction = null;
    }

    public DVariable lastBinaryOp(int n) {
        return this.getIsolateState((int)n).m_lastInBinaryOp;
    }

    public void clearLastBinaryOp(int n) {
        this.getIsolateState((int)n).m_lastInBinaryOp = null;
    }

    void freeCaches(int n) {
        this.clearFrames(n);
        this.freeValueCache(n);
    }

    void freeValueCache(int n) {
        DManagerIsolateState dManagerIsolateState = this.getIsolateState(n);
        dManagerIsolateState.m_previousValues = dManagerIsolateState.m_values;
        dManagerIsolateState.m_values = new HashMap<Long, DValue>();
        int n2 = this.getFrameCount(n);
        for (int i = 0; i < n2; ++i) {
            this.getFrame(i, n).markStale();
        }
    }

    void continuing(int n) {
        this.freeCaches(n);
        this.getIsolateState((int)n).m_suspendInfo = null;
    }

    DValue getOrCreateValue(long l, int n) {
        DValue dValue = this.getValue(l, n);
        if (dValue == null) {
            dValue = new DValue(l, n);
            this.putValue(l, dValue, n);
        }
        return dValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSwfInfo[] getSwfInfos(int n) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.getIsolateState(n).m_swfInfo;
        synchronized (arrayList2) {
            return arrayList.toArray(new DSwfInfo[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSwfInfo getSwfInfo(int n, int n2) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.getIsolateState(n2).m_swfInfo;
        synchronized (arrayList2) {
            return (DSwfInfo)arrayList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSwfInfoCount(int n) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.getIsolateState(n).m_swfInfo;
        synchronized (arrayList2) {
            return arrayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DSwfInfo getOrCreateSwfInfo(int n, int n2) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.getIsolateState(n2).m_swfInfo;
        synchronized (arrayList2) {
            DSwfInfo dSwfInfo;
            DSwfInfo dSwfInfo2 = dSwfInfo = n > -1 && n < this.getSwfInfoCount(n2) ? this.getSwfInfo(n, n2) : null;
            if (dSwfInfo == null) {
                int n3 = n = n < 0 ? 0 : n;
                while (n >= arrayList.size()) {
                    arrayList.add(null);
                }
                dSwfInfo = new DSwfInfo(n, n2);
                arrayList.set(n, dSwfInfo);
            }
            return dSwfInfo;
        }
    }

    DSwfInfo getActiveSwfInfo(int n) {
        int n2 = this.getSwfInfoCount(n);
        DSwfInfo dSwfInfo = this.getIsolateState((int)n).m_lastSwfInfo;
        if (dSwfInfo == null) {
            dSwfInfo = this.getOrCreateSwfInfo(n2 - 1, n);
        }
        if (dSwfInfo.hasAllSource()) {
            dSwfInfo = this.getOrCreateSwfInfo(n2, n);
        }
        return dSwfInfo;
    }

    void tieScriptsToSwf(DSwfInfo dSwfInfo, int n) {
        if (!dSwfInfo.hasAllSource()) {
            int n2 = dSwfInfo.getFirstSourceId();
            int n3 = dSwfInfo.getLastSourceId();
            for (int i = n2; i <= n3; ++i) {
                DModule dModule = this.getSource(i, n);
                if (dModule == null) continue;
                dSwfInfo.addSource(i, dModule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putSource(int n, int n2, int n3, String string, String string2, int n4) {
        Map<Integer, DModule> map;
        Map<Integer, DModule> map2 = map = this.getIsolateState((int)n4).m_source;
        synchronized (map2) {
            if (!map.containsKey(n2)) {
                DModule dModule = new DModule(this, n2, n3, string, string2, n4);
                map.put(n2, dModule);
                DSwfInfo dSwfInfo = n == -1 ? this.getActiveSwfInfo(n4) : this.getOrCreateSwfInfo(n, n4);
                dSwfInfo.addSource(n2, dModule);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeSource(int n, int n2) {
        Map<Integer, DModule> map;
        Map<Integer, DModule> map2 = map = this.getIsolateState((int)n2).m_source;
        synchronized (map2) {
            try {
                map.remove(n);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DModule getSource(int n, int n2) {
        Map<Integer, DModule> map;
        Map<Integer, DModule> map2 = map = this.getIsolateState((int)n2).m_source;
        synchronized (map2) {
            return map.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DModule[] getSources() {
        Map<Integer, DModule> map;
        Map<Integer, DModule> map2 = map = this.getIsolateState((int)1).m_source;
        synchronized (map2) {
            this.m_sourceListModified = false;
            int n = map.size();
            DModule[] dModuleArray = new DModule[n];
            n = 0;
            for (DModule dModule : map.values()) {
                dModuleArray[n++] = dModule;
            }
            return dModuleArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sourceListModified() {
        Map<Integer, DModule> map;
        Map<Integer, DModule> map2 = map = this.getIsolateState((int)1).m_source;
        synchronized (map2) {
            return this.m_sourceListModified;
        }
    }

    public DValue getValue(long l, int n) {
        return this.getIsolateState((int)n).m_values.get(l);
    }

    public DValue getPreviousValue(long l, int n) {
        return this.getIsolateState((int)n).m_previousValues.get(l);
    }

    void putValue(long l, DValue dValue, int n) {
        if (l != -1L) {
            this.getIsolateState((int)n).m_values.put(l, dValue);
        }
    }

    DValue removeValue(long l, int n) {
        return this.getIsolateState((int)n).m_values.remove((int)l);
    }

    void addVariableMember(long l, DVariable dVariable, int n) {
        DValue dValue = this.getValue(l, n);
        this.addVariableMember(dValue, dVariable, n);
    }

    void addVariableMember(DValue dValue, DVariable dVariable, int n) {
        if (this.getIsolateState((int)n).m_attachChildren) {
            long l;
            Object object;
            if (dValue != null) {
                object = dValue.findMember(dVariable.getName());
                if (object != null) {
                    int n2 = ((DVariable)object).getScope();
                    int n3 = dVariable.getScope();
                    if (n2 == 0x2000000 && n3 == 0) {
                        dValue.addMember(dVariable);
                    } else if (n2 == 0 && n3 == 0x2000000) {
                        dVariable.makePublic();
                        dValue.addMember(dVariable);
                    } else if (n2 != 0x800000 && n2 == n3) {
                        dValue.addMember(dVariable);
                    } else if (n2 == 0x800000 && n2 == n3) {
                        dValue.addInheritedPrivateMember(dVariable);
                    }
                } else {
                    dValue.addMember(dVariable);
                }
            }
            if ((l = ((DValue)(object = (DValue)dVariable.getValue())).getId()) != -1L) {
                DValue dValue2 = this.getValue(l, n);
                if (dValue2 != null) {
                    assert (dValue2 == object);
                } else {
                    this.putValue(l, (DValue)object, n);
                }
            }
        }
    }

    void addVariableMember(long l, DVariable dVariable, long l2, int n) {
        this.addVariableMember(l, dVariable, n);
        if (this.getIsolateState((int)n).m_attachChildren) {
            this.putValue(l2, (DValue)dVariable.getValue(), n);
        }
    }

    public String[] getConstantPool() {
        return this.m_lastConstantPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLocation getBreakpoint(int n, int n2) {
        ArrayList<DLocation> arrayList;
        ArrayList<DLocation> arrayList2 = arrayList = this.getIsolateState((int)n2).m_breakpoints;
        synchronized (arrayList2) {
            DLocation dLocation = null;
            int n3 = this.findBreakpoint(n, n2);
            if (n3 > -1) {
                dLocation = arrayList.get(n3);
            }
            return dLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findBreakpoint(int n, int n2) {
        ArrayList<DLocation> arrayList;
        ArrayList<DLocation> arrayList2 = arrayList = this.getIsolateState((int)n2).m_breakpoints;
        synchronized (arrayList2) {
            int n3 = -1;
            int n4 = arrayList.size();
            for (int i = 0; n3 < 0 && i < n4; ++i) {
                DLocation dLocation = arrayList.get(i);
                if (dLocation.getId() != n) continue;
                n3 = i;
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DLocation removeBreakpoint(int n, int n2) {
        ArrayList<DLocation> arrayList;
        ArrayList<DLocation> arrayList2 = arrayList = this.getIsolateState((int)n2).m_breakpoints;
        synchronized (arrayList2) {
            DLocation dLocation = null;
            int n3 = this.findBreakpoint(n, n2);
            if (n3 > -1) {
                dLocation = arrayList.get(n3);
                arrayList.remove(n3);
            }
            return dLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBreakpoint(int n, DLocation dLocation, int n2) {
        ArrayList<DLocation> arrayList;
        ArrayList<DLocation> arrayList2 = arrayList = this.getIsolateState((int)n2).m_breakpoints;
        synchronized (arrayList2) {
            arrayList.add(dLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DLocation[] getBreakpoints(int n) {
        ArrayList<DLocation> arrayList;
        ArrayList<DLocation> arrayList2 = arrayList = this.getIsolateState((int)n).m_breakpoints;
        synchronized (arrayList2) {
            return arrayList.toArray(new DLocation[arrayList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DWatch getWatchpoint(int n, int n2) {
        DManagerIsolateState dManagerIsolateState = this.getIsolateState(n2);
        ArrayList arrayList = dManagerIsolateState.m_watchpoints;
        synchronized (arrayList) {
            return (DWatch)dManagerIsolateState.m_watchpoints.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWatchpointCount(int n) {
        DManagerIsolateState dManagerIsolateState = this.getIsolateState(n);
        ArrayList arrayList = dManagerIsolateState.m_watchpoints;
        synchronized (arrayList) {
            return dManagerIsolateState.m_watchpoints.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DWatch[] getWatchpoints(int n) {
        DManagerIsolateState dManagerIsolateState = this.getIsolateState(n);
        ArrayList arrayList = dManagerIsolateState.m_watchpoints;
        synchronized (arrayList) {
            return dManagerIsolateState.m_watchpoints.toArray(new DWatch[dManagerIsolateState.m_watchpoints.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addWatchpoint(DWatch dWatch, int n) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.getIsolateState(n).m_watchpoints;
        synchronized (arrayList2) {
            return arrayList.add(dWatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DWatch removeWatchpoint(int n, int n2) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.getIsolateState(n2).m_watchpoints;
        synchronized (arrayList2) {
            DWatch dWatch = null;
            int n3 = this.findWatchpoint(n, n2);
            if (n3 > -1) {
                dWatch = (DWatch)arrayList.remove(n3);
            }
            return dWatch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findWatchpoint(int n, int n2) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = this.getIsolateState(n2).m_watchpoints;
        synchronized (arrayList2) {
            int n3 = -1;
            int n4 = this.getWatchpointCount(n2);
            for (int i = 0; i < n4 && n3 < 0; ++i) {
                DWatch dWatch = this.getWatchpoint(i, n2);
                if (dWatch.getTag() != n) continue;
                n3 = i;
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DIsolate getIsolate(int n) {
        if (n == 1) {
            return DEFAULT_ISOLATE;
        }
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            return this.m_isolates.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DIsolate getOrCreateIsolate(int n) {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            if (this.m_isolates.containsKey(n)) {
                return this.m_isolates.get(n);
            }
            DIsolate dIsolate = new DIsolate(n);
            this.m_isolates.put(n, dIsolate);
            return dIsolate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIsolateCount() {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            return this.m_isolates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DIsolate[] getIsolates() {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            return this.m_isolates.values().toArray(new DIsolate[this.m_isolates.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addIsolate(DIsolate dIsolate) {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            this.m_isolates.put(dIsolate.getId(), dIsolate);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearIsolates() {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            this.m_isolates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DIsolate removeIsolate(int n) {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            DIsolate dIsolate = null;
            int n2 = this.findIsolate(n);
            if (n2 > -1) {
                dIsolate = this.m_isolates.remove(n2);
            }
            return dIsolate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findIsolate(int n) {
        HashMap<Integer, DIsolate> hashMap = this.m_isolates;
        synchronized (hashMap) {
            if (this.m_isolates.containsKey(n)) {
                return n;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActiveIsolate(Isolate isolate) {
        Object object = this.m_activeIsolateLock;
        synchronized (object) {
            this.m_activeIsolate = isolate == null ? DEFAULT_ISOLATE : isolate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Isolate getActiveIsolate() {
        Object object = this.m_activeIsolateLock;
        synchronized (object) {
            return this.m_activeIsolate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInIsolate(Isolate isolate) {
        Object object = this.m_inIsolateLock;
        synchronized (object) {
            this.m_inIsolate = isolate == null ? DEFAULT_ISOLATE : isolate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Isolate getInIsolate() {
        Object object = this.m_inIsolateLock;
        synchronized (object) {
            return this.m_inIsolate;
        }
    }

    Isolate getDefaultIsolate() {
        return DEFAULT_ISOLATE;
    }

    boolean addFrame(DStackContext dStackContext, int n) {
        this.getIsolateState((int)n).m_frames.add(dStackContext);
        return true;
    }

    void clearFrames(int n) {
        if (this.getIsolateState((int)n).m_frames.size() > 0) {
            this.getIsolateState((int)n).m_previousFrames = this.getIsolateState((int)n).m_frames;
        }
        this.getIsolateState((int)n).m_frames = new ArrayList();
    }

    public DStackContext getFrame(int n, int n2) {
        return this.getIsolateState((int)n2).m_frames.get(n);
    }

    public int getFrameCount(int n) {
        return this.getIsolateState((int)n).m_frames.size();
    }

    public DStackContext[] getFrames(int n) {
        ArrayList<DStackContext> arrayList = this.getIsolateState((int)n).m_frames;
        return arrayList.toArray(new DStackContext[arrayList.size()]);
    }

    private boolean stringsEqual(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private void mapOldFramesToNew(int n) {
        int n2;
        ArrayList<DStackContext> arrayList = null;
        ArrayList<DStackContext> arrayList2 = null;
        Map<Long, DValue> map = null;
        arrayList = this.getIsolateState((int)n).m_previousFrames;
        arrayList2 = this.getIsolateState((int)n).m_frames;
        map = this.getIsolateState((int)n).m_previousValues;
        int n3 = arrayList.size();
        int n4 = arrayList2.size();
        DValue[] dValueArray = new DValue[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dValueArray[n2] = map.remove(-100L - (long)n2);
        }
        n2 = n3 - 1;
        for (int i = n4 - 1; n2 >= 0 && i >= 0; --n2, --i) {
            DValue dValue;
            DStackContext dStackContext = arrayList.get(n2);
            DStackContext dStackContext2 = arrayList2.get(i);
            if (dStackContext == null || dStackContext2 == null || !this.stringsEqual(dStackContext.getCallSignature(), dStackContext2.getCallSignature()) || (dValue = dValueArray[n2]) == null) continue;
            map.put(-100L - (long)i, dValue);
        }
    }

    public boolean isGetSupported() {
        return this.m_squelchEnabled;
    }

    public DSuspendInfo getSuspendInfo(int n) {
        if (this.m_isolateState.containsKey(n)) {
            return this.m_isolateState.get((Object)Integer.valueOf((int)n)).m_suspendInfo;
        }
        return null;
    }

    public ArrayList<SwfInfo> getIsolateSwfList() {
        ArrayList<SwfInfo> arrayList = new ArrayList<SwfInfo>();
        for (DManagerIsolateState dManagerIsolateState : this.m_isolateState.values()) {
            if (dManagerIsolateState.m_swfInfo == null) continue;
            arrayList.addAll(dManagerIsolateState.m_swfInfo);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEventCount() {
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            return this.m_event.size();
        }
    }

    public Object getEventNotifier() {
        return this.m_event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugEvent nextEvent() {
        DebugEvent debugEvent = null;
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            if (this.m_event.size() > 0) {
                debugEvent = this.m_event.removeFirst();
            }
        }
        return debugEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEvent(DebugEvent debugEvent) {
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            this.m_event.add(debugEvent);
            this.m_event.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected() {
        LinkedList<DebugEvent> linkedList = this.m_event;
        synchronized (linkedList) {
            this.m_event.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageArrived(DMessage dMessage, DProtocol dProtocol) {
        int n;
        int n2 = dMessage.getType();
        int n3 = n = this.getInIsolate() != null ? this.getInIsolate().getId() : 1;
        if (n != 1) {
            dMessage.setTargetIsolate(n);
        }
        switch (n2) {
            case 26: {
                long l = dMessage.getDWord();
                this.m_playerVersion = (int)l;
                int n4 = dMessage.getRemaining() >= 1 ? dMessage.getByte() : 4;
                DMessage.setSizeofPtr(n4);
                break;
            }
            case 7: {
                this.handleFaultEvent(new RecursionLimitFault(dMessage.getTargetIsolate()));
                break;
            }
            case 8: {
                this.handleFaultEvent(new InvalidWithFault(dMessage.getTargetIsolate()));
                break;
            }
            case 9: {
                this.handleFaultEvent(new ProtoLimitFault(dMessage.getTargetIsolate()));
                break;
            }
            case 24: {
                break;
            }
            case 6: {
                break;
            }
            case 36: {
                Object object;
                String string;
                long l = dMessage.getDWord();
                boolean bl = false;
                Value value = null;
                if (dMessage.getRemaining() > 0) {
                    string = dMessage.getString();
                    if (dMessage.getRemaining() > 0 && dMessage.getByte() != 0) {
                        bl = dMessage.getByte() != 0;
                        dMessage.getPtr();
                        object = this.extractVariable(dMessage);
                        value = ((DVariable)object).getValue();
                    }
                } else {
                    string = "";
                }
                object = new ExceptionFault(string, bl, value, dMessage.getTargetIsolate());
                ((ExceptionFault)object).isolateId = dMessage.getTargetIsolate();
                this.handleFaultEvent((FaultEvent)object);
                break;
            }
            case 37: {
                this.handleFaultEvent(new StackUnderFlowFault(dMessage.getTargetIsolate()));
                break;
            }
            case 38: {
                this.handleFaultEvent(new DivideByZeroFault(dMessage.getTargetIsolate()));
                break;
            }
            case 39: {
                this.handleFaultEvent(new ScriptTimeoutFault(dMessage.getTargetIsolate()));
                break;
            }
            case 44: {
                String string = dMessage.getString();
                this.handleFaultEvent(new ConsoleErrorFault(string, dMessage.getTargetIsolate()));
                break;
            }
            case 5: {
                String string = dMessage.getString();
                this.addEvent(new TraceEvent(string));
                break;
            }
            case 29: {
                long l = dMessage.getDWord();
                this.m_squelchEnabled = l != 0L;
                break;
            }
            case 12: {
                String string = dMessage.getString();
                String string2 = dMessage.getString();
                this.m_parms.put(string, string2);
                if (!string.startsWith("movie")) break;
                this.m_uri = DManager.convertToURI(string2);
                break;
            }
            case 13: {
                long l = dMessage.getPtr();
                String string = dMessage.getString();
                break;
            }
            case 1: {
                long l = dMessage.getPtr();
                int n5 = dMessage.getWord();
                String string = dMessage.getString();
                break;
            }
            case 3: {
                long l = dMessage.getPtr();
                break;
            }
            case 4: {
                long l = dMessage.getPtr();
                break;
            }
            case 10: {
                long l = dMessage.getPtr();
                String string = dMessage.getString();
                int n6 = dMessage.getWord();
                int n7 = (int)dMessage.getDWord();
                String string3 = dMessage.getString();
                break;
            }
            case 11: {
                long l = dMessage.getPtr();
                String string = dMessage.getString();
                break;
            }
            case 14: {
                int n8 = (int)dMessage.getDWord();
                int n9 = (int)dMessage.getDWord();
                String string = dMessage.getString();
                String string4 = dMessage.getString();
                int n10 = -1;
                int n11 = -1;
                if (dMessage.getRemaining() >= 4) {
                    n10 = (int)dMessage.getDWord();
                }
                n11 = dMessage.getTargetIsolate();
                this.getOrCreateIsolate(n11);
                if (!this.putSource(n10, n8, n9, string, string4, n11)) break;
                if (!this.m_sourceListModified) {
                    this.addEvent(new FileListModifiedEvent());
                }
                this.m_sourceListModified = true;
                break;
            }
            case 21: {
                Map<Integer, DModule> map;
                long l = dMessage.getDWord();
                int n12 = dMessage.getTargetIsolate();
                Map<Integer, DModule> map2 = map = this.getIsolateState((int)n12).m_source;
                synchronized (map2) {
                    if (this.removeSource((int)l, n12)) {
                        if (!this.m_sourceListModified) {
                            this.addEvent(new FileListModifiedEvent());
                        }
                        this.m_sourceListModified = true;
                    }
                    break;
                }
            }
            case 15: {
                int n13 = dMessage.getTargetIsolate();
                DSuspendInfo dSuspendInfo = this.getIsolateState((int)n13).m_suspendInfo;
                if (dSuspendInfo != null) break;
                dSuspendInfo = new DSuspendInfo(7, 0, 0, 0, 0);
                break;
            }
            case 16: {
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                if (!this.m_wideLines) {
                    l = dMessage.getDWord();
                } else {
                    l3 = dMessage.getDWord();
                    l2 = dMessage.getDWord();
                }
                long l4 = dMessage.getPtr();
                String string = dMessage.getString();
                int n14 = dMessage.getTargetIsolate();
                int n15 = DLocation.decodeFile(l);
                int n16 = DLocation.decodeLine(l);
                if (this.m_wideLines) {
                    n15 = (int)l3;
                    n16 = (int)l2;
                }
                this.addEvent(new BreakEvent(n15, n16, n14));
                break;
            }
            case 17: {
                this.continuing(dMessage.getTargetIsolate());
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                long l = dMessage.getDWord();
                int n17 = dMessage.getTargetIsolate();
                while (l-- > 0L) {
                    long l5 = 0L;
                    long l6 = 0L;
                    long l7 = 0L;
                    if (!this.m_wideLines) {
                        l5 = dMessage.getDWord();
                    } else {
                        l6 = dMessage.getDWord();
                        l7 = dMessage.getDWord();
                    }
                    int n18 = DLocation.decodeFile(l5);
                    int n19 = DLocation.decodeLine(l5);
                    if (this.m_wideLines) {
                        n18 = (int)l6;
                        n19 = (int)l7;
                    }
                    DModule dModule = null;
                    dModule = this.getSource(n18, n17);
                    DLocation dLocation = new DLocation(dModule, n19, n17);
                    if (dModule == null) continue;
                    this.addBreakpoint((int)l5, dLocation, n17);
                }
                break;
            }
            case 20: {
                DSwfInfo dSwfInfo;
                int n20 = (int)dMessage.getDWord();
                int n21 = dMessage.getTargetIsolate();
                if (dMessage.getRemaining() >= 4) {
                    int n22 = (int)dMessage.getDWord();
                    this.getIsolateState((int)n21).m_lastSwfInfo = dSwfInfo = this.getOrCreateSwfInfo(n22, n21);
                } else {
                    dSwfInfo = this.getActiveSwfInfo(n21);
                }
                dSwfInfo.setSourceExpectedCount(n20);
                break;
            }
            case 22: {
                long l = dMessage.getDWord();
                int n23 = dMessage.getTargetIsolate();
                while (l-- > 0L) {
                    long l8 = dMessage.getDWord();
                    this.removeBreakpoint((int)l8, n23);
                }
                break;
            }
            case 27: {
                long l = 0L;
                long l9 = 0L;
                long l10 = 0L;
                if (!this.m_wideLines) {
                    l = dMessage.getDWord();
                } else {
                    l10 = dMessage.getDWord();
                    l9 = dMessage.getDWord();
                }
                long l11 = dMessage.getDWord();
                int n24 = dMessage.getTargetIsolate();
                this.clearFrames(n24);
                int n25 = 0;
                while (l11-- > 0L) {
                    long l12 = 0L;
                    long l13 = 0L;
                    long l14 = 0L;
                    if (!this.m_wideLines) {
                        l12 = dMessage.getDWord();
                    } else {
                        l14 = dMessage.getDWord();
                        l13 = dMessage.getDWord();
                    }
                    long l15 = dMessage.getPtr();
                    String string = dMessage.getString();
                    int n26 = DLocation.decodeFile(l12);
                    int n27 = DLocation.decodeLine(l12);
                    if (this.m_wideLines) {
                        n26 = (int)l14;
                        n27 = (int)l13;
                    }
                    DModule dModule = null;
                    dModule = this.getSource(n26, n24);
                    DStackContext dStackContext = new DStackContext(n26, n27, dModule, l15, string, n25, n24);
                    if (!this.addFrame(dStackContext, n24)) continue;
                    ++n25;
                }
                this.mapOldFramesToNew(n24);
                if (n24 == 1) break;
                this.appendIsolateInfoToFrame(n24);
                break;
            }
            case 31: {
                int n28;
                int n29;
                DValue dValue = null;
                DVariable dVariable = null;
                ArrayList<DVariable> arrayList = new ArrayList<DVariable>();
                ArrayList<DVariable> arrayList2 = new ArrayList<DVariable>();
                int n30 = dMessage.getTargetIsolate();
                int n31 = (int)dMessage.getDWord();
                if (n31 > -1) {
                    n29 = (int)dMessage.getDWord();
                    for (n28 = 0; n28 < n29; ++n28) {
                        arrayList2.add(this.extractRegister(dMessage, n28 + 1));
                    }
                }
                n29 = -1;
                n28 = 0;
                while (dMessage.getRemaining() > 0) {
                    long l = dMessage.getPtr();
                    if (dValue == null) {
                        dValue = this.getOrCreateValue(l, n30);
                        this.extractVariable(dMessage);
                        continue;
                    }
                    dVariable = this.extractVariable(dMessage);
                    if (n29 == -1 && dVariable.getName().equals(ARGUMENTS_MARKER)) {
                        n29 = 0;
                        n28 = 0;
                    } else if (dVariable.getName().equals(SCOPE_CHAIN_MARKER)) {
                        n29 = -1;
                        n28 = 1;
                    } else if (n29 >= 0) {
                        ++n29;
                        if (dVariable.getName().equals("undefined")) {
                            dVariable.setName("_arg" + n29);
                        }
                    }
                    if (n28 == 0) {
                        this.addVariableMember(l, dVariable, n30);
                    }
                    arrayList.add(dVariable);
                }
                if (n31 == 0) {
                    this.populateRootNode(dValue, arrayList, n30);
                    break;
                }
                this.populateFrame(n31, arrayList, n30);
                break;
            }
            case 32: {
                String string = dMessage.getString();
                String string5 = dMessage.getString();
                this.m_options.put(string, string5);
                break;
            }
            case 30: {
                DValue dValue = null;
                DVariable dVariable = null;
                String string = null;
                int n32 = 0;
                int n33 = dMessage.getTargetIsolate();
                int n34 = -1;
                ArrayList<String> arrayList = new ArrayList<String>();
                while (dMessage.getRemaining() > 0) {
                    int n35;
                    String string6;
                    long l = dMessage.getPtr();
                    if (dValue == null) {
                        string6 = dMessage.getString();
                        this.getIsolateState((int)n33).m_lastInGetVariable = this.extractVariable(dMessage, string6);
                        dValue = this.getOrCreateValue(l, n33);
                        continue;
                    }
                    dVariable = this.extractVariable(dMessage);
                    if (this.showMember(dVariable)) {
                        if (dVariable.isAttributeSet(131072)) {
                            if (arrayList.size() > 0) {
                                dVariable.setDefiningClass(0, (String)arrayList.get(0));
                                n34 = Math.max(n34, 0);
                            }
                        } else {
                            dVariable.setDefiningClass(n32, string);
                            if (string != null) {
                                n34 = Math.max(n34, n32);
                            }
                        }
                        this.addVariableMember(dValue.getId(), dVariable, n33);
                        continue;
                    }
                    if (!this.isTraits(dVariable)) continue;
                    string = dVariable.getQualifiedName();
                    n32 = arrayList.size();
                    if (string.endsWith("$") && (n35 = arrayList.indexOf(string6 = string.substring(0, string.length() - 1))) != -1) {
                        n32 = n35;
                        string = string6;
                    }
                    if (n32 != arrayList.size()) continue;
                    arrayList.add(string);
                }
                if (dValue == null || dValue.getClassHierarchy(true) != null) break;
                dValue.setClassHierarchy(arrayList.toArray(new String[arrayList.size()]), n34 + 1);
                break;
            }
            case 33: 
            case 55: {
                int n36 = dMessage.getWord();
                int n37 = dMessage.getWord();
                int n38 = dMessage.getWord();
                int n39 = dMessage.getWord();
                int n40 = dMessage.getWord();
                long l = n2 == 55 ? dMessage.getPtr() : (long)dMessage.getWord();
                String string = dMessage.getString();
                int n41 = dMessage.getTargetIsolate();
                if (n36 == 0) break;
                if (n39 == 0) {
                    this.removeWatchpoint(n38, n41);
                    break;
                }
                this.removeWatchpoint(n38, n41);
                DWatch dWatch = new DWatch(l, string, n39, n40, n41);
                this.addWatchpoint(dWatch, n41);
                break;
            }
            case 34: {
                this.m_swf = dMessage.getData();
                break;
            }
            case 35: {
                this.m_swd = dMessage.getData();
                break;
            }
            case 40: {
                int n42 = dMessage.getWord();
                int n43 = dMessage.getWord();
                int n44 = (int)dMessage.getDWord();
                int n45 = (int)dMessage.getDWord();
                int n46 = (int)dMessage.getDWord();
                int n47 = dMessage.getTargetIsolate();
                this.getIsolateState((int)n47).m_suspendInfo = new DSuspendInfo(n42, n43, n44, n45, n46);
                try {
                    DStackContext dStackContext = this.getFrame(0, n47);
                    dStackContext.setOffset(n44);
                    dStackContext.setSwfIndex(n43);
                }
                catch (Exception exception) {
                    if (!Trace.error) break;
                    Trace.trace("Oh my god, gag me with a spoon...getFrame(0) call failed");
                    exception.printStackTrace();
                }
                break;
            }
            case 41: {
                int n48 = dMessage.getWord();
                int n49 = dMessage.getWord();
                int n50 = (int)dMessage.getDWord();
                int n51 = (int)dMessage.getDWord();
                int n52 = 0;
                byte[] byArray = this.m_actions = n51 <= 0 ? null : new byte[n51];
                while (n51-- > 0) {
                    this.m_actions[n52++] = (byte)dMessage.getByte();
                }
                break;
            }
            case 42: {
                int n53 = dMessage.getWord();
                int n54 = dMessage.getTargetIsolate();
                for (int i = 0; i < n53; ++i) {
                    boolean bl;
                    long l = dMessage.getDWord();
                    long l16 = dMessage.getPtr();
                    DSwfInfo dSwfInfo = null;
                    this.getIsolateState((int)n54).m_lastSwfInfo = dSwfInfo = this.getOrCreateSwfInfo((int)l, n54);
                    if (l16 != 0L) {
                        boolean bl2;
                        bl = dMessage.getByte() != 0;
                        byte by = (byte)dMessage.getByte();
                        int n55 = dMessage.getWord();
                        long l17 = dMessage.getDWord();
                        long l18 = dMessage.getDWord();
                        long l19 = dMessage.getDWord();
                        long l20 = dMessage.getDWord();
                        long l21 = dMessage.getDWord();
                        long l22 = dMessage.getDWord();
                        String string = dMessage.getString();
                        String string7 = dMessage.getString();
                        String string8 = dMessage.getString();
                        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
                        int n56 = Integer.MAX_VALUE;
                        int n57 = Integer.MIN_VALUE;
                        if (l18 > 0L) {
                            long l23 = dMessage.getDWord();
                            int n58 = 0;
                            while ((long)n58 < l23 && dMessage.getRemaining() >= DMessage.getSizeofPtr()) {
                                long l24 = dMessage.getPtr();
                                int n59 = (int)dMessage.getDWord();
                                hashMap.put(l24, n59);
                                n56 = n59 < n56 ? n59 : n56;
                                n57 = n59 > n57 ? n59 : n57;
                                ++n58;
                            }
                        }
                        boolean bl3 = bl2 = dSwfInfo.getSwfSize() == 0;
                        if (by > 0) {
                            bl = false;
                            dSwfInfo.setVmVersion(by);
                            dSwfInfo.setPopulated();
                        }
                        dSwfInfo.freshen(l16, string, string7, string8, l22, bl, l17, l18, l21, l20, l19, hashMap, n56, n57);
                        this.tieScriptsToSwf(dSwfInfo, n54);
                        if (!bl2) continue;
                        this.addEvent(new SwfLoadedEvent(l16, (int)l, string, string7, string8, l22, l17));
                        continue;
                    }
                    bl = dSwfInfo.isUnloaded();
                    dSwfInfo.setUnloaded();
                    if (bl) continue;
                    this.addEvent(new SwfUnloadedEvent(dSwfInfo.getId(), dSwfInfo.getPath(), (int)l));
                }
                break;
            }
            case 43: {
                int n60 = dMessage.getWord();
                int n61 = (int)dMessage.getDWord();
                String[] stringArray = new String[n61];
                for (int i = 0; i < n61; ++i) {
                    long l = dMessage.getPtr();
                    DVariable dVariable = this.extractVariable(dMessage);
                    stringArray[i] = dVariable.getValue().getValueAsString();
                }
                this.m_lastConstantPool = stringArray;
                break;
            }
            case 45: {
                long l = dMessage.getDWord();
                long l25 = dMessage.getDWord();
                DModule dModule = this.getSource((int)l, dMessage.getTargetIsolate());
                if (dModule == null) break;
                int n62 = 0;
                while ((long)n62 < l25) {
                    int n63 = (int)dMessage.getDWord();
                    int n64 = (int)dMessage.getDWord();
                    int n65 = (int)dMessage.getDWord();
                    String string = dMessage.getString();
                    dModule.addLineFunctionInfo(n63, n64, n65, string);
                    ++n62;
                }
                break;
            }
            case 54: 
            case 57: {
                DValue dValue = null;
                int n66 = dMessage.getTargetIsolate();
                DVariable dVariable = null;
                String string = null;
                int n67 = 0;
                int n68 = -1;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (n2 == 57) {
                    dMessage.getDWord();
                }
                while (dMessage.getRemaining() > 0) {
                    int n69;
                    String string9;
                    long l = dMessage.getPtr();
                    if (dValue == null) {
                        string9 = dMessage.getString();
                        DVariable dVariable2 = this.extractVariable(dMessage, string9);
                        if (n2 == 54) {
                            this.getIsolateState((int)n66).m_lastInCallFunction = dVariable2;
                        } else {
                            this.getIsolateState((int)n66).m_lastInBinaryOp = dVariable2;
                        }
                        dValue = this.getOrCreateValue(l, n66);
                        continue;
                    }
                    dVariable = this.extractVariable(dMessage);
                    if (this.showMember(dVariable)) {
                        if (dVariable.isAttributeSet(131072)) {
                            if (arrayList.size() > 0) {
                                dVariable.setDefiningClass(0, (String)arrayList.get(0));
                                n68 = Math.max(n68, 0);
                            }
                        } else {
                            dVariable.setDefiningClass(n67, string);
                            if (string != null) {
                                n68 = Math.max(n68, n67);
                            }
                        }
                        this.addVariableMember(dValue.getId(), dVariable, n66);
                        continue;
                    }
                    if (!this.isTraits(dVariable)) continue;
                    string = dVariable.getQualifiedName();
                    n67 = arrayList.size();
                    if (string.endsWith("$") && (n69 = arrayList.indexOf(string9 = string.substring(0, string.length() - 1))) != -1) {
                        n67 = n69;
                        string = string9;
                    }
                    if (n67 != arrayList.size()) continue;
                    arrayList.add(string);
                }
                if (dValue == null || dValue.getClassHierarchy(true) != null) break;
                dValue.setClassHierarchy(arrayList.toArray(new String[arrayList.size()]), n68 + 1);
                break;
            }
            case 58: {
                long l = dMessage.getDWord();
                this.isolateCreate((int)l);
                break;
            }
            case 59: {
                long l = dMessage.getDWord();
                DIsolate dIsolate = this.removeIsolate((int)l);
                this.addEvent(new IsolateExitEvent(dIsolate));
                break;
            }
            case 60: {
                break;
            }
            case 61: {
                long l = dMessage.getDWord();
                boolean bl = dMessage.getByte() != 0;
                break;
            }
            case 62: {
                long l = dMessage.getDWord();
                Object object = this.m_inIsolateLock;
                synchronized (object) {
                    int n70 = this.findIsolate((int)l);
                    if (n70 != -1) {
                        this.setInIsolate(this.getIsolate(n70));
                    } else if (l != 1L) {
                        this.setInIsolate(this.isolateCreate((int)l));
                    } else {
                        this.setInIsolate(null);
                    }
                    break;
                }
            }
            case 63: {
                int n71 = dMessage.getWord();
                String string = dMessage.getString();
                int n72 = dMessage.getRemaining();
                break;
            }
            case 64: {
                int n73 = dMessage.getWord();
                String string = dMessage.getString();
                int n74 = dMessage.getRemaining();
                break;
            }
        }
    }

    private DIsolate isolateCreate(int n) {
        int n2 = this.findIsolate(n);
        if (n2 == -1) {
            DIsolate dIsolate = new DIsolate(n);
            this.addIsolate(dIsolate);
            this.setInIsolate(dIsolate);
            this.addEvent(new IsolateCreateEvent(dIsolate));
            return dIsolate;
        }
        return this.getIsolate(n2);
    }

    private void appendIsolateInfoToFrame(int n) {
        block2: {
            try {
                DStackContext dStackContext = this.getFrame(0, n);
                dStackContext.setIsolateId(n);
            }
            catch (Exception exception) {
                if (!Trace.error) break block2;
                Trace.trace("Oh my god, gag me with a spoon...getFrame(0) call failed");
                exception.printStackTrace();
            }
        }
    }

    private boolean showMember(DVariable dVariable) {
        return !this.isTraits(dVariable);
    }

    private boolean isTraits(DVariable dVariable) {
        Value value = dVariable.getValue();
        return value.getType() == 8 && "traits".equals(value.getTypeName());
    }

    void populateRootNode(DValue dValue, ArrayList<DVariable> arrayList, int n) {
        this.populateFrame(0, arrayList, n);
        DValue dValue2 = this.getOrCreateValue(-100L, n);
        dValue2.setMembersObtained(true);
    }

    void populateFrame(int n, ArrayList<DVariable> arrayList, int n2) {
        DStackContext dStackContext = null;
        boolean bl = false;
        int n3 = -1;
        boolean bl2 = false;
        DValue dValue = this.getOrCreateValue(-100L - (long)n, n2);
        if (n < this.getFrameCount(n2)) {
            dStackContext = this.getFrame(n, n2);
        }
        if (dStackContext != null) {
            dStackContext.removeAllVariables();
        }
        for (DVariable dVariable : arrayList) {
            String string = dVariable.getName();
            dVariable.clearAttribute(32);
            dVariable.clearAttribute(65536);
            if (string.equals("this")) {
                if (dStackContext != null) {
                    dStackContext.setThis(dVariable);
                }
                dVariable.setAttribute(65536);
                this.addVariableMember(dValue, dVariable, n2);
                if (n != 0) continue;
                this.putValue(-3L, (DValue)dVariable.getValue(), n2);
                continue;
            }
            if (string.equals("super")) {
                bl = false;
                continue;
            }
            if (string.equals(ARGUMENTS_MARKER)) {
                bl = true;
                try {
                    n3 = ((Number)dVariable.getValue().getValueAsObject()).intValue();
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (string.equals(SCOPE_CHAIN_MARKER)) {
                bl = false;
                bl2 = true;
                continue;
            }
            if (bl) {
                dVariable.setAttribute(65536);
                if (dStackContext != null) {
                    dStackContext.addArgument(dVariable);
                }
                if (n3 > -1 && --n3 <= 0) {
                    bl = false;
                }
            } else if (bl2) {
                if (dStackContext != null) {
                    dStackContext.addScopeChainEntry(dVariable);
                }
            } else {
                dVariable.setAttribute(32);
                if (dStackContext != null) {
                    dStackContext.addLocal(dVariable);
                }
            }
            if (bl2) continue;
            this.addVariableMember(dValue, dVariable, n2);
        }
    }

    int toAttributes(int n) {
        int n2 = n;
        return n2;
    }

    DVariable extractVariable(DMessage dMessage) {
        DVariable dVariable = this.extractVariable(dMessage, dMessage.getString());
        return dVariable;
    }

    DVariable extractVariable(DMessage dMessage, String string) {
        int n = dMessage.getWord();
        int n2 = (int)dMessage.getDWord();
        return this.extractAtom(dMessage, string, n, n2);
    }

    DVariable extractRegister(DMessage dMessage, int n) {
        int n2 = dMessage.getWord();
        return this.extractAtom(dMessage, "$" + n, n2, 0);
    }

    DVariable extractAtom(DMessage dMessage, String string, int n, int n2) {
        int n3 = 8;
        Object object = null;
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        switch (n) {
            case 0: {
                String string4 = dMessage.getString();
                double d = Double.NaN;
                try {
                    d = Double.parseDouble(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                object = new Double(d);
                bl = true;
                break;
            }
            case 1: {
                int n4 = dMessage.getByte();
                object = new Boolean(n4 != 0);
                bl = true;
                break;
            }
            case 2: {
                String string5 = dMessage.getString();
                object = string5;
                bl = true;
                break;
            }
            case 3: 
            case 18: {
                long l = dMessage.getPtr();
                long l2 = l == -1L ? 0L : dMessage.getDWord();
                int n5 = l == -1L ? 0 : dMessage.getWord();
                int n6 = l == -1L ? 0 : dMessage.getWord();
                String string6 = string2 = l == -1L ? "" : dMessage.getString();
                if (string2.startsWith("<")) {
                    int n7 = string2.indexOf(64);
                    String string7 = string2;
                    if (n7 > -1) {
                        string7 = string2.substring(0, n7);
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("<EEE MMM d HH:mm:ss 'GMT'z yyyy>");
                    try {
                        Date date = simpleDateFormat.parse(string7);
                        if (date != null && date.getTime() != 0L) {
                            n = 11;
                            string2 = "Date" + string2.substring(n7);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                string3 = DVariable.classNameFor(l2, false);
                object = new Long(l);
                n3 = n5 == 0 ? 3 : 4;
                break;
            }
            case 4: {
                long l = dMessage.getPtr();
                long l2 = l == -1L ? 0L : dMessage.getDWord();
                long l3 = l == -1L ? 0L : dMessage.getDWord();
                string2 = l == -1L ? "" : dMessage.getString();
                string3 = DVariable.classNameFor(l2, true);
                object = new Long(l);
                n3 = 5;
                break;
            }
            case 5: {
                object = null;
                bl = true;
                break;
            }
            case 6: {
                object = Value.UNDEFINED;
                bl = true;
                break;
            }
            case 19: {
                n3 = 8;
                string2 = "traits";
                break;
            }
        }
        int n8 = dMessage.getTargetIsolate();
        DValue dValue = null;
        if (object instanceof Long) {
            dValue = this.getValue((Long)object, n8);
        }
        if (dValue == null) {
            if (bl) {
                dValue = DValue.forPrimitive(object, n8);
                dValue.setAttributes(this.toAttributes(n2));
            } else {
                dValue = new DValue(n3, string2, string3, this.toAttributes(n2), object, n8);
            }
            if (object instanceof Long && (this.toAttributes(n2) & 0x80000) == 0) {
                this.putValue((Long)object, dValue, n8);
            }
        } else {
            if (bl) {
                DValue dValue2 = DValue.forPrimitive(object, n8);
                n3 = dValue2.getType();
                string2 = dValue2.getTypeName();
                string3 = dValue2.getClassName();
            }
            dValue.setType(n3);
            dValue.setTypeName(string2);
            dValue.setClassName(string3);
            dValue.setAttributes(this.toAttributes(n2));
            dValue.setValue(object);
        }
        if (dValue != null) {
            dValue.setIsolateId(n8);
        }
        DVariable dVariable = new DVariable(string, dValue, n8);
        return dVariable;
    }

    public static String convertToURI(String string) {
        int n = string.indexOf(124);
        StringBuilder stringBuilder = new StringBuilder(string);
        while (n > 0) {
            stringBuilder.setCharAt(n, ':');
            n = string.indexOf(124, n + 1);
        }
        return stringBuilder.toString();
    }

    public void beginPlayerCodeExecution(int n) {
        DManagerIsolateState dManagerIsolateState = this.getIsolateState(n);
        dManagerIsolateState.m_executingPlayerCode = true;
        dManagerIsolateState.m_faultEventDuringPlayerCodeExecution = null;
    }

    public FaultEvent endPlayerCodeExecution(int n) {
        DManagerIsolateState dManagerIsolateState = this.getIsolateState(n);
        dManagerIsolateState.m_executingPlayerCode = false;
        FaultEvent faultEvent = dManagerIsolateState.m_faultEventDuringPlayerCodeExecution;
        dManagerIsolateState.m_faultEventDuringPlayerCodeExecution = null;
        return faultEvent;
    }

    private void handleFaultEvent(FaultEvent faultEvent) {
        DManagerIsolateState dManagerIsolateState = this.getIsolateState(faultEvent.isolateId);
        boolean bl = dManagerIsolateState.m_executingPlayerCode;
        if (bl) {
            FaultEvent faultEvent2 = dManagerIsolateState.m_faultEventDuringPlayerCodeExecution;
            if (faultEvent2 == null) {
                dManagerIsolateState.m_faultEventDuringPlayerCodeExecution = faultEvent;
            }
        } else {
            this.addEvent(faultEvent);
        }
    }

    @Override
    public InputStream locateSource(String string, String string2, String string3) {
        if (this.m_sourceLocator != null) {
            return this.m_sourceLocator.locateSource(string, string2, string3);
        }
        return null;
    }

    @Override
    public int getChangeCount() {
        if (this.m_sourceLocator != null) {
            return this.m_sourceLocator.getChangeCount();
        }
        return 0;
    }

    public String getOption(String string) {
        return this.m_options.get(string);
    }

    class DManagerIsolateState {
        public DSuspendInfo m_suspendInfo = null;
        public DSwfInfo m_lastSwfInfo;
        public DVariable m_lastInGetVariable = null;
        public boolean m_attachChildren = true;
        public DVariable m_lastInCallFunction = null;
        public DVariable m_lastInBinaryOp;
        private boolean m_executingPlayerCode;
        private FaultEvent m_faultEventDuringPlayerCodeExecution;
        public final ArrayList<DLocation> m_breakpoints;
        public final Map<Integer, DModule> m_source = new HashMap<Integer, DModule>();
        private final ArrayList<DSwfInfo> m_swfInfo;
        private final ArrayList<DWatch> m_watchpoints;
        public ArrayList<DStackContext> m_frames;
        public ArrayList<DStackContext> m_previousFrames;
        public Map<Long, DValue> m_values = new HashMap<Long, DValue>();
        public Map<Long, DValue> m_previousValues = new HashMap<Long, DValue>();

        public DManagerIsolateState() {
            this.m_frames = new ArrayList();
            this.m_previousFrames = new ArrayList();
            this.m_breakpoints = new ArrayList();
            this.m_swfInfo = new ArrayList();
            this.m_watchpoints = new ArrayList();
        }
    }
}

