/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.caches;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipFile;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.apache.commons.io.IOUtils;
import org.apache.flex.compiler.css.ICSSDocument;
import org.apache.flex.compiler.css.ICSSFontFace;
import org.apache.flex.compiler.css.ICSSNamespaceDefinition;
import org.apache.flex.compiler.css.ICSSNode;
import org.apache.flex.compiler.css.ICSSRule;
import org.apache.flex.compiler.internal.caches.CacheStoreKeyBase;
import org.apache.flex.compiler.internal.caches.ConcurrentCacheStoreBase;
import org.apache.flex.compiler.internal.css.CSSDocument;
import org.apache.flex.compiler.internal.css.CSSModelTreeType;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.swc.ISWC;
import org.apache.flex.swc.io.SWCReader;
import org.apache.flex.utils.FilenameNormalization;

public class CSSDocumentCache
extends ConcurrentCacheStoreBase<ICSSDocument> {
    public static final ICSSDocument EMPTY_CSS_DOCUMENT = new ICSSDocument(){

        @Override
        public ImmutableList<ICSSRule> getRules() {
            return ImmutableList.of();
        }

        @Override
        public ICSSNamespaceDefinition getNamespaceDefinition(String prefix) {
            return null;
        }

        @Override
        public ImmutableList<ICSSFontFace> getFontFaces() {
            return ImmutableList.of();
        }

        @Override
        public ICSSNamespaceDefinition getDefaultNamespaceDefinition() {
            return null;
        }

        @Override
        public ImmutableList<ICSSNamespaceDefinition> getAtNamespaces() {
            return ImmutableList.of();
        }

        @Override
        public String toStringTree() {
            return null;
        }

        @Override
        public int getArity() {
            return 0;
        }

        @Override
        public ICSSNode getNthChild(int index) {
            throw new IllegalStateException();
        }

        @Override
        public CSSModelTreeType getOperator() {
            throw new IllegalStateException();
        }

        @Override
        public String getSourcePath() {
            return null;
        }

        @Override
        public int getStart() {
            return 0;
        }

        @Override
        public int getEnd() {
            return 0;
        }

        @Override
        public int getLine() {
            return 0;
        }

        @Override
        public int getColumn() {
            return 0;
        }

        @Override
        public int getEndLine() {
            return 0;
        }

        @Override
        public int getEndColumn() {
            return 0;
        }

        @Override
        public int getAbsoluteStart() {
            return 0;
        }

        @Override
        public int getAbsoluteEnd() {
            return 0;
        }
    };
    public static String[] ALL_DEFAULTS_CSS_FILENAMES = new String[]{"defaults.css", "defaults-3.0.0.css"};

    public static CacheStoreKeyBase createKey(ISWC swc, String cssFileName) {
        return new CSSDocumentCacheKey(swc, cssFileName);
    }

    public static CacheStoreKeyBase createKey(String cssFileName) {
        return new CSSDocumentCacheKey2(cssFileName);
    }

    @Override
    protected ICSSDocument createEntryValue(CacheStoreKeyBase key) {
        assert (key instanceof CSSDocumentCacheKeyBase) : "Expected 'CSSDocumentCacheKeyBase' but got " + key.getClass().getSimpleName();
        CSSDocumentCacheKeyBase cacheKey = (CSSDocumentCacheKeyBase)key;
        ICSSDocument result = EMPTY_CSS_DOCUMENT;
        try {
            result = cacheKey.parse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static String getCompatibleModeCSSFilename(Integer version) {
        if (version == null) {
            return "defaults.css";
        }
        if (version <= 0x3000000) {
            return "defaults-3.0.0.css";
        }
        return "defaults.css";
    }

    public ICSSDocument getDefaultsCSS(ISWC swc, Integer compatibilityVersion) {
        String cssFilename = CSSDocumentCache.getCompatibleModeCSSFilename(compatibilityVersion);
        CacheStoreKeyBase key = CSSDocumentCache.createKey(swc, cssFilename);
        ICSSDocument css = (ICSSDocument)this.get(key);
        assert (css != null) : "ConcurrentCacheStoreBase never caches null value.";
        if (css == EMPTY_CSS_DOCUMENT) {
            if (compatibilityVersion != null) {
                return this.getDefaultsCSS(swc, null);
            }
            return null;
        }
        return css;
    }

    protected static class CSSDocumentCacheKey2
    extends CSSDocumentCacheKeyBase {
        protected final String cssFileName;

        public CSSDocumentCacheKey2(String cssFileName) {
            assert (cssFileName != null) : "CSS file name can't be null.";
            this.cssFileName = cssFileName;
        }

        @Override
        public String generateKey() {
            return this.cssFileName;
        }

        @Override
        ICSSDocument parse() throws IOException {
            ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
            CSSDocument css = CSSDocument.parse((CharStream)new ANTLRFileStream(this.cssFileName), problems);
            if (!problems.isEmpty()) {
                throw new ProblemParsingCSSRuntimeException(problems);
            }
            if (css != null) {
                return css;
            }
            return EMPTY_CSS_DOCUMENT;
        }
    }

    public static class CSSDocumentCacheKey
    extends CSSDocumentCacheKeyBase {
        public final ISWC swc;
        public final String cssFileName;

        public CSSDocumentCacheKey(ISWC swc, String cssFileName) {
            assert (cssFileName != null) : "CSS file name can't be null.";
            this.swc = swc;
            this.cssFileName = cssFileName;
        }

        @Override
        public String generateKey() {
            return String.format("%s:%s", FilenameNormalization.normalize(this.swc.getSWCFile()).getAbsolutePath(), this.cssFileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        ICSSDocument parse() throws IOException {
            ZipFile zipFile = new ZipFile(this.swc.getSWCFile(), 1);
            ICSSDocument result = EMPTY_CSS_DOCUMENT;
            InputStream input = null;
            try {
                input = SWCReader.getInputStream(zipFile, this.cssFileName);
                if (input != null) {
                    ANTLRInputStream in = new ANTLRInputStream(input);
                    in.name = String.format("%s:%s", this.swc.getSWCFile().getName(), this.cssFileName);
                    ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
                    result = CSSDocument.parse((CharStream)in, problems);
                    if (!problems.isEmpty()) {
                        throw new ProblemParsingCSSRuntimeException(problems);
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                zipFile.close();
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)input);
            zipFile.close();
            return result;
        }
    }

    private static abstract class CSSDocumentCacheKeyBase
    extends CacheStoreKeyBase {
        private CSSDocumentCacheKeyBase() {
        }

        abstract ICSSDocument parse() throws IOException;
    }

    public static class ProblemParsingCSSRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 156921800741800866L;
        public final Collection<ICompilerProblem> cssParserProblems;

        public ProblemParsingCSSRuntimeException(Collection<ICompilerProblem> problems) {
            this.cssParserProblems = problems;
        }
    }
}

