/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.flex.compiler.internal.graph.Graph;
import org.apache.flex.compiler.internal.graph.IGraphEdge;

public class SynchronizedGraph<V, E extends IGraphEdge<V>>
extends Graph<V, E> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    @Override
    public boolean addVertex(V vertex) {
        this.lock.writeLock().lock();
        try {
            boolean bl = super.addVertex(vertex);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void removeVertex(V vertex) {
        this.lock.writeLock().lock();
        try {
            super.removeVertex(vertex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E setEdge(V from, V to, E e) {
        this.lock.writeLock().lock();
        try {
            E e2 = super.setEdge(e);
            return e2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getEdge(V from, V to) {
        this.lock.writeLock().lock();
        try {
            Object e = super.getEdge(from, to);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> getOutgoingEdges(V vertex) {
        this.lock.readLock().lock();
        try {
            Set result = super.getOutgoingEdges(vertex);
            Set set = result == Collections.EMPTY_SET ? result : Collections.unmodifiableSet(new HashSet(result));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> getIncomingEdges(V vertex) {
        this.lock.readLock().lock();
        try {
            Set result = super.getIncomingEdges(vertex);
            Set set = result == Collections.EMPTY_SET ? result : Collections.unmodifiableSet(new HashSet(result));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public E removeEdge(E edge) {
        this.lock.writeLock().lock();
        try {
            E e = super.removeEdge(edge);
            return e;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Set<V> getVertices() {
        this.lock.readLock().lock();
        try {
            Set result = super.getVertices();
            Set set = Collections.unmodifiableSet(new HashSet(result));
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Lock writeLock() {
        return this.lock.writeLock();
    }

    public Lock readLock() {
        return this.lock.readLock();
    }
}

