/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.predicate;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.java.typeutils.runtime.NullableSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.store.file.predicate.LeafFunction;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.types.logical.LogicalType;

public class LeafPredicate
implements Predicate {
    private static final long serialVersionUID = 1L;
    private final LeafFunction function;
    private final LogicalType type;
    private final int fieldIndex;
    private final String fieldName;
    private transient List<Object> literals;

    public LeafPredicate(LeafFunction function, LogicalType type, int fieldIndex, String fieldName, List<Object> literals) {
        this.function = function;
        this.type = type;
        this.fieldIndex = fieldIndex;
        this.fieldName = fieldName;
        this.literals = literals;
    }

    public LeafFunction function() {
        return this.function;
    }

    public LogicalType type() {
        return this.type;
    }

    public int index() {
        return this.fieldIndex;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public List<Object> literals() {
        return this.literals;
    }

    @Override
    public boolean test(Object[] values) {
        return this.function.test(this.type, values[this.fieldIndex], this.literals);
    }

    @Override
    public boolean test(long rowCount, FieldStats[] fieldStats) {
        FieldStats stats = fieldStats[this.fieldIndex];
        if (rowCount != stats.nullCount() && (stats.minValue() == null || stats.maxValue() == null)) {
            return true;
        }
        return this.function.test(this.type, rowCount, stats, this.literals);
    }

    @Override
    public Optional<Predicate> negate() {
        return this.function.negate().map(negate -> new LeafPredicate((LeafFunction)negate, this.type, this.fieldIndex, this.fieldName, this.literals));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafPredicate that = (LeafPredicate)o;
        return this.fieldIndex == that.fieldIndex && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.function, that.function) && Objects.equals(this.type, that.type) && Objects.equals(this.literals, that.literals);
    }

    public int hashCode() {
        return Objects.hash(this.function, this.type, this.fieldIndex, this.fieldName, this.literals);
    }

    private ListSerializer<Object> objectsSerializer() {
        return new ListSerializer(NullableSerializer.wrapIfNullIsNotSupported((TypeSerializer)InternalSerializers.create((LogicalType)this.type), (boolean)false));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.objectsSerializer().serialize(this.literals, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.literals = this.objectsSerializer().deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
    }
}

