/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.scope;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.metrics.scope.JobManagerJobScopeFormat;
import org.apache.flink.runtime.metrics.scope.JobManagerScopeFormat;
import org.apache.flink.runtime.metrics.scope.OperatorScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskManagerJobScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskManagerScopeFormat;
import org.apache.flink.runtime.metrics.scope.TaskScopeFormat;

public final class ScopeFormats {
    private final JobManagerScopeFormat jobManagerFormat;
    private final JobManagerJobScopeFormat jobManagerJobFormat;
    private final TaskManagerScopeFormat taskManagerFormat;
    private final TaskManagerJobScopeFormat taskManagerJobFormat;
    private final TaskScopeFormat taskFormat;
    private final OperatorScopeFormat operatorFormat;

    private ScopeFormats(String jobManagerFormat, String jobManagerJobFormat, String taskManagerFormat, String taskManagerJobFormat, String taskFormat, String operatorFormat) {
        this.jobManagerFormat = new JobManagerScopeFormat(jobManagerFormat);
        this.jobManagerJobFormat = new JobManagerJobScopeFormat(jobManagerJobFormat, this.jobManagerFormat);
        this.taskManagerFormat = new TaskManagerScopeFormat(taskManagerFormat);
        this.taskManagerJobFormat = new TaskManagerJobScopeFormat(taskManagerJobFormat, this.taskManagerFormat);
        this.taskFormat = new TaskScopeFormat(taskFormat, this.taskManagerJobFormat);
        this.operatorFormat = new OperatorScopeFormat(operatorFormat, this.taskFormat);
    }

    public JobManagerScopeFormat getJobManagerFormat() {
        return this.jobManagerFormat;
    }

    public TaskManagerScopeFormat getTaskManagerFormat() {
        return this.taskManagerFormat;
    }

    public TaskManagerJobScopeFormat getTaskManagerJobFormat() {
        return this.taskManagerJobFormat;
    }

    public JobManagerJobScopeFormat getJobManagerJobFormat() {
        return this.jobManagerJobFormat;
    }

    public TaskScopeFormat getTaskFormat() {
        return this.taskFormat;
    }

    public OperatorScopeFormat getOperatorFormat() {
        return this.operatorFormat;
    }

    public static ScopeFormats fromConfig(Configuration config) {
        String jmFormat = config.getString(MetricOptions.SCOPE_NAMING_JM);
        String jmJobFormat = config.getString(MetricOptions.SCOPE_NAMING_JM_JOB);
        String tmFormat = config.getString(MetricOptions.SCOPE_NAMING_TM);
        String tmJobFormat = config.getString(MetricOptions.SCOPE_NAMING_TM_JOB);
        String taskFormat = config.getString(MetricOptions.SCOPE_NAMING_TASK);
        String operatorFormat = config.getString(MetricOptions.SCOPE_NAMING_OPERATOR);
        return new ScopeFormats(jmFormat, jmJobFormat, tmFormat, tmJobFormat, taskFormat, operatorFormat);
    }
}

