/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.TimeZone;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class TimeWindowUtil {
    private static final ZoneId UTC_ZONE_ID = TimeZone.getTimeZone("UTC").toZoneId();
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long MILLS_PER_HOUR = 3600000L;

    public static long toUtcTimestampMills(long epochMills, ZoneId shiftTimeZone) {
        if (UTC_ZONE_ID.equals(shiftTimeZone) || Long.MAX_VALUE == epochMills) {
            return epochMills;
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMills), shiftTimeZone);
        return localDateTime.atZone(UTC_ZONE_ID).toInstant().toEpochMilli();
    }

    public static long toEpochMillsForTimer(long utcTimestampMills, ZoneId shiftTimeZone) {
        if (UTC_ZONE_ID.equals(shiftTimeZone) || Long.MAX_VALUE == utcTimestampMills) {
            return utcTimestampMills;
        }
        if (TimeZone.getTimeZone(shiftTimeZone).useDaylightTime()) {
            boolean hasTwoEpochs;
            long t2;
            LocalDateTime utcTimestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(utcTimestampMills), UTC_ZONE_ID);
            long t1 = utcTimestamp.atZone(shiftTimeZone).toInstant().toEpochMilli();
            boolean hasNoEpoch = t1 == (t2 = utcTimestamp.plusSeconds(3600L).atZone(shiftTimeZone).toInstant().toEpochMilli());
            boolean bl = hasTwoEpochs = t2 - t1 > 3600000L;
            if (hasNoEpoch) {
                return t1 - t1 % 3600000L;
            }
            if (hasTwoEpochs) {
                return t1 + 3600000L;
            }
            return t1;
        }
        LocalDateTime utcTimestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(utcTimestampMills), UTC_ZONE_ID);
        return utcTimestamp.atZone(shiftTimeZone).toInstant().toEpochMilli();
    }

    public static long toEpochMills(long utcTimestampMills, ZoneId shiftTimeZone) {
        if (UTC_ZONE_ID.equals(shiftTimeZone) || Long.MAX_VALUE == utcTimestampMills) {
            return utcTimestampMills;
        }
        LocalDateTime utcTimestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(utcTimestampMills), UTC_ZONE_ID);
        return utcTimestamp.atZone(shiftTimeZone).toInstant().toEpochMilli();
    }

    public static ZoneId getShiftTimeZone(LogicalType timeAttributeType, ZoneId zoneFromConfig) {
        boolean needShiftTimeZone = timeAttributeType instanceof LocalZonedTimestampType;
        return needShiftTimeZone ? zoneFromConfig : UTC_ZONE_ID;
    }

    public static boolean isWindowFired(long windowEnd, long currentProgress, ZoneId shiftTimeZone) {
        if (windowEnd == Long.MAX_VALUE) {
            return false;
        }
        long windowTriggerTime = TimeWindowUtil.toEpochMillsForTimer(windowEnd - 1L, shiftTimeZone);
        return currentProgress >= windowTriggerTime;
    }

    public static long getNextTriggerWatermark(long currentWatermark, long interval, ZoneId shiftTimezone, boolean useDayLightSaving) {
        long triggerWatermark;
        if (currentWatermark == Long.MAX_VALUE) {
            return currentWatermark;
        }
        if (useDayLightSaving) {
            long utcWindowStart = TimeWindow.getWindowStartWithOffset(TimeWindowUtil.toUtcTimestampMills(currentWatermark, shiftTimezone), 0L, interval);
            triggerWatermark = TimeWindowUtil.toEpochMillsForTimer(utcWindowStart + interval - 1L, shiftTimezone);
        } else {
            long start = TimeWindow.getWindowStartWithOffset(currentWatermark, 0L, interval);
            triggerWatermark = start + interval - 1L;
        }
        if (triggerWatermark > currentWatermark) {
            return triggerWatermark;
        }
        return triggerWatermark + interval;
    }
}

