/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.options;

import io.micronaut.core.annotation.NonNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.grails.forge.options.Language;

public enum TestFramework {
    JUNIT,
    SPOCK;

    public static final TestFramework DEFAULT_OPTION;

    public String toString() {
        return this.name().toLowerCase();
    }

    @NonNull
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public String getSourcePath(String path, Language language) {
        switch (this) {
            case SPOCK: {
                return Language.GROOVY.getTestSrcDir() + path + this.getTestFrameworkSuffix() + Language.GROOVY.getExtension();
            }
        }
        if (language != null) {
            return language.getTestSrcDir() + path + this.getTestFrameworkSuffix() + language.getExtension();
        }
        return Language.GROOVY.getTestSrcDir() + path + this.getTestFrameworkSuffix() + Language.GROOVY.getExtension();
    }

    public String getIntegrationSourcePath(String path, Language language) {
        switch (this) {
            case SPOCK: {
                return Language.GROOVY.getIntegrationSrcDir() + path + this.getTestFrameworkSuffix() + Language.GROOVY.getExtension();
            }
        }
        if (language != null) {
            return language.getIntegrationSrcDir() + path + this.getTestFrameworkSuffix() + language.getExtension();
        }
        return Language.GROOVY.getIntegrationSrcDir() + path + this.getTestFrameworkSuffix() + Language.GROOVY.getExtension();
    }

    public String getTestFrameworkSuffix() {
        switch (this) {
            case SPOCK: {
                return "Spec.";
            }
        }
        return "Test.";
    }

    public List<Language> getSupportedLanguages() {
        switch (this) {
            case SPOCK: {
                return Collections.singletonList(Language.GROOVY);
            }
            case JUNIT: {
                return Arrays.asList(Language.GROOVY);
            }
        }
        throw new RuntimeException("No list of supported languages have been defined for " + this.getName());
    }

    public Language getDefaultLanguage() {
        switch (this) {
            case SPOCK: 
            case JUNIT: {
                return Language.GROOVY;
            }
        }
        throw new RuntimeException("No default language have been defined for " + this.getName());
    }

    public TestFramework toTestFramework() {
        return switch (this) {
            case SPOCK -> SPOCK;
            default -> JUNIT;
        };
    }

    static {
        DEFAULT_OPTION = SPOCK;
    }
}

