/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.file;

import org.apache.guacamole.auth.file.Authorization;
import org.apache.guacamole.auth.file.ConnectionTagHandler;
import org.apache.guacamole.auth.file.ParamTagHandler;
import org.apache.guacamole.auth.file.ProtocolTagHandler;
import org.apache.guacamole.auth.file.UserMapping;
import org.apache.guacamole.protocol.GuacamoleConfiguration;
import org.apache.guacamole.xml.TagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AuthorizeTagHandler
implements TagHandler {
    private Authorization authorization = new Authorization();
    private GuacamoleConfiguration default_config = null;
    private UserMapping parent;

    public AuthorizeTagHandler(UserMapping parent) {
        this.parent = parent;
    }

    public void init(Attributes attributes) throws SAXException {
        this.authorization.setUsername(attributes.getValue("username"));
        this.authorization.setPassword(attributes.getValue("password"));
        String encoding = attributes.getValue("encoding");
        if (encoding != null) {
            if (encoding.equals("md5")) {
                this.authorization.setEncoding(Authorization.Encoding.MD5);
            } else if (encoding.equals("sha256")) {
                this.authorization.setEncoding(Authorization.Encoding.SHA_256);
            } else if (encoding.equals("plain")) {
                this.authorization.setEncoding(Authorization.Encoding.PLAIN_TEXT);
            } else {
                throw new SAXException("Invalid encoding: '" + encoding + "'");
            }
        }
        this.parent.addAuthorization(this.asAuthorization());
    }

    public TagHandler childElement(String localName) throws SAXException {
        if (localName.equals("connection")) {
            return new ConnectionTagHandler(this.authorization);
        }
        if (localName.equals("param")) {
            if (this.default_config == null) {
                this.default_config = new GuacamoleConfiguration();
                this.authorization.addConfiguration("DEFAULT", this.default_config);
            }
            return new ParamTagHandler(this.default_config);
        }
        if (localName.equals("protocol")) {
            if (this.default_config == null) {
                this.default_config = new GuacamoleConfiguration();
                this.authorization.addConfiguration("DEFAULT", this.default_config);
            }
            return new ProtocolTagHandler(this.default_config);
        }
        return null;
    }

    public void complete(String textContent) throws SAXException {
    }

    public Authorization asAuthorization() {
        return this.authorization;
    }
}

