/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.auth;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSession;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.IntegerGuacamoleProperty;
import org.apache.guacamole.rest.auth.HashTokenSessionMap;
import org.apache.guacamole.rest.auth.TokenSessionMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashTokenSessionMap
implements TokenSessionMap {
    private static final Logger logger = LoggerFactory.getLogger(HashTokenSessionMap.class);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private final ConcurrentMap<String, GuacamoleSession> sessionMap = new ConcurrentHashMap();
    private final IntegerGuacamoleProperty API_SESSION_TIMEOUT = new /* Unavailable Anonymous Inner Class!! */;

    public HashTokenSessionMap(Environment environment) {
        int sessionTimeoutValue;
        try {
            sessionTimeoutValue = (Integer)environment.getProperty((GuacamoleProperty)this.API_SESSION_TIMEOUT, (Object)60);
        }
        catch (GuacamoleException e) {
            logger.error("Unable to read guacamole.properties: {}", (Object)e.getMessage());
            logger.debug("Error while reading session timeout value.", (Throwable)e);
            sessionTimeoutValue = 60;
        }
        logger.info("Sessions will expire after {} minutes of inactivity.", (Object)sessionTimeoutValue);
        this.executor.scheduleAtFixedRate((Runnable)new SessionEvictionTask(this, (long)sessionTimeoutValue * 60000L), 1L, 1L, TimeUnit.MINUTES);
    }

    public GuacamoleSession get(String authToken) {
        if (authToken == null) {
            return null;
        }
        return (GuacamoleSession)this.sessionMap.get(authToken);
    }

    public void put(String authToken, GuacamoleSession session) {
        this.sessionMap.put(authToken, session);
    }

    public GuacamoleSession remove(String authToken) {
        if (authToken == null) {
            return null;
        }
        return (GuacamoleSession)this.sessionMap.remove(authToken);
    }

    public void shutdown() {
        this.executor.shutdownNow();
        this.sessionMap.values().stream().forEach(GuacamoleSession::invalidate);
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ ConcurrentMap access$100(HashTokenSessionMap x0) {
        return x0.sessionMap;
    }
}

