/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.ActiveConnection;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.tunnel.StreamInterceptingTunnel;

public class UserTunnel
extends StreamInterceptingTunnel {
    private final UserContext userContext;

    public UserTunnel(UserContext userContext, GuacamoleTunnel tunnel) {
        super(tunnel);
        this.userContext = userContext;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public ActiveConnection getActiveConnection() throws GuacamoleException {
        UUID uuid = this.getUUID();
        Directory activeConnectionDirectory = this.userContext.getActiveConnectionDirectory();
        Set activeConnectionIdentifiers = activeConnectionDirectory.getIdentifiers();
        for (ActiveConnection activeConnection : activeConnectionDirectory.getAll((Collection)activeConnectionIdentifiers)) {
            GuacamoleTunnel tunnel = activeConnection.getTunnel();
            if (tunnel == null || !uuid.equals(tunnel.getUUID())) continue;
            return activeConnection;
        }
        return null;
    }
}

