/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sql.ExecSql;
import org.apache.hop.pipeline.transforms.sql.ExecSqlArgumentItem;
import org.apache.hop.pipeline.transforms.sql.ExecSqlData;

@Transform(id="ExecSql", image="sql.svg", name="i18n::ExecSql.Name", description="i18n::ExecSql.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Scripting", keywords={"i18n::ExecSqlMeta.keyword"}, documentationUrl="/pipeline/transforms/execsql.html")
public class ExecSqlMeta
extends BaseTransformMeta<ExecSql, ExecSqlData> {
    private static final Class<?> PKG = ExecSqlMeta.class;
    @HopMetadataProperty(key="connection", injectionKeyDescription="ExecSqlMeta.Injection.CONNECTIONNAME")
    private String connection;
    @HopMetadataProperty(injectionKeyDescription="ExecSqlMeta.Injection.SQL", injectionKey="SQL")
    private String sql;
    @HopMetadataProperty(key="execute_each_row", injectionKeyDescription="ExecSqlMeta.Injection.EXECUTE_FOR_EACH_ROW", injectionKey="EXECUTE_FOR_EACH_ROW")
    private boolean executedEachInputRow;
    @HopMetadataProperty(key="update_field", injectionKeyDescription="ExecSqlMeta.Injection.UPDATE_STATS_FIELD", injectionKey="UPDATE_STATS_FIELD")
    private String updateField;
    @HopMetadataProperty(key="insert_field", injectionKeyDescription="ExecSqlMeta.Injection.INSERT_STATS_FIELD", injectionKey="INSERT_STATS_FIELD")
    private String insertField;
    @HopMetadataProperty(key="delete_field", injectionKeyDescription="ExecSqlMeta.Injection.DELETE_STATS_FIELD", injectionKey="DELETE_STATS_FIELD")
    private String deleteField;
    @HopMetadataProperty(key="read_field", injectionKeyDescription="ExecSqlMeta.Injection.READ_STATS_FIELD", injectionKey="READ_STATS_FIELD")
    private String readField;
    @HopMetadataProperty(key="single_statement", injectionKeyDescription="ExecSqlMeta.Injection.EXECUTE_AS_SINGLE_STATEMENT", injectionKey="EXECUTE_AS_SINGLE_STATEMENT")
    private boolean singleStatement;
    @HopMetadataProperty(key="replace_variables", injectionKeyDescription="ExecSqlMeta.Injection.REPLACE_VARIABLES", injectionKey="REPLACE_VARIABLES")
    private boolean replaceVariables;
    @HopMetadataProperty(injectionKeyDescription="ExecSqlMeta.Injection.QUOTE_STRINGS", injectionKey="QUOTE_STRINGS")
    private boolean quoteString;
    @HopMetadataProperty(key="set_params", injectionKeyDescription="ExecSqlMeta.Injection.BIND_PARAMETERS", injectionKey="BIND_PARAMETERS")
    private boolean params;
    @HopMetadataProperty(key="argument", groupKey="arguments", injectionGroupKey="PARAMETERS", injectionGroupDescription="ExecSqlMeta.Injection.PARAMETERS")
    private List<ExecSqlArgumentItem> arguments = new ArrayList<ExecSqlArgumentItem>();

    public boolean isParams() {
        return this.params;
    }

    public void setParams(boolean value) {
        this.params = value;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public List<ExecSqlArgumentItem> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ExecSqlArgumentItem> arguments) {
        this.arguments = arguments;
    }

    public boolean isExecutedEachInputRow() {
        return this.executedEachInputRow;
    }

    public void setExecutedEachInputRow(boolean executedEachInputRow) {
        this.executedEachInputRow = executedEachInputRow;
    }

    public String getDeleteField() {
        return this.deleteField;
    }

    public void setDeleteField(String deleteField) {
        this.deleteField = deleteField;
    }

    public String getInsertField() {
        return this.insertField;
    }

    public void setInsertField(String insertField) {
        this.insertField = insertField;
    }

    public String getReadField() {
        return this.readField;
    }

    public void setReadField(String readField) {
        this.readField = readField;
    }

    public String getUpdateField() {
        return this.updateField;
    }

    public void setUpdateField(String updateField) {
        this.updateField = updateField;
    }

    public Object clone() {
        ExecSqlMeta retval = (ExecSqlMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.sql = "";
        this.arguments = new ArrayList<ExecSqlArgumentItem>();
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        RowMetaAndData add = ExecSql.getResultRow(new Result(), this.getUpdateField(), this.getInsertField(), this.getDeleteField(), this.getReadField());
        r.mergeRowMeta(add.getRowMeta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        DatabaseMeta databaseMeta = null;
        try {
            databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
        }
        catch (HopException e) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.DatabaseMetaError", (String[])new String[]{variables.resolve(this.connection)}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (databaseMeta != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Database db = new Database(loggingObject, variables, databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.DBConnectionOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                if (this.sql != null && this.sql.length() != 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.SQLStatementEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.SQLStatementMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage(), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.ConnectionNeeded", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.executedEachInputRow) {
            if (input.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.TransformReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.SQLOnlyExecutedOnce", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.InputReceivedOKForSQLOnlyExecuteOnce", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            DatabaseImpact ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), databaseMeta.getDatabaseName(), BaseMessages.getString(PKG, (String)"ExecSqlMeta.DatabaseMeta.Unknown.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecSqlMeta.DatabaseMeta.Unknown2.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecSqlMeta.DatabaseMeta.Unknown3.Label", (String[])new String[0]), transformMeta.getName(), this.sql, BaseMessages.getString(PKG, (String)"ExecSqlMeta.DatabaseMeta.Title", (String[])new String[0]));
            impact.add(ii);
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to get databaseMeta for connection: " + Const.CR + variables.resolve(this.connection), (Throwable)e);
        }
    }

    public boolean isReplaceVariables() {
        return this.replaceVariables;
    }

    public void setReplaceVariables(boolean replaceVariables) {
        this.replaceVariables = replaceVariables;
    }

    public boolean isQuoteString() {
        return this.quoteString;
    }

    public void setQuoteString(boolean quoteString) {
        this.quoteString = quoteString;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean isSingleStatement() {
        return this.singleStatement;
    }

    public void setSingleStatement(boolean singleStatement) {
        this.singleStatement = singleStatement;
    }
}

