/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.search;

import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableCallback;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;

public class HopGuiWorkflowSearchable
implements ISearchable<WorkflowMeta> {
    private String location;
    private WorkflowMeta workflowMeta;

    public HopGuiWorkflowSearchable(String location, WorkflowMeta workflowMeta) {
        this.location = location;
        this.workflowMeta = workflowMeta;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.workflowMeta.getName();
    }

    public String getType() {
        return "Workflow";
    }

    public String getFilename() {
        return this.workflowMeta.getFilename();
    }

    public WorkflowMeta getSearchableObject() {
        return this.workflowMeta;
    }

    public ISearchableCallback getSearchCallback() {
        return (searchable, searchResult) -> {
            ActionMeta action;
            HopGuiWorkflowGraph workflowGraph;
            HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
            perspective.activate();
            TabItemHandler tabItemHandlerWithFilename = perspective.findTabItemHandlerWithFilename(this.workflowMeta.getFilename());
            if (tabItemHandlerWithFilename != null) {
                perspective.switchToTab(tabItemHandlerWithFilename);
                workflowGraph = (HopGuiWorkflowGraph)tabItemHandlerWithFilename.getTypeHandler();
            } else {
                workflowGraph = (HopGuiWorkflowGraph)perspective.addWorkflow(HopGui.getInstance(), this.workflowMeta, perspective.getWorkflowFileType());
            }
            if (searchResult.getComponent() != null && (action = this.workflowMeta.findAction(searchResult.getComponent())) != null) {
                action.setSelected(true);
                workflowGraph.editAction(action);
            }
        };
    }
}

