/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.CharacterIndex;
import com.jayway.jsonpath.internal.filter.ExpressionNode;
import com.jayway.jsonpath.internal.filter.LogicalOperator;
import com.jayway.jsonpath.internal.filter.RelationalExpressionNode;
import com.jayway.jsonpath.internal.filter.RelationalOperator;
import com.jayway.jsonpath.internal.filter.ValueNode;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterCompiler {
    private static final Logger logger = LoggerFactory.getLogger(FilterCompiler.class);
    private static final char DOC_CONTEXT = '$';
    private static final char EVAL_CONTEXT = '@';
    private static final char OPEN_SQUARE_BRACKET = '[';
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private static final char SPACE = ' ';
    private static final char MINUS = '-';
    private static final char TICK = '\'';
    private static final char PERIOD = '.';
    private static final char LT = '<';
    private static final char GT = '>';
    private static final char EQ = '=';
    private static final char TILDE = '~';
    private static final char TRUE = 't';
    private static final char FALSE = 'f';
    private static final char NULL = 'n';
    private static final char AND = '&';
    private static final char OR = '|';
    private static final char OBJECT_OPEN = '{';
    private static final char OBJECT_CLOSE = '}';
    private static final char ARRAY_OPEN = '[';
    private static final char ARRAY_CLOSE = ']';
    private static final char BANG = '!';
    private static final char PATTERN = '/';
    private CharacterIndex filter;

    public static Filter compile(String filterString) {
        try {
            FilterCompiler compiler = new FilterCompiler(filterString);
            return new CompiledFilter(compiler.compile());
        }
        catch (Exception e) {
            throw new InvalidPathException("Could not compile inline filter : " + filterString, e);
        }
    }

    private FilterCompiler(String filterString) {
        filterString = filterString.trim();
        if (!filterString.startsWith("[") || !filterString.endsWith("]")) {
            throw new InvalidPathException("Filter must start with '[' and end with ']'. " + filterString);
        }
        if (!(filterString = filterString.substring(1, filterString.length() - 1).trim()).startsWith("?")) {
            throw new InvalidPathException("Filter must start with '[?' and end with ']'. " + filterString);
        }
        if (!(filterString = filterString.substring(1).trim()).startsWith("(") || !filterString.endsWith(")")) {
            throw new InvalidPathException("Filter must start with '[?(' and end with ')]'. " + filterString);
        }
        this.filter = new CharacterIndex(filterString);
    }

    public Predicate compile() {
        Stack<LogicalOperator> opsStack = new Stack<LogicalOperator>();
        Stack<ExpressionNode> expStack = new Stack<ExpressionNode>();
        int unbalancedBrackets = 0;
        while (this.filter.skipBlanks().inBounds()) {
            int pos = this.filter.position();
            switch (this.filter.currentChar()) {
                case '(': {
                    ++unbalancedBrackets;
                    this.filter.incrementPosition(1);
                    break;
                }
                case ')': {
                    --unbalancedBrackets;
                    this.filter.incrementPosition(1);
                    ExpressionNode expressionNode = (ExpressionNode)expStack.pop();
                    if (!opsStack.isEmpty()) {
                        if (expStack.isEmpty()) {
                            throw new InvalidPathException("Expected expression on right hand side of operator");
                        }
                        ExpressionNode right = (ExpressionNode)expStack.pop();
                        expressionNode = ExpressionNode.createExpressionNode(expressionNode, (LogicalOperator)((Object)opsStack.pop()), right);
                        while (!opsStack.isEmpty()) {
                            expressionNode = ExpressionNode.createExpressionNode(expressionNode, (LogicalOperator)((Object)opsStack.pop()), (ExpressionNode)expStack.pop());
                        }
                    }
                    expStack.push(expressionNode);
                    break;
                }
                case '!': {
                    this.filter.incrementPosition(1);
                    break;
                }
                case '&': 
                case '|': {
                    LogicalOperator operatorNode = this.readLogicalOperator();
                    opsStack.push(operatorNode);
                    break;
                }
                default: {
                    RelationalExpressionNode relationalExpressionNode = this.readExpression();
                    expStack.push(relationalExpressionNode);
                }
            }
            if (pos < this.filter.position()) continue;
            throw new InvalidPathException("Failed to parse filter " + this.filter.toString());
        }
        if (unbalancedBrackets != 0) {
            throw new InvalidPathException("Failed to parse filter. Brackets are not balanced. " + this.filter.toString());
        }
        Predicate predicate = (Predicate)expStack.pop();
        logger.trace(predicate.toString());
        return predicate;
    }

    private ValueNode readValueNode() {
        switch (this.filter.skipBlanks().currentChar()) {
            case '$': {
                return this.readPath();
            }
            case '@': {
                return this.readPath();
            }
        }
        return this.readLiteral();
    }

    private ValueNode readLiteral() {
        switch (this.filter.skipBlanks().currentChar()) {
            case '\'': {
                return this.readStringLiteral();
            }
            case 't': {
                return this.readBooleanLiteral();
            }
            case 'f': {
                return this.readBooleanLiteral();
            }
            case '-': {
                return this.readNumberLiteral();
            }
            case 'n': {
                return this.readNullLiteral();
            }
            case '{': {
                return this.readJsonLiteral();
            }
            case '[': {
                return this.readJsonLiteral();
            }
            case '/': {
                return this.readPattern();
            }
        }
        return this.readNumberLiteral();
    }

    private RelationalExpressionNode readExpression() {
        ValueNode left = this.readValueNode();
        if (this.expressionIsTerminated()) {
            ValueNode.PathNode pathNode = left.asPathNode();
            left = pathNode.asExistsCheck(pathNode.shouldExists());
            RelationalOperator operator = RelationalOperator.EXISTS;
            ValueNode.BooleanNode right = left.asPathNode().shouldExists() ? ValueNode.TRUE : ValueNode.FALSE;
            return new RelationalExpressionNode(left, operator, right);
        }
        RelationalOperator operator = this.readRelationalOperator();
        ValueNode right = this.readValueNode();
        return new RelationalExpressionNode(left, operator, right);
    }

    private LogicalOperator readLogicalOperator() {
        int begin = this.filter.skipBlanks().position();
        int end = begin + 1;
        if (!this.filter.inBounds(end)) {
            throw new InvalidPathException("Expected boolean literal");
        }
        CharSequence logicalOperator = this.filter.subSequence(begin, end + 1);
        if (!logicalOperator.equals("||") && !logicalOperator.equals("&&")) {
            throw new InvalidPathException("Expected logical operator");
        }
        this.filter.incrementPosition(logicalOperator.length());
        logger.trace("LogicalOperator from {} to {} -> [{}]", new Object[]{begin, end, logicalOperator});
        return LogicalOperator.fromString(logicalOperator.toString());
    }

    private RelationalOperator readRelationalOperator() {
        int begin = this.filter.skipBlanks().position();
        if (this.isRelationalOperatorChar(this.filter.currentChar())) {
            while (this.filter.inBounds() && this.isRelationalOperatorChar(this.filter.currentChar())) {
                this.filter.incrementPosition(1);
            }
        } else {
            while (this.filter.inBounds() && this.filter.currentChar() != ' ') {
                this.filter.incrementPosition(1);
            }
        }
        CharSequence operator = this.filter.subSequence(begin, this.filter.position());
        logger.trace("Operator from {} to {} -> [{}]", new Object[]{begin, this.filter.position() - 1, operator});
        return RelationalOperator.fromString(operator.toString());
    }

    private ValueNode.NullNode readNullLiteral() {
        CharSequence nullValue;
        int begin = this.filter.position();
        if (this.filter.currentChar() == 'n' && this.filter.inBounds(this.filter.position() + 3) && "null".equals((nullValue = this.filter.subSequence(this.filter.position(), this.filter.position() + 4)).toString())) {
            logger.trace("NullLiteral from {} to {} -> [{}]", new Object[]{begin, this.filter.position() + 3, nullValue});
            this.filter.incrementPosition(nullValue.length());
            return ValueNode.createNullNode();
        }
        throw new InvalidPathException("Expected <null> value");
    }

    private ValueNode.JsonNode readJsonLiteral() {
        int begin = this.filter.position();
        char openChar = this.filter.currentChar();
        assert (openChar == '[' || openChar == '{');
        char closeChar = openChar == '[' ? (char)']' : '}';
        int closingIndex = this.filter.indexOfMatchingCloseChar(this.filter.position(), openChar, closeChar, true, false);
        if (closingIndex == -1) {
            throw new InvalidPathException("String not closed. Expected ' in " + this.filter);
        }
        this.filter.setPosition(closingIndex + 1);
        CharSequence json = this.filter.subSequence(begin, this.filter.position());
        logger.trace("JsonLiteral from {} to {} -> [{}]", new Object[]{begin, this.filter.position(), json});
        return ValueNode.createJsonNode(json);
    }

    private ValueNode.PatternNode readPattern() {
        int begin = this.filter.position();
        int closingIndex = this.filter.nextIndexOfUnescaped('/');
        if (closingIndex == -1) {
            throw new InvalidPathException("Pattern not closed. Expected / in " + this.filter);
        }
        if (this.filter.inBounds(closingIndex + 1) && this.filter.charAt(closingIndex + 1) == 'i') {
            ++closingIndex;
        }
        this.filter.setPosition(closingIndex + 1);
        CharSequence pattern = this.filter.subSequence(begin, this.filter.position());
        logger.trace("PatternNode from {} to {} -> [{}]", new Object[]{begin, this.filter.position(), pattern});
        return ValueNode.createPatternNode(pattern);
    }

    private ValueNode.StringNode readStringLiteral() {
        int begin = this.filter.position();
        int closingTickIndex = this.filter.nextIndexOfUnescaped('\'');
        if (closingTickIndex == -1) {
            throw new InvalidPathException("String not closed. Expected ' in " + this.filter);
        }
        this.filter.setPosition(closingTickIndex + 1);
        CharSequence stringLiteral = this.filter.subSequence(begin, this.filter.position());
        logger.trace("StringLiteral from {} to {} -> [{}]", new Object[]{begin, this.filter.position(), stringLiteral});
        return ValueNode.createStringNode(stringLiteral, true);
    }

    private ValueNode.NumberNode readNumberLiteral() {
        int begin = this.filter.position();
        while (this.filter.inBounds() && this.filter.isNumberCharacter(this.filter.position())) {
            this.filter.incrementPosition(1);
        }
        CharSequence numberLiteral = this.filter.subSequence(begin, this.filter.position());
        logger.trace("NumberLiteral from {} to {} -> [{}]", new Object[]{begin, this.filter.position(), numberLiteral});
        return ValueNode.createNumberNode(numberLiteral);
    }

    private ValueNode.BooleanNode readBooleanLiteral() {
        int end;
        int begin = this.filter.position();
        int n = end = this.filter.currentChar() == 't' ? this.filter.position() + 3 : this.filter.position() + 4;
        if (!this.filter.inBounds(end)) {
            throw new InvalidPathException("Expected boolean literal");
        }
        CharSequence boolValue = this.filter.subSequence(begin, end + 1);
        if (!boolValue.equals("true") && !boolValue.equals("false")) {
            throw new InvalidPathException("Expected boolean literal");
        }
        this.filter.incrementPosition(boolValue.length());
        logger.trace("BooleanLiteral from {} to {} -> [{}]", new Object[]{begin, end, boolValue});
        return ValueNode.createBooleanNode(boolValue);
    }

    private ValueNode.PathNode readPath() {
        char previousSignificantChar = this.filter.previousSignificantChar();
        int begin = this.filter.position();
        this.filter.incrementPosition(1);
        while (this.filter.inBounds()) {
            boolean closingLogicalBracket;
            if (this.filter.currentChar() == '[') {
                int closingSquareBracketIndex = this.filter.indexOfClosingSquareBracket(this.filter.position());
                if (closingSquareBracketIndex == -1) {
                    throw new InvalidPathException("Square brackets does not match in filter " + this.filter);
                }
                this.filter.setPosition(closingSquareBracketIndex + 1);
            }
            boolean closingFunctionBracket = this.filter.currentChar() == ')' && this.currentCharIsClosingFunctionBracket(begin);
            boolean bl = closingLogicalBracket = this.filter.currentChar() == ')' && !closingFunctionBracket;
            if (!this.filter.inBounds() || this.isRelationalOperatorChar(this.filter.currentChar()) || this.filter.currentChar() == ' ' || closingLogicalBracket) break;
            this.filter.incrementPosition(1);
        }
        boolean shouldExists = previousSignificantChar != '!';
        CharSequence path = this.filter.subSequence(begin, this.filter.position());
        return ValueNode.createPathNode(path, false, shouldExists);
    }

    private boolean expressionIsTerminated() {
        char c = this.filter.currentChar();
        if (c == ')' || this.isLogicalOperatorChar(c)) {
            return true;
        }
        c = this.filter.nextSignificantChar();
        return c == ')' || this.isLogicalOperatorChar(c);
    }

    private boolean currentCharIsClosingFunctionBracket(int lowerBound) {
        if (this.filter.currentChar() != ')') {
            return false;
        }
        int idx = this.filter.indexOfPreviousSignificantChar();
        if (idx == -1 || this.filter.charAt(idx) != '(') {
            return false;
        }
        --idx;
        while (this.filter.inBounds(idx) && idx > lowerBound) {
            if (this.filter.charAt(idx) == '.') {
                return true;
            }
            --idx;
        }
        return false;
    }

    private boolean isLogicalOperatorChar(char c) {
        return c == '&' || c == '|';
    }

    private boolean isRelationalOperatorChar(char c) {
        return c == '<' || c == '>' || c == '=' || c == '~' || c == '!';
    }

    private static final class CompiledFilter
    extends Filter {
        private final Predicate predicate;

        private CompiledFilter(Predicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean apply(Predicate.PredicateContext ctx) {
            return this.predicate.apply(ctx);
        }

        public String toString() {
            String predicateString = this.predicate.toString();
            if (predicateString.startsWith("(")) {
                return "[?" + predicateString + "]";
            }
            return "[?(" + predicateString + ")]";
        }
    }
}

