/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.handler.ssl;

import org.apache.hadoop.hbase.shaded.io.netty.handler.ssl.OpenSslSessionContext;
import org.apache.hadoop.hbase.shaded.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import org.apache.tomcat.jni.SSLContext;

public final class OpenSslServerSessionContext
extends OpenSslSessionContext {
    OpenSslServerSessionContext(ReferenceCountedOpenSslContext context) {
        super(context);
    }

    @Override
    public void setSessionTimeout(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        SSLContext.setSessionCacheTimeout((long)this.context.ctx, (long)seconds);
    }

    @Override
    public int getSessionTimeout() {
        return (int)SSLContext.getSessionCacheTimeout((long)this.context.ctx);
    }

    @Override
    public void setSessionCacheSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        SSLContext.setSessionCacheSize((long)this.context.ctx, (long)size);
    }

    @Override
    public int getSessionCacheSize() {
        return (int)SSLContext.getSessionCacheSize((long)this.context.ctx);
    }

    @Override
    public void setSessionCacheEnabled(boolean enabled) {
        long mode = enabled ? 2L : 0L;
        SSLContext.setSessionCacheMode((long)this.context.ctx, (long)mode);
    }

    @Override
    public boolean isSessionCacheEnabled() {
        return SSLContext.getSessionCacheMode((long)this.context.ctx) == 2L;
    }

    public boolean setSessionIdContext(byte[] sidCtx) {
        return SSLContext.setSessionIdContext((long)this.context.ctx, (byte[])sidCtx);
    }
}

