/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.resolver.dns;

import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.hadoop.hbase.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.hadoop.hbase.shaded.io.netty.channel.AddressedEnvelope;
import org.apache.hadoop.hbase.shaded.io.netty.channel.Channel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelFactory;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelFuture;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelInitializer;
import org.apache.hadoop.hbase.shaded.io.netty.channel.ChannelOption;
import org.apache.hadoop.hbase.shaded.io.netty.channel.EventLoop;
import org.apache.hadoop.hbase.shaded.io.netty.channel.FixedRecvByteBufAllocator;
import org.apache.hadoop.hbase.shaded.io.netty.channel.socket.DatagramChannel;
import org.apache.hadoop.hbase.shaded.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DatagramDnsResponse;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DnsQuestion;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DnsRawRecord;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DnsRecord;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DnsRecordType;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.dns.DnsResponse;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.HostsFileEntriesResolver;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.InetNameResolver;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsCache;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsCacheEntry;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsNameResolverContext;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsQueryContext;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsQueryContextManager;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsServerAddressStream;
import org.apache.hadoop.hbase.shaded.io.netty.resolver.dns.DnsServerAddresses;
import org.apache.hadoop.hbase.shaded.io.netty.util.NetUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.FastThreadLocal;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.Future;
import org.apache.hadoop.hbase.shaded.io.netty.util.concurrent.Promise;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.EmptyArrays;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.ObjectUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.PlatformDependent;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.StringUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.logging.InternalLogger;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class DnsNameResolver
extends InetNameResolver {
    private static final InternalLogger logger;
    private static final String LOCALHOST = "localhost";
    private static final InetAddress LOCALHOST_ADDRESS;
    private static final DnsRecord[] EMTPY_ADDITIONALS;
    static final InternetProtocolFamily[] DEFAULT_RESOLVE_ADDRESS_TYPES;
    static final String[] DEFAULT_SEACH_DOMAINS;
    private static final DatagramDnsResponseDecoder DECODER;
    private static final DatagramDnsQueryEncoder ENCODER;
    final DnsServerAddresses nameServerAddresses;
    final Future<Channel> channelFuture;
    final DatagramChannel ch;
    final DnsQueryContextManager queryContextManager = new DnsQueryContextManager();
    private final DnsCache resolveCache;
    private final FastThreadLocal<DnsServerAddressStream> nameServerAddrStream = new FastThreadLocal<DnsServerAddressStream>(){

        @Override
        protected DnsServerAddressStream initialValue() throws Exception {
            return DnsNameResolver.this.nameServerAddresses.stream();
        }
    };
    private final long queryTimeoutMillis;
    private final int maxQueriesPerResolve;
    private final boolean traceEnabled;
    private final InternetProtocolFamily[] resolvedAddressTypes;
    private final boolean recursionDesired;
    private final int maxPayloadSize;
    private final boolean optResourceEnabled;
    private final HostsFileEntriesResolver hostsFileEntriesResolver;
    private final String[] searchDomains;
    private final int ndots;
    private final boolean cnameFollowARecords;
    private final boolean cnameFollowAAAARecords;
    private final InternetProtocolFamily preferredAddressType;
    private final DnsRecordType[] resolveRecordTypes;

    public DnsNameResolver(EventLoop eventLoop, ChannelFactory<? extends DatagramChannel> channelFactory, DnsServerAddresses nameServerAddresses, final DnsCache resolveCache, long queryTimeoutMillis, InternetProtocolFamily[] resolvedAddressTypes, boolean recursionDesired, int maxQueriesPerResolve, boolean traceEnabled, int maxPayloadSize, boolean optResourceEnabled, HostsFileEntriesResolver hostsFileEntriesResolver, String[] searchDomains, int ndots) {
        super(eventLoop);
        ObjectUtil.checkNotNull(channelFactory, "channelFactory");
        this.nameServerAddresses = ObjectUtil.checkNotNull(nameServerAddresses, "nameServerAddresses");
        this.queryTimeoutMillis = ObjectUtil.checkPositive(queryTimeoutMillis, "queryTimeoutMillis");
        this.resolvedAddressTypes = ObjectUtil.checkNonEmpty(resolvedAddressTypes, "resolvedAddressTypes");
        this.recursionDesired = recursionDesired;
        this.maxQueriesPerResolve = ObjectUtil.checkPositive(maxQueriesPerResolve, "maxQueriesPerResolve");
        this.traceEnabled = traceEnabled;
        this.maxPayloadSize = ObjectUtil.checkPositive(maxPayloadSize, "maxPayloadSize");
        this.optResourceEnabled = optResourceEnabled;
        this.hostsFileEntriesResolver = ObjectUtil.checkNotNull(hostsFileEntriesResolver, "hostsFileEntriesResolver");
        this.resolveCache = ObjectUtil.checkNotNull(resolveCache, "resolveCache");
        this.searchDomains = (String[])ObjectUtil.checkNotNull(searchDomains, "searchDomains").clone();
        this.ndots = ObjectUtil.checkPositiveOrZero(ndots, "ndots");
        boolean cnameFollowARecords = false;
        boolean cnameFollowAAAARecords = false;
        LinkedHashSet<DnsRecordType> recordTypes = new LinkedHashSet<DnsRecordType>(resolvedAddressTypes.length);
        block4: for (InternetProtocolFamily family : resolvedAddressTypes) {
            switch (family) {
                case IPv4: {
                    cnameFollowARecords = true;
                    recordTypes.add(DnsRecordType.A);
                    continue block4;
                }
                case IPv6: {
                    cnameFollowAAAARecords = true;
                    recordTypes.add(DnsRecordType.AAAA);
                    continue block4;
                }
                default: {
                    throw new Error();
                }
            }
        }
        assert (cnameFollowARecords || cnameFollowAAAARecords);
        this.cnameFollowAAAARecords = cnameFollowAAAARecords;
        this.cnameFollowARecords = cnameFollowARecords;
        this.resolveRecordTypes = recordTypes.toArray(new DnsRecordType[recordTypes.size()]);
        this.preferredAddressType = resolvedAddressTypes[0];
        Bootstrap b = new Bootstrap();
        b.group(this.executor());
        b.channelFactory(channelFactory);
        b.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, true);
        final DnsResponseHandler responseHandler = new DnsResponseHandler(this.executor().newPromise());
        b.handler(new ChannelInitializer<DatagramChannel>(){

            @Override
            protected void initChannel(DatagramChannel ch) throws Exception {
                ch.pipeline().addLast(DECODER, ENCODER, responseHandler);
            }
        });
        this.channelFuture = responseHandler.channelActivePromise;
        this.ch = (DatagramChannel)b.register().channel();
        this.ch.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(maxPayloadSize));
        this.ch.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                resolveCache.clear();
            }
        });
    }

    public DnsCache resolveCache() {
        return this.resolveCache;
    }

    public long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public List<InternetProtocolFamily> resolvedAddressTypes() {
        return Arrays.asList(this.resolvedAddressTypes);
    }

    InternetProtocolFamily[] resolveAddressTypesUnsafe() {
        return this.resolvedAddressTypes;
    }

    final String[] searchDomains() {
        return this.searchDomains;
    }

    final int ndots() {
        return this.ndots;
    }

    final boolean isCnameFollowAAAARecords() {
        return this.cnameFollowAAAARecords;
    }

    final boolean isCnameFollowARecords() {
        return this.cnameFollowARecords;
    }

    final InternetProtocolFamily preferredAddressType() {
        return this.preferredAddressType;
    }

    final DnsRecordType[] resolveRecordTypes() {
        return this.resolveRecordTypes;
    }

    public boolean isRecursionDesired() {
        return this.recursionDesired;
    }

    public int maxQueriesPerResolve() {
        return this.maxQueriesPerResolve;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public int maxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean isOptResourceEnabled() {
        return this.optResourceEnabled;
    }

    public HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    @Override
    public void close() {
        if (this.ch.isOpen()) {
            this.ch.close();
        }
    }

    @Override
    protected EventLoop executor() {
        return (EventLoop)super.executor();
    }

    private InetAddress resolveHostsFileEntry(String hostname) {
        if (this.hostsFileEntriesResolver == null) {
            return null;
        }
        InetAddress address = this.hostsFileEntriesResolver.address(hostname);
        if (address == null && PlatformDependent.isWindows() && LOCALHOST.equalsIgnoreCase(hostname)) {
            return LOCALHOST_ADDRESS;
        }
        return address;
    }

    @Override
    public final Future<InetAddress> resolve(String inetHost, Iterable<DnsRecord> additionals) {
        return this.resolve(inetHost, additionals, this.executor().newPromise());
    }

    public final Future<InetAddress> resolve(String inetHost, Iterable<DnsRecord> additionals, Promise<InetAddress> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        if (inetHost == null || inetHost.isEmpty()) {
            return promise.setSuccess(this.loopbackAddress());
        }
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        try {
            this.doResolve(inetHost, additionalsArray, promise, this.resolveCache);
            return promise;
        }
        catch (Exception e) {
            return promise.setFailure(e);
        }
    }

    public final Future<List<InetAddress>> resolveAll(String inetHost, Iterable<DnsRecord> additionals) {
        return this.resolveAll(inetHost, additionals, this.executor().newPromise());
    }

    public final Future<List<InetAddress>> resolveAll(String inetHost, Iterable<DnsRecord> additionals, Promise<List<InetAddress>> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        if (inetHost == null || inetHost.isEmpty()) {
            return promise.setSuccess(Collections.singletonList(this.loopbackAddress()));
        }
        DnsRecord[] additionalsArray = DnsNameResolver.toArray(additionals, true);
        try {
            this.doResolveAll(inetHost, additionalsArray, promise, this.resolveCache);
            return promise;
        }
        catch (Exception e) {
            return promise.setFailure(e);
        }
    }

    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        this.doResolve(inetHost, EMTPY_ADDITIONALS, promise, this.resolveCache);
    }

    private static DnsRecord[] toArray(Iterable<DnsRecord> additionals, boolean validateType) {
        ObjectUtil.checkNotNull(additionals, "additionals");
        if (additionals instanceof Collection) {
            Collection records = (Collection)additionals;
            for (DnsRecord r : additionals) {
                DnsNameResolver.validateAdditional(r, validateType);
            }
            return records.toArray(new DnsRecord[records.size()]);
        }
        Iterator<DnsRecord> additionalsIt = additionals.iterator();
        if (!additionalsIt.hasNext()) {
            return EMTPY_ADDITIONALS;
        }
        ArrayList<DnsRecord> records = new ArrayList<DnsRecord>();
        do {
            DnsRecord r = additionalsIt.next();
            DnsNameResolver.validateAdditional(r, validateType);
            records.add(r);
        } while (additionalsIt.hasNext());
        return records.toArray(new DnsRecord[records.size()]);
    }

    private static void validateAdditional(DnsRecord record, boolean validateType) {
        ObjectUtil.checkNotNull(record, "record");
        if (validateType && record instanceof DnsRawRecord) {
            throw new IllegalArgumentException("DnsRawRecord implementations not allowed: " + record);
        }
    }

    @Override
    protected final InetAddress loopbackAddress() {
        return this.preferredAddressType() == InternetProtocolFamily.IPv4 ? NetUtil.LOCALHOST4 : NetUtil.LOCALHOST6;
    }

    protected void doResolve(String inetHost, DnsRecord[] additionals, Promise<InetAddress> promise, DnsCache resolveCache) throws Exception {
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString(inetHost);
        if (bytes != null) {
            promise.setSuccess(InetAddress.getByAddress(bytes));
            return;
        }
        String hostname = DnsNameResolver.hostname(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise.setSuccess(hostsFileEntry);
            return;
        }
        if (!this.doResolveCached(hostname, additionals, promise, resolveCache)) {
            this.doResolveUncached(hostname, additionals, promise, resolveCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveCached(String hostname, DnsRecord[] additionals, Promise<InetAddress> promise, DnsCache resolveCache) {
        List<DnsCacheEntry> cachedEntries = resolveCache.get(hostname, additionals);
        if (cachedEntries == null || cachedEntries.isEmpty()) {
            return false;
        }
        InetAddress address = null;
        Throwable cause = null;
        List<DnsCacheEntry> list = cachedEntries;
        synchronized (list) {
            int numEntries = cachedEntries.size();
            assert (numEntries > 0);
            if (cachedEntries.get(0).cause() != null) {
                cause = cachedEntries.get(0).cause();
            } else {
                block3: for (InternetProtocolFamily f : this.resolvedAddressTypes) {
                    for (int i = 0; i < numEntries; ++i) {
                        DnsCacheEntry e = cachedEntries.get(i);
                        if (!f.addressType().isInstance(e.address())) continue;
                        address = e.address();
                        continue block3;
                    }
                }
            }
        }
        if (address != null) {
            DnsNameResolver.trySuccess(promise, address);
            return true;
        }
        if (cause != null) {
            DnsNameResolver.tryFailure(promise, cause);
            return true;
        }
        return false;
    }

    private static <T> void trySuccess(Promise<T> promise, T result) {
        if (!promise.trySuccess(result)) {
            logger.warn("Failed to notify success ({}) to a promise: {}", (Object)result, (Object)promise);
        }
    }

    private static void tryFailure(Promise<?> promise, Throwable cause) {
        if (!promise.tryFailure(cause)) {
            logger.warn("Failed to notify failure to a promise: {}", (Object)promise, (Object)cause);
        }
    }

    private void doResolveUncached(String hostname, DnsRecord[] additionals, Promise<InetAddress> promise, DnsCache resolveCache) {
        SingleResolverContext ctx = new SingleResolverContext(this, hostname, additionals, resolveCache);
        ctx.resolve(promise);
    }

    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        this.doResolveAll(inetHost, EMTPY_ADDITIONALS, promise, this.resolveCache);
    }

    protected void doResolveAll(String inetHost, DnsRecord[] additionals, Promise<List<InetAddress>> promise, DnsCache resolveCache) throws Exception {
        byte[] bytes = NetUtil.createByteArrayFromIpAddressString(inetHost);
        if (bytes != null) {
            promise.setSuccess(Collections.singletonList(InetAddress.getByAddress(bytes)));
            return;
        }
        String hostname = DnsNameResolver.hostname(inetHost);
        InetAddress hostsFileEntry = this.resolveHostsFileEntry(hostname);
        if (hostsFileEntry != null) {
            promise.setSuccess(Collections.singletonList(hostsFileEntry));
            return;
        }
        if (!this.doResolveAllCached(hostname, additionals, promise, resolveCache)) {
            this.doResolveAllUncached(hostname, additionals, promise, resolveCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doResolveAllCached(String hostname, DnsRecord[] additionals, Promise<List<InetAddress>> promise, DnsCache resolveCache) {
        List<DnsCacheEntry> cachedEntries = resolveCache.get(hostname, additionals);
        if (cachedEntries == null || cachedEntries.isEmpty()) {
            return false;
        }
        ArrayList<InetAddress> result = null;
        Throwable cause = null;
        List<DnsCacheEntry> list = cachedEntries;
        synchronized (list) {
            int numEntries = cachedEntries.size();
            assert (numEntries > 0);
            if (cachedEntries.get(0).cause() != null) {
                cause = cachedEntries.get(0).cause();
            } else {
                for (InternetProtocolFamily f : this.resolvedAddressTypes) {
                    for (int i = 0; i < numEntries; ++i) {
                        DnsCacheEntry e = cachedEntries.get(i);
                        if (!f.addressType().isInstance(e.address())) continue;
                        if (result == null) {
                            result = new ArrayList<InetAddress>(numEntries);
                        }
                        result.add(e.address());
                    }
                }
            }
        }
        if (result != null) {
            DnsNameResolver.trySuccess(promise, result);
            return true;
        }
        if (cause != null) {
            DnsNameResolver.tryFailure(promise, cause);
            return true;
        }
        return false;
    }

    private void doResolveAllUncached(String hostname, DnsRecord[] additionals, Promise<List<InetAddress>> promise, DnsCache resolveCache) {
        ListResolverContext ctx = new ListResolverContext(this, hostname, additionals, resolveCache);
        ctx.resolve(promise);
    }

    private static String hostname(String inetHost) {
        String hostname = IDN.toASCII(inetHost);
        if (StringUtil.endsWith(inetHost, '.') && !StringUtil.endsWith(hostname, '.')) {
            hostname = hostname + ".";
        }
        return hostname;
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question) {
        return this.query(this.nextNameServerAddress(), question);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.query(this.nextNameServerAddress(), question, additionals);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query(this.nextNameServerAddress(), question, Collections.<DnsRecord>emptyList(), promise);
    }

    private InetSocketAddress nextNameServerAddress() {
        return this.nameServerAddrStream.get().next();
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question) {
        return this.query0(nameServerAddr, question, EMTPY_ADDITIONALS, this.ch.eventLoop().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additionals) {
        return this.query0(nameServerAddr, question, DnsNameResolver.toArray(additionals, false), this.ch.eventLoop().newPromise());
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query0(nameServerAddr, question, EMTPY_ADDITIONALS, promise);
    }

    public Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query(InetSocketAddress nameServerAddr, DnsQuestion question, Iterable<DnsRecord> additionals, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        return this.query0(nameServerAddr, question, DnsNameResolver.toArray(additionals, false), promise);
    }

    Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> query0(InetSocketAddress nameServerAddr, DnsQuestion question, DnsRecord[] additionals, Promise<AddressedEnvelope<? extends DnsResponse, InetSocketAddress>> promise) {
        Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> castPromise = DnsNameResolver.cast(ObjectUtil.checkNotNull(promise, "promise"));
        try {
            new DnsQueryContext(this, nameServerAddr, question, additionals, castPromise).query();
            return castPromise;
        }
        catch (Exception e) {
            return castPromise.setFailure(e);
        }
    }

    private static Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> cast(Promise<?> promise) {
        return promise;
    }

    static {
        String[] searchDomains;
        logger = InternalLoggerFactory.getInstance(DnsNameResolver.class);
        EMTPY_ADDITIONALS = new DnsRecord[0];
        if (NetUtil.isIpV4StackPreferred()) {
            DEFAULT_RESOLVE_ADDRESS_TYPES = new InternetProtocolFamily[]{InternetProtocolFamily.IPv4};
            LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
        } else {
            DEFAULT_RESOLVE_ADDRESS_TYPES = new InternetProtocolFamily[2];
            if (NetUtil.isIpV6AddressesPreferred()) {
                DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv6;
                DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv4;
                LOCALHOST_ADDRESS = NetUtil.LOCALHOST6;
            } else {
                DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[0] = InternetProtocolFamily.IPv4;
                DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES[1] = InternetProtocolFamily.IPv6;
                LOCALHOST_ADDRESS = NetUtil.LOCALHOST4;
            }
        }
        try {
            Class<?> configClass = Class.forName("sun.net.dns.ResolverConfiguration");
            Method open = configClass.getMethod("open", new Class[0]);
            Method nameservers = configClass.getMethod("searchlist", new Class[0]);
            Object instance = open.invoke(null, new Object[0]);
            List list = (List)nameservers.invoke(instance, new Object[0]);
            searchDomains = list.toArray(new String[list.size()]);
        }
        catch (Exception ignore) {
            searchDomains = EmptyArrays.EMPTY_STRINGS;
        }
        DEFAULT_SEACH_DOMAINS = searchDomains;
        DECODER = new DatagramDnsResponseDecoder();
        ENCODER = new DatagramDnsQueryEncoder();
    }

    private final class DnsResponseHandler
    extends ChannelInboundHandlerAdapter {
        private final Promise<Channel> channelActivePromise;

        DnsResponseHandler(Promise<Channel> channelActivePromise) {
            this.channelActivePromise = channelActivePromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                DnsQueryContext qCtx;
                DatagramDnsResponse res = (DatagramDnsResponse)msg;
                int queryId = res.id();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} RECEIVED: [{}: {}], {}", DnsNameResolver.this.ch, queryId, res.sender(), res);
                }
                if ((qCtx = DnsNameResolver.this.queryContextManager.get(res.sender(), queryId)) == null) {
                    logger.warn("{} Received a DNS response with an unknown ID: {}", (Object)DnsNameResolver.this.ch, (Object)queryId);
                    return;
                }
                qCtx.finish(res);
            }
            finally {
                ReferenceCountUtil.safeRelease(msg);
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            this.channelActivePromise.setSuccess(ctx.channel());
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            logger.warn("{} Unexpected exception: ", (Object)DnsNameResolver.this.ch, (Object)cause);
        }
    }

    static final class ListResolverContext
    extends DnsNameResolverContext<List<InetAddress>> {
        ListResolverContext(DnsNameResolver parent, String hostname, DnsRecord[] additionals, DnsCache resolveCache) {
            super(parent, hostname, additionals, resolveCache);
        }

        @Override
        DnsNameResolverContext<List<InetAddress>> newResolverContext(DnsNameResolver parent, String hostname, DnsRecord[] additionals, DnsCache resolveCache) {
            return new ListResolverContext(parent, hostname, additionals, resolveCache);
        }

        @Override
        boolean finishResolve(Class<? extends InetAddress> addressType, List<DnsCacheEntry> resolvedEntries, Promise<List<InetAddress>> promise) {
            ArrayList<InetAddress> result = null;
            int numEntries = resolvedEntries.size();
            for (int i = 0; i < numEntries; ++i) {
                InetAddress a = resolvedEntries.get(i).address();
                if (!addressType.isInstance(a)) continue;
                if (result == null) {
                    result = new ArrayList<InetAddress>(numEntries);
                }
                result.add(a);
            }
            if (result != null) {
                promise.trySuccess(result);
                return true;
            }
            return false;
        }
    }

    static final class SingleResolverContext
    extends DnsNameResolverContext<InetAddress> {
        SingleResolverContext(DnsNameResolver parent, String hostname, DnsRecord[] additionals, DnsCache resolveCache) {
            super(parent, hostname, additionals, resolveCache);
        }

        @Override
        DnsNameResolverContext<InetAddress> newResolverContext(DnsNameResolver parent, String hostname, DnsRecord[] additionals, DnsCache resolveCache) {
            return new SingleResolverContext(parent, hostname, additionals, resolveCache);
        }

        @Override
        boolean finishResolve(Class<? extends InetAddress> addressType, List<DnsCacheEntry> resolvedEntries, Promise<InetAddress> promise) {
            int numEntries = resolvedEntries.size();
            for (int i = 0; i < numEntries; ++i) {
                InetAddress a = resolvedEntries.get(i).address();
                if (!addressType.isInstance(a)) continue;
                DnsNameResolver.trySuccess(promise, a);
                return true;
            }
            return false;
        }
    }
}

