/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.configuration;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.AbstractConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.CombinedConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.Configuration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.ConfigurationBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.ConfigurationException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.FileConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.SystemConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.XMLConfiguration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.beanutils.BeanFactory;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.beanutils.BeanHelper;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.beanutils.XMLBeanDeclaration;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.tree.OverrideCombiner;
import org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.tree.UnionCombiner;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.text.StrLookup;

public class DefaultConfigurationBuilder
extends XMLConfiguration
implements ConfigurationBuilder {
    public static final String ADDITIONAL_NAME = (class$org$apache$commons$configuration$DefaultConfigurationBuilder == null ? (class$org$apache$commons$configuration$DefaultConfigurationBuilder = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.DefaultConfigurationBuilder")) : class$org$apache$commons$configuration$DefaultConfigurationBuilder).getName() + "/ADDITIONAL_CONFIG";
    public static final int EVENT_ERR_LOAD_OPTIONAL = 51;
    static final String CONFIG_BEAN_FACTORY_NAME = (class$org$apache$commons$configuration$DefaultConfigurationBuilder == null ? (class$org$apache$commons$configuration$DefaultConfigurationBuilder = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.DefaultConfigurationBuilder")) : class$org$apache$commons$configuration$DefaultConfigurationBuilder).getName() + ".CONFIG_BEAN_FACTORY_NAME";
    static final String ATTR_NAME = "[@config-name]";
    static final String ATTR_ATNAME = "at";
    static final String ATTR_AT_RES = "[@config-at]";
    static final String ATTR_AT = "[@at]";
    static final String ATTR_OPTIONALNAME = "optional";
    static final String ATTR_OPTIONAL_RES = "[@config-optional]";
    static final String ATTR_OPTIONAL = "[@optional]";
    static final String ATTR_FILENAME = "[@fileName]";
    static final String ATTR_FORCECREATE = "[@config-forceCreate]";
    static final String KEY_SYSTEM_PROPS = "[@systemProperties]";
    static final String SEC_HEADER = "header";
    static final String KEY_UNION = "additional";
    static final String[] CONFIG_SECTIONS = new String[]{"additional", "override", "header"};
    static final String KEY_OVERRIDE = "override";
    static final String KEY_OVERRIDE_LIST = "header.combiner.override.list-nodes.node";
    static final String KEY_ADDITIONAL_LIST = "header.combiner.additional.list-nodes.node";
    static final String KEY_CONFIGURATION_PROVIDERS = "header.providers.provider";
    static final String KEY_PROVIDER_KEY = "[@config-tag]";
    static final String KEY_CONFIGURATION_LOOKUPS = "header.lookups.lookup";
    static final String KEY_LOOKUP_KEY = "[@config-prefix]";
    static final String KEY_RESULT = "header.result";
    static final String KEY_COMBINER = "header.result.nodeCombiner";
    static final String EXT_XML = ".xml";
    private static final ConfigurationProvider PROPERTIES_PROVIDER = new FileExtensionConfigurationProvider(class$org$apache$commons$configuration$XMLPropertiesConfiguration == null ? (class$org$apache$commons$configuration$XMLPropertiesConfiguration = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.XMLPropertiesConfiguration")) : class$org$apache$commons$configuration$XMLPropertiesConfiguration, class$org$apache$commons$configuration$PropertiesConfiguration == null ? (class$org$apache$commons$configuration$PropertiesConfiguration = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.PropertiesConfiguration")) : class$org$apache$commons$configuration$PropertiesConfiguration, ".xml");
    private static final ConfigurationProvider XML_PROVIDER = new XMLConfigurationProvider();
    private static final ConfigurationProvider JNDI_PROVIDER = new ConfigurationProvider(class$org$apache$commons$configuration$JNDIConfiguration == null ? (class$org$apache$commons$configuration$JNDIConfiguration = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.JNDIConfiguration")) : class$org$apache$commons$configuration$JNDIConfiguration);
    private static final ConfigurationProvider SYSTEM_PROVIDER = new ConfigurationProvider(class$org$apache$commons$configuration$SystemConfiguration == null ? (class$org$apache$commons$configuration$SystemConfiguration = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.SystemConfiguration")) : class$org$apache$commons$configuration$SystemConfiguration);
    private static final ConfigurationProvider PLIST_PROVIDER = new FileExtensionConfigurationProvider("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.plist.XMLPropertyListConfiguration", "org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.plist.PropertyListConfiguration", ".xml");
    private static final ConfigurationProvider BUILDER_PROVIDER = new ConfigurationBuilderProvider();
    private static final String[] DEFAULT_TAGS = new String[]{"properties", "xml", "hierarchicalXml", "jndi", "system", "plist", "configuration"};
    private static final ConfigurationProvider[] DEFAULT_PROVIDERS = new ConfigurationProvider[]{PROPERTIES_PROVIDER, XML_PROVIDER, XML_PROVIDER, JNDI_PROVIDER, SYSTEM_PROVIDER, PLIST_PROVIDER, BUILDER_PROVIDER};
    private static final long serialVersionUID = -3113777854714492123L;
    private CombinedConfiguration constructedConfiguration;
    private Map providers = new HashMap();
    private String configurationBasePath;
    static /* synthetic */ Class class$org$apache$commons$configuration$DefaultConfigurationBuilder;
    static /* synthetic */ Class class$org$apache$commons$configuration$XMLPropertiesConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$PropertiesConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$JNDIConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$SystemConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$CombinedConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$Configuration;
    static /* synthetic */ Class class$org$apache$commons$configuration$XMLConfiguration;

    public DefaultConfigurationBuilder() {
        this.registerDefaultProviders();
        this.registerBeanFactory();
        this.setLogger(LogFactory.getLog(this.getClass()));
        this.addErrorLogListener();
    }

    public DefaultConfigurationBuilder(File file) {
        this();
        this.setFile(file);
    }

    public DefaultConfigurationBuilder(String fileName) throws ConfigurationException {
        this();
        this.setFileName(fileName);
    }

    public DefaultConfigurationBuilder(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
    }

    public String getConfigurationBasePath() {
        return this.configurationBasePath != null ? this.configurationBasePath : this.getBasePath();
    }

    public void setConfigurationBasePath(String configurationBasePath) {
        this.configurationBasePath = configurationBasePath;
    }

    public void addConfigurationProvider(String tagName, ConfigurationProvider provider) {
        if (tagName == null) {
            throw new IllegalArgumentException("Tag name must not be null!");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        this.providers.put(tagName, provider);
    }

    public ConfigurationProvider removeConfigurationProvider(String tagName) {
        return (ConfigurationProvider)this.providers.remove(tagName);
    }

    public ConfigurationProvider providerForTag(String tagName) {
        return (ConfigurationProvider)this.providers.get(tagName);
    }

    public Configuration getConfiguration() throws ConfigurationException {
        return this.getConfiguration(true);
    }

    public CombinedConfiguration getConfiguration(boolean load) throws ConfigurationException {
        CombinedConfiguration result;
        if (load) {
            this.load();
        }
        this.initSystemProperties();
        this.registerConfiguredProviders();
        this.registerConfiguredLookups();
        this.constructedConfiguration = result = this.createResultConfiguration();
        List overrides = this.fetchTopLevelOverrideConfigs();
        overrides.addAll(this.fetchChildConfigs(KEY_OVERRIDE));
        this.initCombinedConfiguration(result, overrides, KEY_OVERRIDE_LIST);
        List additionals = this.fetchChildConfigs(KEY_UNION);
        if (!additionals.isEmpty()) {
            CombinedConfiguration addConfig = new CombinedConfiguration(new UnionCombiner());
            result.addConfiguration(addConfig, ADDITIONAL_NAME);
            this.initCombinedConfiguration(addConfig, additionals, KEY_ADDITIONAL_LIST);
        }
        return result;
    }

    protected CombinedConfiguration createResultConfiguration() throws ConfigurationException {
        XMLBeanDeclaration decl = new XMLBeanDeclaration(this, KEY_RESULT, true);
        CombinedConfiguration result = (CombinedConfiguration)BeanHelper.createBean(decl, class$org$apache$commons$configuration$CombinedConfiguration == null ? (class$org$apache$commons$configuration$CombinedConfiguration = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.CombinedConfiguration")) : class$org$apache$commons$configuration$CombinedConfiguration);
        if (this.getMaxIndex(KEY_COMBINER) < 0) {
            result.setNodeCombiner(new OverrideCombiner());
        }
        return result;
    }

    protected void initCombinedConfiguration(CombinedConfiguration config, List containedConfigs, String keyListNodes) throws ConfigurationException {
        List listNodes = this.getList(keyListNodes);
        Iterator it = listNodes.iterator();
        while (it.hasNext()) {
            config.getNodeCombiner().addListNode((String)it.next());
        }
        it = containedConfigs.iterator();
        while (it.hasNext()) {
            HierarchicalConfiguration conf = (HierarchicalConfiguration)it.next();
            ConfigurationDeclaration decl = new ConfigurationDeclaration(this, conf);
            AbstractConfiguration newConf = this.createConfigurationAt(decl);
            if (newConf == null) continue;
            config.addConfiguration(newConf, decl.getConfiguration().getString(ATTR_NAME), decl.getAt());
        }
    }

    protected void registerDefaultProviders() {
        for (int i = 0; i < DEFAULT_TAGS.length; ++i) {
            this.addConfigurationProvider(DEFAULT_TAGS[i], DEFAULT_PROVIDERS[i]);
        }
    }

    protected void registerConfiguredProviders() throws ConfigurationException {
        List nodes = this.configurationsAt(KEY_CONFIGURATION_PROVIDERS);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            HierarchicalConfiguration config = (HierarchicalConfiguration)it.next();
            XMLBeanDeclaration decl = new XMLBeanDeclaration(config);
            String key = config.getString(KEY_PROVIDER_KEY);
            this.addConfigurationProvider(key, (ConfigurationProvider)BeanHelper.createBean(decl));
        }
    }

    protected void registerConfiguredLookups() throws ConfigurationException {
        List nodes = this.configurationsAt(KEY_CONFIGURATION_LOOKUPS);
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            HierarchicalConfiguration config = (HierarchicalConfiguration)it.next();
            XMLBeanDeclaration decl = new XMLBeanDeclaration(config);
            String key = config.getString(KEY_LOOKUP_KEY);
            ConfigurationInterpolator.registerGlobalLookup(key, (StrLookup)BeanHelper.createBean(decl));
        }
    }

    protected void initSystemProperties() throws ConfigurationException {
        String fileName = this.getString(KEY_SYSTEM_PROPS);
        if (fileName != null) {
            try {
                SystemConfiguration.setSystemProperties(fileName);
            }
            catch (Exception ex) {
                throw new ConfigurationException("Error setting system properties from " + fileName, ex);
            }
        }
    }

    protected Object interpolate(Object value) {
        Object result = super.interpolate(value);
        if (this.constructedConfiguration != null) {
            result = this.constructedConfiguration.interpolate(result);
        }
        return result;
    }

    protected void fireError(int type, String propName, Object propValue, Throwable ex) {
        super.fireError(type, propName, propValue, ex);
    }

    private AbstractConfiguration createConfigurationAt(ConfigurationDeclaration decl) throws ConfigurationException {
        try {
            return (AbstractConfiguration)BeanHelper.createBean(decl);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
    }

    private List fetchChildConfigs(ConfigurationNode node) {
        List children = node.getChildren();
        ArrayList<SubnodeConfiguration> result = new ArrayList<SubnodeConfiguration>(children.size());
        Iterator it = children.iterator();
        while (it.hasNext()) {
            result.add(this.createSubnodeConfiguration((HierarchicalConfiguration.Node)it.next()));
        }
        return result;
    }

    private List fetchChildConfigs(String key) {
        List nodes = this.fetchNodeList(key);
        if (nodes.size() > 0) {
            return this.fetchChildConfigs((ConfigurationNode)nodes.get(0));
        }
        return Collections.EMPTY_LIST;
    }

    private List fetchTopLevelOverrideConfigs() {
        List configs = this.fetchChildConfigs(this.getRootNode());
        Iterator it = configs.iterator();
        block0: while (it.hasNext()) {
            String nodeName = ((SubnodeConfiguration)it.next()).getRootNode().getName();
            for (int i = 0; i < CONFIG_SECTIONS.length; ++i) {
                if (!CONFIG_SECTIONS[i].equals(nodeName)) continue;
                it.remove();
                continue block0;
            }
        }
        return configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBeanFactory() {
        Class clazz = class$org$apache$commons$configuration$DefaultConfigurationBuilder == null ? (class$org$apache$commons$configuration$DefaultConfigurationBuilder = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.DefaultConfigurationBuilder")) : class$org$apache$commons$configuration$DefaultConfigurationBuilder;
        synchronized (clazz) {
            if (!BeanHelper.registeredFactoryNames().contains(CONFIG_BEAN_FACTORY_NAME)) {
                BeanHelper.registerBeanFactory(CONFIG_BEAN_FACTORY_NAME, new ConfigurationBeanFactory());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ConfigurationBuilderProvider
    extends ConfigurationProvider {
        public ConfigurationBuilderProvider() {
            super(class$org$apache$commons$configuration$DefaultConfigurationBuilder == null ? (class$org$apache$commons$configuration$DefaultConfigurationBuilder = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.DefaultConfigurationBuilder")) : class$org$apache$commons$configuration$DefaultConfigurationBuilder);
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration decl) throws Exception {
            DefaultConfigurationBuilder builder = (DefaultConfigurationBuilder)super.getConfiguration(decl);
            return builder.getConfiguration(true);
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration decl) throws Exception {
            return new CombinedConfiguration();
        }
    }

    static class FileExtensionConfigurationProvider
    extends FileConfigurationProvider {
        private Class matchingClass;
        private String matchingClassName;
        private Class defaultClass;
        private String defaultClassName;
        private String fileExtension;

        public FileExtensionConfigurationProvider(Class matchingClass, Class defaultClass, String extension) {
            this.matchingClass = matchingClass;
            this.defaultClass = defaultClass;
            this.fileExtension = extension;
        }

        public FileExtensionConfigurationProvider(String matchingClassName, String defaultClassName, String extension) {
            this.matchingClassName = matchingClassName;
            this.defaultClassName = defaultClassName;
            this.fileExtension = extension;
        }

        protected synchronized Class fetchMatchingClass() throws Exception {
            if (this.matchingClass == null) {
                this.matchingClass = this.loadClass(this.matchingClassName);
            }
            return this.matchingClass;
        }

        protected synchronized Class fetchDefaultClass() throws Exception {
            if (this.defaultClass == null) {
                this.defaultClass = this.loadClass(this.defaultClassName);
            }
            return this.defaultClass;
        }

        protected Object createBeanInstance(Class beanClass, BeanDeclaration data) throws Exception {
            String fileName = ((ConfigurationDeclaration)data).getConfiguration().getString(DefaultConfigurationBuilder.ATTR_FILENAME);
            if (fileName != null && fileName.toLowerCase().trim().endsWith(this.fileExtension)) {
                return super.createBeanInstance(this.fetchMatchingClass(), data);
            }
            return super.createBeanInstance(this.fetchDefaultClass(), data);
        }
    }

    public static class XMLConfigurationProvider
    extends FileConfigurationProvider {
        public XMLConfigurationProvider() {
            super(class$org$apache$commons$configuration$XMLConfiguration == null ? (class$org$apache$commons$configuration$XMLConfiguration = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.XMLConfiguration")) : class$org$apache$commons$configuration$XMLConfiguration);
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration decl) throws Exception {
            XMLConfiguration config = (XMLConfiguration)super.getEmptyConfiguration(decl);
            DefaultConfigurationBuilder builder = decl.getConfigurationBuilder();
            config.getRegisteredEntities().putAll(builder.getRegisteredEntities());
            return config;
        }
    }

    public static class FileConfigurationProvider
    extends ConfigurationProvider {
        public FileConfigurationProvider() {
        }

        public FileConfigurationProvider(Class configClass) {
            super(configClass);
        }

        public FileConfigurationProvider(String configClassName) {
            super(configClassName);
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration decl) throws Exception {
            AbstractConfiguration result = this.getEmptyConfiguration(decl);
            ((FileConfiguration)((Object)result)).load();
            return result;
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration decl) throws Exception {
            return super.getConfiguration(decl);
        }

        protected void initBeanInstance(Object bean, BeanDeclaration data) throws Exception {
            FileConfiguration config = (FileConfiguration)bean;
            config.setBasePath(((ConfigurationDeclaration)data).getConfigurationBuilder().getConfigurationBasePath());
            super.initBeanInstance(bean, data);
        }
    }

    static class ConfigurationBeanFactory
    implements BeanFactory {
        ConfigurationBeanFactory() {
        }

        public Object createBean(Class beanClass, BeanDeclaration data, Object param) throws Exception {
            ConfigurationDeclaration decl = (ConfigurationDeclaration)data;
            String tagName = decl.getNode().getName();
            ConfigurationProvider provider = decl.getConfigurationBuilder().providerForTag(tagName);
            if (provider == null) {
                throw new ConfigurationRuntimeException("No ConfigurationProvider registered for tag " + tagName);
            }
            try {
                return provider.getConfiguration(decl);
            }
            catch (Exception ex) {
                if (!decl.isOptional()) {
                    throw ex;
                }
                decl.getConfigurationBuilder().fireError(51, decl.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_NAME), null, ex);
                if (decl.isForceCreate()) {
                    try {
                        return provider.getEmptyConfiguration(decl);
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                return null;
            }
        }

        public Class getDefaultBeanClass() {
            return class$org$apache$commons$configuration$Configuration == null ? (class$org$apache$commons$configuration$Configuration = DefaultConfigurationBuilder.class$("org.apache.hadoop.hbase.shaded.org.apache.commons.configuration.Configuration")) : class$org$apache$commons$configuration$Configuration;
        }
    }

    public static class ConfigurationDeclaration
    extends XMLBeanDeclaration {
        private DefaultConfigurationBuilder configurationBuilder;

        public ConfigurationDeclaration(DefaultConfigurationBuilder builder, HierarchicalConfiguration config) {
            super(config);
            this.configurationBuilder = builder;
        }

        public DefaultConfigurationBuilder getConfigurationBuilder() {
            return this.configurationBuilder;
        }

        public String getAt() {
            String result = this.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_AT_RES);
            return result == null ? this.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_AT) : result;
        }

        public boolean isOptional() {
            Boolean value = this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_OPTIONAL_RES, null);
            if (value == null) {
                value = this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_OPTIONAL, Boolean.FALSE);
            }
            return value;
        }

        public boolean isForceCreate() {
            return this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_FORCECREATE, false);
        }

        public String getBeanFactoryName() {
            return CONFIG_BEAN_FACTORY_NAME;
        }

        public String getBeanClassName() {
            return null;
        }

        protected boolean isReservedNode(ConfigurationNode nd) {
            if (super.isReservedNode(nd)) {
                return true;
            }
            return nd.isAttribute() && (DefaultConfigurationBuilder.ATTR_ATNAME.equals(nd.getName()) && nd.getParentNode().getAttributeCount("config-at") == 0 || DefaultConfigurationBuilder.ATTR_OPTIONALNAME.equals(nd.getName()) && nd.getParentNode().getAttributeCount("config-optional") == 0);
        }

        protected Object interpolate(Object value) {
            return this.getConfigurationBuilder().interpolate(value);
        }
    }

    public static class ConfigurationProvider
    extends DefaultBeanFactory {
        private Class configurationClass;
        private String configurationClassName;

        public ConfigurationProvider() {
            this((Class)null);
        }

        public ConfigurationProvider(Class configClass) {
            this.setConfigurationClass(configClass);
        }

        public ConfigurationProvider(String configClassName) {
            this.setConfigurationClassName(configClassName);
        }

        public Class getConfigurationClass() {
            return this.configurationClass;
        }

        public void setConfigurationClass(Class configurationClass) {
            this.configurationClass = configurationClass;
        }

        public String getConfigurationClassName() {
            return this.configurationClassName;
        }

        public void setConfigurationClassName(String configurationClassName) {
            this.configurationClassName = configurationClassName;
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration decl) throws Exception {
            return (AbstractConfiguration)this.createBean(this.fetchConfigurationClass(), decl, null);
        }

        public AbstractConfiguration getEmptyConfiguration(ConfigurationDeclaration decl) throws Exception {
            return null;
        }

        protected synchronized Class fetchConfigurationClass() throws Exception {
            if (this.getConfigurationClass() == null) {
                this.setConfigurationClass(this.loadClass(this.getConfigurationClassName()));
            }
            return this.getConfigurationClass();
        }

        protected Class loadClass(String className) throws ClassNotFoundException {
            return className != null ? Class.forName(className, true, this.getClass().getClassLoader()) : null;
        }
    }
}

