/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.jcodings;

import org.apache.hadoop.hbase.shaded.org.jcodings.Encoding;
import org.apache.hadoop.hbase.shaded.org.jcodings.EncodingList;
import org.apache.hadoop.hbase.shaded.org.jcodings.exception.InternalException;
import org.apache.hadoop.hbase.shaded.org.jcodings.specific.ASCIIEncoding;
import org.apache.hadoop.hbase.shaded.org.jcodings.util.CaseInsensitiveBytesHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodingDB {
    private static String[] builtin = new String[]{"ASCII-8BIT", "ASCII", "Big5", "BIG5", "Big5-HKSCS", "Big5HKSCS", "Big5-UAO", "Big5UAO", "CP949", "CP949", "Emacs-Mule", "EmacsMule", "EUC-JP", "EUCJP", "EUC-KR", "EUCKR", "EUC-TW", "EUCTW", "GB18030", "GB18030", "GBK", "GBK", "ISO-8859-1", "ISO8859_1", "ISO-8859-2", "ISO8859_2", "ISO-8859-3", "ISO8859_3", "ISO-8859-4", "ISO8859_4", "ISO-8859-5", "ISO8859_5", "ISO-8859-6", "ISO8859_6", "ISO-8859-7", "ISO8859_7", "ISO-8859-8", "ISO8859_8", "ISO-8859-9", "ISO8859_9", "ISO-8859-10", "ISO8859_10", "ISO-8859-11", "ISO8859_11", "ISO-8859-13", "ISO8859_13", "ISO-8859-14", "ISO8859_14", "ISO-8859-15", "ISO8859_15", "ISO-8859-16", "ISO8859_16", "KOI8-R", "KOI8R", "KOI8-U", "KOI8U", "Shift_JIS", "SJIS", "US-ASCII", "USASCII", "UTF-8", "UTF8", "UTF-16BE", "UTF16BE", "UTF-16LE", "UTF16LE", "UTF-32BE", "UTF32BE", "UTF-32LE", "UTF32LE", "Windows-1251", "CP1251", "GB2312", "EUCKR"};
    static Entry ascii;
    static final CaseInsensitiveBytesHash<Entry> encodings;
    static final CaseInsensitiveBytesHash<Entry> aliases;

    public static final CaseInsensitiveBytesHash<Entry> getEncodings() {
        return encodings;
    }

    public static final CaseInsensitiveBytesHash<Entry> getAliases() {
        return aliases;
    }

    public static void declare(String name, String encodingClass) {
        byte[] bytes = name.getBytes();
        if (encodings.get(bytes) != null) {
            throw new InternalException("encoding already registerd <%n>", name);
        }
        encodings.putDirect(bytes, new Entry(encodingClass));
    }

    public static void alias(String alias, String original) {
        byte[] origBytes = original.getBytes();
        Entry originalEntry = encodings.get(origBytes);
        if (originalEntry == null) {
            throw new InternalException("no such encoding <%n>", original);
        }
        byte[] aliasBytes = alias.getBytes();
        if (aliases.get(aliasBytes) != null) {
            throw new InternalException("encoding alias already registerd <%n>", alias);
        }
        aliases.putDirect(aliasBytes, originalEntry);
    }

    public static void replicate(String replica, String original) {
        byte[] origBytes = original.getBytes();
        Entry originalEntry = encodings.get(origBytes);
        if (originalEntry == null) {
            throw new InternalException("no such encoding <%n>", original);
        }
        byte[] replicaBytes = replica.getBytes();
        if (encodings.get(replicaBytes) != null) {
            throw new InternalException("encoding replica already registerd <%n>", replica);
        }
        encodings.putDirect(replicaBytes, new Entry(replicaBytes, originalEntry));
    }

    public static void set_base(String name, String original) {
    }

    public static void dummy(String name) {
        byte[] bytes = name.getBytes();
        if (encodings.get(bytes) != null) {
            throw new InternalException("encoding already registerd <%n>", name);
        }
        encodings.putDirect(bytes, new Entry(bytes));
    }

    static {
        encodings = new CaseInsensitiveBytesHash(builtin.length);
        aliases = new CaseInsensitiveBytesHash(builtin.length);
        for (int i = 0; i < builtin.length / 2; ++i) {
            EncodingDB.declare(builtin[i << 1], builtin[(i << 1) + 1]);
        }
        builtin = null;
        ascii = encodings.get("ASCII-8BIT".getBytes());
        String[][] encList = EncodingList.LIST;
        block7: for (int i = 0; i < encList.length; ++i) {
            String[] enc = encList[i];
            switch (enc[0].charAt(0)) {
                case 'R': {
                    EncodingDB.replicate(enc[1], enc[2]);
                    continue block7;
                }
                case 'A': {
                    EncodingDB.alias(enc[1], enc[2]);
                    continue block7;
                }
                case 'S': {
                    EncodingDB.set_base(enc[1], enc[2]);
                    continue block7;
                }
                case 'D': {
                    EncodingDB.dummy(enc[1]);
                    continue block7;
                }
                default: {
                    throw new InternalException("Unknown flag: " + enc[0].charAt(0));
                }
            }
        }
    }

    public static final class Entry {
        private static int count;
        private final Entry base;
        private Encoding encoding;
        private final String encodingClass;
        private final int index;
        private final boolean isDummy;
        private final byte[] name;

        private Entry(byte[] name, String encodingClass, Entry base, boolean isDummy) {
            this.name = name;
            this.encodingClass = encodingClass;
            this.base = base;
            this.isDummy = isDummy;
            this.index = count++;
        }

        Entry(String encodingClass) {
            this(null, encodingClass, null, false);
        }

        Entry(byte[] name, Entry base) {
            this(name, base.encodingClass, base, false);
        }

        Entry(byte[] name) {
            this(name, EncodingDB.ascii.encodingClass, ascii, true);
        }

        public int hashCode() {
            return this.encodingClass.hashCode();
        }

        public Entry getBase() {
            return this.base;
        }

        public Encoding getEncoding() {
            if (this.encoding == null) {
                this.encoding = this.name == null ? Encoding.load(this.encodingClass) : (this.isDummy ? ASCIIEncoding.DUMMY.replicate(this.name) : Encoding.load(this.encodingClass).replicate(this.name));
            }
            return this.encoding;
        }

        public String getEncodingClass() {
            return this.encodingClass;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isDummy() {
            return this.isDummy;
        }
    }
}

