/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.mortbay.servlet;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConcatServlet
extends HttpServlet {
    boolean _development;
    long _lastModified;
    ServletContext _context;

    public void init() throws ServletException {
        this._lastModified = System.currentTimeMillis();
        this._context = this.getServletContext();
        this._development = "true".equals(this.getInitParameter("development"));
    }

    protected long getLastModified(HttpServletRequest req) {
        return this._development ? -1L : this._lastModified;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int i;
        String q = req.getQueryString();
        if (q == null) {
            resp.sendError(204);
            return;
        }
        String[] parts = q.split("\\&");
        String type = null;
        for (i = 0; i < parts.length; ++i) {
            String t = this._context.getMimeType(parts[i]);
            if (t == null) continue;
            if (type == null) {
                type = t;
                continue;
            }
            if (type.equals(t)) continue;
            resp.sendError(415);
            return;
        }
        if (type != null) {
            resp.setContentType(type);
        }
        for (i = 0; i < parts.length; ++i) {
            RequestDispatcher dispatcher = this._context.getRequestDispatcher(parts[i]);
            if (dispatcher == null) continue;
            dispatcher.include((ServletRequest)req, (ServletResponse)resp);
        }
    }
}

