/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.HadoopMapReduceCommitProtocol;
import org.apache.spark.internal.io.HadoopWriteConfigUtil;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

public final class SparkHadoopWriter$
implements Logging {
    public static SparkHadoopWriter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkHadoopWriter$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <K, V> void write(RDD<Tuple2<K, V>> rdd, HadoopWriteConfigUtil<K, V> config, ClassTag<V> evidence$1) {
        SparkContext sparkContext = rdd.context();
        int commitJobId = rdd.id();
        String jobTrackerId = SparkHadoopWriterUtils$.MODULE$.createJobTrackerID(new Date());
        JobContext jobContext = config.createJobContext(jobTrackerId, commitJobId);
        config.initOutputFormat(jobContext);
        config.assertConf(jobContext, rdd.conf());
        jobContext.getConfiguration().set("spark.sql.sources.writeJobUUID", UUID.randomUUID().toString());
        HadoopMapReduceCommitProtocol committer = config.createCommitter(commitJobId);
        committer.setupJob(jobContext);
        try {
            FileCommitProtocol.TaskCommitMessage[] ret = (FileCommitProtocol.TaskCommitMessage[])sparkContext.runJob(rdd, (Function2 & Serializable & scala.Serializable)(context, iter) -> {
                int attemptId = context.stageAttemptNumber() << 16 | context.attemptNumber();
                return MODULE$.executeTask((TaskContext)context, config, jobTrackerId, commitJobId, context.partitionId(), attemptId, committer, (Iterator)iter, evidence$1);
            }, ClassTag$.MODULE$.apply(FileCommitProtocol.TaskCommitMessage.class));
            committer.commitJob(jobContext, (Seq<FileCommitProtocol.TaskCommitMessage>)Predef$.MODULE$.wrapRefArray((Object[])ret));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Job ").append(jobContext.getJobID()).append(" committed.").toString());
        }
        catch (Throwable cause) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Aborting job ").append(jobContext.getJobID()).append(".").toString(), cause);
            committer.abortJob(jobContext);
            throw new SparkException("Job aborted.", cause);
        }
    }

    private <K, V> FileCommitProtocol.TaskCommitMessage executeTask(TaskContext context, HadoopWriteConfigUtil<K, V> config, String jobTrackerId, int commitJobId, int sparkPartitionId, int sparkAttemptNumber, FileCommitProtocol committer, Iterator<Tuple2<K, V>> iterator, ClassTag<V> evidence$2) {
        FileCommitProtocol.TaskCommitMessage taskCommitMessage;
        TaskAttemptContext taskContext = config.createTaskAttemptContext(jobTrackerId, commitJobId, sparkPartitionId, sparkAttemptNumber);
        committer.setupTask(taskContext);
        config.initWriter(taskContext, sparkPartitionId);
        LongRef recordsWritten = LongRef.create((long)0L);
        Tuple2<OutputMetrics, Function0<Object>> tuple2 = SparkHadoopWriterUtils$.MODULE$.initHadoopOutputMetrics(context);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        OutputMetrics outputMetrics = (OutputMetrics)tuple2._1();
        Function0 callback = (Function0)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)outputMetrics, (Object)callback);
        Tuple2 tuple23 = tuple22;
        OutputMetrics outputMetrics2 = (OutputMetrics)tuple23._1();
        Function0 callback2 = (Function0)tuple23._2();
        try {
            Function0 & Serializable & scala.Serializable x$1 = (Function0 & Serializable & scala.Serializable)() -> {
                while (iterator.hasNext()) {
                    Tuple2 pair = (Tuple2)iterator.next();
                    config.write(pair);
                    SparkHadoopWriterUtils$.MODULE$.maybeUpdateOutputMetrics(outputMetrics2, (Function0<Object>)callback2, recordsWritten$1.elem);
                    ++recordsWritten$1.elem;
                }
                config.closeWriter(taskContext);
                return committer.commitTask(taskContext);
            };
            JFunction0.mcV.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    config.closeWriter(taskContext);
                }
                finally {
                    committer.abortTask(taskContext);
                    MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Task ").append(taskContext.getTaskAttemptID()).append(" aborted.").toString());
                }
            };
            JFunction0.mcV.sp & Serializable & scala.Serializable x$3 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(x$1);
            FileCommitProtocol.TaskCommitMessage ret = (FileCommitProtocol.TaskCommitMessage)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks(x$1, (Function0<BoxedUnit>)x$2, (Function0<BoxedUnit>)x$3);
            outputMetrics2.setBytesWritten(callback2.apply$mcJ$sp());
            outputMetrics2.setRecordsWritten(recordsWritten.elem);
            taskCommitMessage = ret;
        }
        catch (Throwable t) {
            throw new SparkException("Task failed while writing rows", t);
        }
        return taskCommitMessage;
    }

    private SparkHadoopWriter$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

