/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.BadParameterException;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.status.api.v1.TaskMetrics;
import org.apache.spark.status.api.v1.TaskSorting;
import org.apache.spark.status.api.v1.TaskStatus;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.jobs.ApiHelper$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\tMa!\u0002\u0006\f\u0001-9\u0002\"\u0002\u0012\u0001\t\u0003!\u0003\"\u0002\u0014\u0001\t\u00039\u0003\"B+\u0001\t\u00031\u0006\"B;\u0001\t\u00031\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tY\n\u0001C\u0001\u0003;Cq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002z\u0002!\t!a?\u0003\u001dM#\u0018mZ3t%\u0016\u001cx.\u001e:dK*\u0011A\"D\u0001\u0003mFR!AD\b\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0011#\u000511\u000f^1ukNT!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\n\u0004\u0001aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"AB!osJ+g\r\u0005\u0002 A5\t1\"\u0003\u0002\"\u0017\ty!)Y:f\u0003B\u0004(+Z:pkJ\u001cW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005)\u0003CA\u0010\u0001\u0003%\u0019H/Y4f\u0019&\u001cH\u000f\u0006\u0002)oA\u0019\u0011&\r\u001b\u000f\u0005)zcBA\u0016/\u001b\u0005a#BA\u0017$\u0003\u0019a$o\\8u}%\t1$\u0003\u000215\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001a4\u0005\r\u0019V-\u001d\u0006\u0003ai\u0001\"aH\u001b\n\u0005YZ!!C*uC\u001e,G)\u0019;b\u0011\u0015A$\u00011\u0001:\u0003!\u0019H/\u0019;vg\u0016\u001c\bc\u0001\u001e@\u00036\t1H\u0003\u0002={\u0005!Q\u000f^5m\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\t1K7\u000f\u001e\t\u0003?\tK!aQ\u0006\u0003\u0017M#\u0018mZ3Ti\u0006$Xo\u001d\u0015\u0005o\u0015{\u0005\u000b\u0005\u0002G\u001b6\tqI\u0003\u0002I\u0013\u0006\u0011!o\u001d\u0006\u0003\u0015.\u000b!a^:\u000b\u00031\u000bQA[1wCbL!AT$\u0003\u0015E+XM]=QCJ\fW.A\u0003wC2,X-I\u0001\u0011Q\t\u0011!\u000b\u0005\u0002G'&\u0011Ak\u0012\u0002\u0004\u000f\u0016#\u0016!C:uC\u001e,G)\u0019;b)\rAs+\u0019\u0005\u00061\u000e\u0001\r!W\u0001\bgR\fw-Z%e!\tI\",\u0003\u0002\\5\t\u0019\u0011J\u001c;)\t]kv\n\u0019\t\u0003\rzK!aX$\u0003\u0013A\u000bG\u000f\u001b)be\u0006l\u0017%\u0001-\t\u000b\t\u001c\u0001\u0019A2\u0002\u000f\u0011,G/Y5mgB\u0011\u0011\u0004Z\u0005\u0003Kj\u0011qAQ8pY\u0016\fg\u000e\u000b\u0003bO>S\u0007C\u0001$i\u0013\tIwI\u0001\u0007EK\u001a\fW\u000f\u001c;WC2,X-I\u0001l\u0003\u0011!(/^3)\t\u0005,u*\\\u0011\u0002E\"\"1a\\(s!\t1\u0005/\u0003\u0002r\u000f\n!\u0001+\u0019;iC\u0005\u0019\u0018AD>ti\u0006<W-\u00133;Aq#7& \u0015\u0003\u0007I\u000bab\u001c8f\u0003R$X-\u001c9u\t\u0006$\u0018\r\u0006\u00035ofl\b\"\u0002-\u0005\u0001\u0004I\u0006\u0006B<^\u001f\u0002DQA\u001f\u0003A\u0002e\u000bab\u001d;bO\u0016\fE\u000f^3naRLE\r\u000b\u0003z;>c\u0018%\u0001>\t\u000b\t$\u0001\u0019A2)\tu<wJ\u001b\u0015\u0005{\u0016{U\u000eK\u0003\u0005_>\u000b\u0019!\t\u0002\u0002\u0006\u0005!3p\u001d;bO\u0016LEM\u000f\u0011]I.jxf_:uC\u001e,\u0017\t\u001e;f[B$\u0018\n\u001a\u001e!9\u0012\\S\u0010\u000b\u0002\u0005%\u0006YA/Y:l'VlW.\u0019:z)!\ti!a\u0005\u0002\u0018\u0005m\u0001cA\u0010\u0002\u0010%\u0019\u0011\u0011C\u0006\u0003/Q\u000b7o['fiJL7\rR5tiJL'-\u001e;j_:\u001c\b\"\u0002-\u0006\u0001\u0004I\u0006&BA\n;>\u0003\u0007\"\u0002>\u0006\u0001\u0004I\u0006&BA\f;>c\bbBA\u000f\u000b\u0001\u0007\u0011qD\u0001\u000fcV\fg\u000e^5mKN#(/\u001b8h!\u0011\t\t#!\u000b\u000f\t\u0005\r\u0012Q\u0005\t\u0003WiI1!a\n\u001b\u0003\u0019\u0001&/\u001a3fM&!\u00111FA\u0017\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0005\u000e)\r\u0005mQiTA\u0019C\t\t\u0019$A\u0005rk\u0006tG/\u001b7fg\"2\u00111D4P\u0003o\t#!!\u000f\u0002/Ar\u0003'\u000e\u00171]I*D\u0006\r\u00186YArs'\u000e\u00171]e*\u0004&B\u0003p\u001f\u0006u\u0012EAA \u0003AZ8\u000f^1hK&#'\b\t/eWu|3p\u001d;bO\u0016\fE\u000f^3naRLEM\u000f\u0011]I.jx\u0006^1tWN+X.\\1ss\"\u0012QAU\u0001\ti\u0006\u001c8\u000eT5tiRq\u0011qIA(\u0003'\n9&!\u001a\u0002t\u0005\u001d\u0005\u0003B\u00152\u0003\u0013\u00022aHA&\u0013\r\tie\u0003\u0002\t)\u0006\u001c8\u000eR1uC\")\u0001L\u0002a\u00013\"*\u0011qJ/PA\")!P\u0002a\u00013\"*\u00111K/Py\"1\u0011\u0011\f\u0004A\u0002e\u000baa\u001c4gg\u0016$\bFBA,\u000b>\u000bi&\t\u0002\u0002Z!2\u0011qK4P\u0003C\n#!a\u0019\u0002\u0003ABa!a\u001a\u0007\u0001\u0004I\u0016A\u00027f]\u001e$\b\u000e\u000b\u0004\u0002f\u0015{\u00151N\u0011\u0003\u0003OBc!!\u001ah\u001f\u0006=\u0014EAA9\u0003\t\u0011\u0004\u0007C\u0004\u0002v\u0019\u0001\r!a\u001e\u0002\rM|'\u000f\u001e\"z!\ry\u0012\u0011P\u0005\u0004\u0003wZ!a\u0003+bg.\u001cvN\u001d;j]\u001eDc!a\u001dF\u001f\u0006}\u0014EAA;Q\u0019\t\u0019hZ(\u0002\u0004\u0006\u0012\u0011QQ\u0001\u0003\u0013\u0012Ca\u0001\u000f\u0004A\u0002\u0005%\u0005\u0003\u0002\u001e@\u0003\u0017\u00032aHAG\u0013\r\tyi\u0003\u0002\u000b)\u0006\u001c8n\u0015;biV\u001c\b&BAD\u000b>\u0003\u0006&\u0002\u0004p\u001f\u0006U\u0015EAAL\u00035Z8\u000f^1hK&#'\b\t/eWu|3p\u001d;bO\u0016\fE\u000f^3naRLEM\u000f\u0011]I.jx\u0006^1tW2K7\u000f\u001e\u0015\u0003\rI\u000b\u0011\u0002^1tWR\u000b'\r\\3\u0015\u0015\u0005}\u0015\u0011WA[\u0003s\u000by\fE\u0004;\u0003C\u000by\"!*\n\u0007\u0005\r6HA\u0004ICNDW*\u00199\u0011\t\u0005\u001d\u0016QV\u0007\u0003\u0003SS1!a+>\u0003\u0011a\u0017M\\4\n\t\u0005=\u0016\u0011\u0016\u0002\u0007\u001f\nTWm\u0019;\t\u000ba;\u0001\u0019A-)\u000b\u0005EVl\u00141\t\u000bi<\u0001\u0019A-)\u000b\u0005UVl\u0014?\t\u000b\t<\u0001\u0019A2)\u000b\u0005evm\u00146)\u000b\u0005eViT7\t\u000f\u0005\u0005w\u00011\u0001\u0002D\u00069QO]5J]\u001a|\u0007\u0003BAc\u0003\u0017l!!a2\u000b\u0007\u0005%w)\u0001\u0003d_J,\u0017\u0002BAg\u0003\u000f\u0014q!\u0016:j\u0013:4w\u000e\u000b\u0003\u0002@\u0006E\u0007\u0003BAc\u0003'LA!!6\u0002H\n91i\u001c8uKb$\b&B\u0004p\u001f\u0006e\u0017EAAn\u00039Z8\u000f^1hK&#'\b\t/eWu|3p\u001d;bO\u0016\fE\u000f^3naRLEM\u000f\u0011]I.jx\u0006^1tWR\u000b'\r\\3)\u0005\u001d\u0011\u0016\u0001\u00043p!\u0006<\u0017N\\1uS>tG\u0003DA$\u0003G\fi/a<\u0002r\u0006U\bbBAs\u0011\u0001\u0007\u0011q]\u0001\u0010cV,'/\u001f)be\u0006lW\r^3sgBA\u0011QYAu\u0003?\ty\"\u0003\u0003\u0002l\u0006\u001d'AD'vYRLg/\u00197vK\u0012l\u0015\r\u001d\u0005\u00061\"\u0001\r!\u0017\u0005\u0006u\"\u0001\r!\u0017\u0005\u0007\u0003gD\u0001\u0019A2\u0002\u0011%\u001c8+Z1sG\"Da!a>\t\u0001\u0004I\u0016\u0001\u0004;pi\u0006d'+Z2pe\u0012\u001c\u0018A\u00044jYR,'\u000fV1tW2K7\u000f\u001e\u000b\u0007\u0003\u000f\niP!\u0001\t\u000f\u0005}\u0018\u00021\u0001\u0002H\u0005aA/Y:l\t\u0006$\u0018\rT5ti\"9!1A\u0005A\u0002\u0005}\u0011aC:fCJ\u001c\u0007NV1mk\u0016Dc\u0001\u0001B\u0004\u001f\n5\u0001c\u0001$\u0003\n%\u0019!1B$\u0003\u0011A\u0013x\u000eZ;dKNd#Aa\u0004\"\u0005\tE\u0011\u0001E1qa2L7-\u0019;j_:|#n]8o\u0001")
public class StagesResource
implements BaseAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$(this, fn);
    }

    @Override
    public void checkUIViewPermissions() {
        BaseAppResource.checkUIViewPermissions$(this);
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public String appId() {
        return this.appId;
    }

    @Override
    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    @Override
    public String attemptId() {
        return this.attemptId;
    }

    @Override
    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    public Seq<StageData> stageList(@QueryParam(value="status") List<StageStatus> statuses) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$1 -> x$1.store().stageList(statuses));
    }

    @GET
    @Path(value="{stageId: \\d+}")
    public Seq<StageData> stageData(@PathParam(value="stageId") int stageId, @QueryParam(value="details") @DefaultValue(value="true") boolean details) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            Seq<StageData> ret = ui.store().stageData(stageId, details);
            if (!ret.nonEmpty()) {
                throw new NotFoundException(new StringBuilder(15).append("unknown stage: ").append(stageId).toString());
            }
            return ret;
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}")
    public StageData oneAttemptData(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @QueryParam(value="details") @DefaultValue(value="true") boolean details) {
        return (StageData)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            StageData stageData;
            try {
                stageData = (StageData)ui.store().stageAttempt(stageId, stageAttemptId, details)._1();
            }
            catch (NoSuchElementException noSuchElementException) {
                String string;
                Seq<StageData> all = ui.store().stageData(stageId, ui.store().stageData$default$2());
                if (all.nonEmpty()) {
                    Seq ids = (Seq)all.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.attemptId()), Seq$.MODULE$.canBuildFrom());
                    string = new StringBuilder(47).append("unknown attempt for stage ").append(stageId).append(".  Found attempts: [").append(ids.mkString(",")).append("]").toString();
                } else {
                    string = new StringBuilder(15).append("unknown stage: ").append(stageId).toString();
                }
                String msg = string;
                throw new NotFoundException(msg);
            }
            return stageData;
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskSummary")
    public TaskMetricDistributions taskSummary(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0.05,0.25,0.5,0.75,0.95") @QueryParam(value="quantiles") String quantileString) {
        return (TaskMetricDistributions)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            double[] quantiles = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])quantileString.split(","))).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToDouble((double)StagesResource.$anonfun$taskSummary$2(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            return (TaskMetricDistributions)ui.store().taskSummary(stageId, stageAttemptId, quantiles).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException(new StringBuilder(38).append("No tasks reported metrics for ").append(stageId).append(" / ").append(stageAttemptId).append(" yet.").toString());
            });
        });
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskList")
    public Seq<TaskData> taskList(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @DefaultValue(value="20") @QueryParam(value="length") int length, @DefaultValue(value="ID") @QueryParam(value="sortBy") TaskSorting sortBy, @QueryParam(value="status") List<TaskStatus> statuses) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$3 -> x$3.store().taskList(stageId, stageAttemptId, offset, length, sortBy, statuses));
    }

    @GET
    @Path(value="{stageId: \\d+}/{stageAttemptId: \\d+}/taskTable")
    public HashMap<String, Object> taskTable(@PathParam(value="stageId") int stageId, @PathParam(value="stageAttemptId") int stageAttemptId, @QueryParam(value="details") @DefaultValue(value="true") boolean details, @Context UriInfo uriInfo) {
        return (HashMap)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            Object object;
            MultivaluedMap uriQueryParameters = uriInfo.getQueryParameters(true);
            String totalRecords = (String)uriQueryParameters.getFirst((Object)"numTasks");
            boolean isSearch = false;
            String searchValue = null;
            String filteredRecords = totalRecords;
            if (uriQueryParameters.getFirst((Object)"search[value]") != null && ((String)uriQueryParameters.getFirst((Object)"search[value]")).length() > 0) {
                isSearch = true;
                searchValue = (String)uriQueryParameters.getFirst((Object)"search[value]");
            }
            Seq<TaskData> _tasksToShow = this.doPagination((MultivaluedMap<String, String>)uriQueryParameters, stageId, stageAttemptId, isSearch, new StringOps(Predef$.MODULE$.augmentString(totalRecords)).toInt());
            HashMap<String, Object> ret = new HashMap<String, Object>();
            if (_tasksToShow.nonEmpty()) {
                if (isSearch) {
                    Seq<TaskData> filteredTaskList = this.filterTaskList(_tasksToShow, searchValue);
                    filteredRecords = ((Object)BoxesRunTime.boxToInteger((int)filteredTaskList.length())).toString();
                    if (filteredTaskList.length() > 0) {
                        int pageStartIndex = new StringOps(Predef$.MODULE$.augmentString((String)uriQueryParameters.getFirst((Object)"start"))).toInt();
                        int pageLength = new StringOps(Predef$.MODULE$.augmentString((String)uriQueryParameters.getFirst((Object)"length"))).toInt();
                        object = ret.put("aaData", filteredTaskList.slice(pageStartIndex, pageStartIndex + pageLength));
                    } else {
                        object = ret.put("aaData", filteredTaskList);
                    }
                } else {
                    object = ret.put("aaData", _tasksToShow);
                }
            } else {
                object = ret.put("aaData", _tasksToShow);
            }
            ret.put("recordsTotal", totalRecords);
            ret.put("recordsFiltered", filteredRecords);
            return ret;
        });
    }

    public Seq<TaskData> doPagination(MultivaluedMap<String, String> queryParameters, int stageId, int stageAttemptId, boolean isSearch, int totalRecords) {
        IntRef pageLength;
        IntRef pageStartIndex;
        String isAscendingStr;
        ObjectRef columnNameToSort;
        block1: {
            columnNameToSort = ObjectRef.create((Object)((String)queryParameters.getFirst((Object)"columnNameToSort")));
            if (((String)columnNameToSort.elem).equalsIgnoreCase("Logs")) {
                columnNameToSort.elem = "Index";
            }
            isAscendingStr = (String)queryParameters.getFirst((Object)"order[0][dir]");
            pageStartIndex = IntRef.create((int)0);
            pageLength = IntRef.create((int)totalRecords);
            if (isSearch) break block1;
            pageStartIndex.elem = new StringOps(Predef$.MODULE$.augmentString((String)queryParameters.getFirst((Object)"start"))).toInt();
            pageLength.elem = new StringOps(Predef$.MODULE$.augmentString((String)queryParameters.getFirst((Object)"length"))).toInt();
        }
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$4 -> x$4.store().taskList(stageId, stageAttemptId, pageStartIndex$1.elem, pageLength$1.elem, ApiHelper$.MODULE$.indexName((String)columnNameToSort$1.elem), isAscendingStr.equalsIgnoreCase("asc"), x$4.store().taskList$default$7()));
    }

    public Seq<TaskData> filterTaskList(Seq<TaskData> taskDataList, String searchValue) {
        String defaultOptionString = "d";
        String searchValueLowerCase = searchValue.toLowerCase(Locale.ROOT);
        Function1 & Serializable & scala.Serializable containsValue = (Function1 & Serializable & scala.Serializable)taskDataParams -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$filterTaskList$1(searchValueLowerCase, taskDataParams));
        Function1 & Serializable & scala.Serializable taskMetricsContainsValue = (Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$filterTaskList$2(containsValue, task));
        Seq filteredTaskDataSequence = (Seq)taskDataList.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)StagesResource.$anonfun$filterTaskList$3(containsValue, defaultOptionString, taskMetricsContainsValue, f)));
        return filteredTaskDataSequence;
    }

    public static final /* synthetic */ double $anonfun$taskSummary$2(String s) {
        double d;
        try {
            d = new StringOps(Predef$.MODULE$.augmentString(s)).toDouble();
        }
        catch (NumberFormatException nfe) {
            throw new BadParameterException("quantiles", "double", s);
        }
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$filterTaskList$1(String searchValueLowerCase$1, Object taskDataParams) {
        return taskDataParams.toString().toLowerCase(Locale.ROOT).contains(searchValueLowerCase$1);
    }

    public static final /* synthetic */ boolean $anonfun$filterTaskList$2(Function1 containsValue$1, TaskData task) {
        boolean bl;
        Option<TaskMetrics> option = task.taskMetrics();
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            bl = BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).executorDeserializeTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).executorRunTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).jvmGcTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).resultSerializationTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).memoryBytesSpilled()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).diskBytesSpilled()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).peakExecutionMemory()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).inputMetrics().bytesRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).inputMetrics().recordsRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).outputMetrics().bytesWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).outputMetrics().recordsWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().fetchWaitTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().remoteBytesRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().localBytesRead() + ((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().remoteBytesRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).shuffleReadMetrics().recordsRead()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)Utils$.MODULE$.bytesToString(((TaskMetrics)task.taskMetrics().get()).shuffleWriteMetrics().bytesWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)((TaskMetrics)task.taskMetrics().get()).shuffleWriteMetrics().recordsWritten()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(((TaskMetrics)task.taskMetrics().get()).shuffleWriteMetrics().writeTime() / 1000000L)));
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterTaskList$3(Function1 containsValue$1, String defaultOptionString$1, Function1 taskMetricsContainsValue$1, TaskData f) {
        return BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToLong((long)f.taskId()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToInteger((int)f.index()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToInteger((int)f.attempt()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDate(f.launchTime()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply(f.resultFetchStart().getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultOptionString$1))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.executorId())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.host())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.status())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)f.taskLocality())) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)BoxesRunTime.boxToBoolean((boolean)f.speculative()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply(f.errorMessage().getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultOptionString$1))) || BoxesRunTime.unboxToBoolean((Object)taskMetricsContainsValue$1.apply((Object)f)) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(f.schedulerDelay()))) || BoxesRunTime.unboxToBoolean((Object)containsValue$1.apply((Object)UIUtils$.MODULE$.formatDuration(f.gettingResultTime())));
    }

    public StagesResource() {
        ApiRequestContext.$init$(this);
        BaseAppResource.$init$(this);
    }
}

