/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.OutputStream;
import org.apache.beam.runners.flink.FlinkJobInvoker;
import org.apache.beam.runners.jobsubmission.JobServerDriver;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.fn.server.ServerFactory;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkJobServerDriver
extends JobServerDriver {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkJobServerDriver.class);

    public static void main(String[] args) throws Exception {
        PipelineOptions options = PipelineOptionsFactory.create();
        ((GcsOptions)options.as(GcsOptions.class)).setGcsUploadBufferSizeBytes(Integer.valueOf(0x100000));
        FileSystems.setDefaultPipelineOptions((PipelineOptions)options);
        FlinkJobServerDriver.fromParams(args).run();
    }

    private static void printUsage(CmdLineParser parser) {
        System.err.println(String.format("Usage: java %s arguments...", FlinkJobServerDriver.class.getSimpleName()));
        parser.printUsage((OutputStream)System.err);
        System.err.println();
    }

    public static FlinkServerConfiguration parseArgs(String[] args) {
        FlinkServerConfiguration configuration = new FlinkServerConfiguration();
        CmdLineParser parser = new CmdLineParser((Object)configuration);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            LOG.error("Unable to parse command line arguments.", (Throwable)e);
            FlinkJobServerDriver.printUsage(parser);
            throw new IllegalArgumentException("Unable to parse command line arguments.", e);
        }
        return configuration;
    }

    public static FlinkJobServerDriver fromParams(String[] args) {
        return FlinkJobServerDriver.fromConfig(FlinkJobServerDriver.parseArgs(args));
    }

    public static FlinkJobServerDriver fromConfig(FlinkServerConfiguration configuration) {
        return FlinkJobServerDriver.create(configuration, FlinkJobServerDriver.createJobServerFactory((JobServerDriver.ServerConfiguration)configuration), FlinkJobServerDriver.createArtifactServerFactory((JobServerDriver.ServerConfiguration)configuration), () -> FlinkJobInvoker.create(configuration));
    }

    public static FlinkJobServerDriver fromConfig(FlinkServerConfiguration configuration, JobServerDriver.JobInvokerFactory jobInvokerFactory) {
        return FlinkJobServerDriver.create(configuration, FlinkJobServerDriver.createJobServerFactory((JobServerDriver.ServerConfiguration)configuration), FlinkJobServerDriver.createArtifactServerFactory((JobServerDriver.ServerConfiguration)configuration), jobInvokerFactory);
    }

    private static FlinkJobServerDriver create(FlinkServerConfiguration configuration, ServerFactory jobServerFactory, ServerFactory artifactServerFactory, JobServerDriver.JobInvokerFactory jobInvokerFactory) {
        return new FlinkJobServerDriver(configuration, jobServerFactory, artifactServerFactory, jobInvokerFactory);
    }

    private FlinkJobServerDriver(FlinkServerConfiguration configuration, ServerFactory jobServerFactory, ServerFactory artifactServerFactory, JobServerDriver.JobInvokerFactory jobInvokerFactory) {
        super((JobServerDriver.ServerConfiguration)configuration, jobServerFactory, artifactServerFactory, jobInvokerFactory);
    }

    public static class FlinkServerConfiguration
    extends JobServerDriver.ServerConfiguration {
        @Option(name="--flink-master", aliases={"--flink-master-url"}, usage="Flink master address (host:port) to submit the job against. Use Use \"[local]\" to start a local cluster for the execution. Use \"[auto]\" if you plan to either execute locally or submit through Flink's CLI.")
        private String flinkMaster = "[auto]";
        @Option(name="--flink-conf-dir", usage="Directory containing Flink YAML configuration files. These properties will be set to all jobs submitted to Flink and take precedence over configurations in FLINK_CONF_DIR.")
        private String flinkConfDir = null;

        String getFlinkMaster() {
            return this.flinkMaster;
        }

        @Nullable String getFlinkConfDir() {
            return this.flinkConfDir;
        }
    }
}

