/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.OutputStream;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMiniClusterEntryPoint {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkMiniClusterEntryPoint.class);

    public static void main(String[] args) throws Exception {
        MiniClusterArgs miniClusterArgs = FlinkMiniClusterEntryPoint.parseArgs(args);
        Configuration flinkConfig = new Configuration();
        flinkConfig.setInteger(RestOptions.PORT, miniClusterArgs.restPort);
        if (!miniClusterArgs.restBindAddress.isEmpty()) {
            flinkConfig.setString(RestOptions.BIND_ADDRESS, miniClusterArgs.restBindAddress);
        }
        MiniClusterConfiguration clusterConfig = new MiniClusterConfiguration.Builder().setConfiguration(flinkConfig).setNumTaskManagers(miniClusterArgs.numTaskManagers).setNumSlotsPerTaskManager(miniClusterArgs.numSlotsPerTaskManager).build();
        try (MiniCluster miniCluster = new MiniCluster(clusterConfig);){
            miniCluster.start();
            System.out.println(String.format("Started Flink mini cluster (%s TaskManagers with %s task slots) with Rest API at %s", miniClusterArgs.numTaskManagers, miniClusterArgs.numSlotsPerTaskManager, miniCluster.getRestAddress()));
            Thread.sleep(Long.MAX_VALUE);
        }
    }

    private static MiniClusterArgs parseArgs(String[] args) {
        MiniClusterArgs configuration = new MiniClusterArgs();
        CmdLineParser parser = new CmdLineParser((Object)configuration);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            LOG.error("Unable to parse command line arguments.", (Throwable)e);
            FlinkMiniClusterEntryPoint.printUsage(parser);
            throw new IllegalArgumentException("Unable to parse command line arguments.", e);
        }
        return configuration;
    }

    private static void printUsage(CmdLineParser parser) {
        System.err.println(String.format("Usage: java %s arguments...", FlinkMiniClusterEntryPoint.class.getSimpleName()));
        parser.printUsage((OutputStream)System.err);
        System.err.println();
    }

    static class MiniClusterArgs {
        @Option(name="--rest-port")
        int restPort = 0;
        @Option(name="--rest-bind-address")
        String restBindAddress = "";
        @Option(name="--num-task-managers")
        int numTaskManagers = 1;
        @Option(name="--num-task-slots-per-taskmanager")
        int numSlotsPerTaskManager = 1;

        MiniClusterArgs() {
        }
    }
}

