/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.direct_java.runners.core.InMemoryMultimapSideInputView;
import org.apache.beam.repackaged.direct_java.runners.core.ReadyCheckingSideInputReader;
import org.apache.beam.repackaged.direct_java.runners.core.StateInternals;
import org.apache.beam.repackaged.direct_java.runners.core.StateNamespaces;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SideInputHandler
implements ReadyCheckingSideInputReader {
    private static final Set<String> SUPPORTED_MATERIALIZATIONS = ImmutableSet.of((Object)"beam:side_input:iterable:v1", (Object)"beam:side_input:multimap:v1");
    protected final Collection<PCollectionView<?>> sideInputs;
    private final StateInternals stateInternals;
    private final Map<PCollectionView<?>, StateTag<CombiningState<BoundedWindow, Set<BoundedWindow>, Set<BoundedWindow>>>> availableWindowsTags;
    private final Map<PCollectionView<?>, StateTag<ValueState<Iterable<?>>>> sideInputContentsTags;

    public SideInputHandler(Collection<PCollectionView<?>> sideInputs, StateInternals stateInternals) {
        this.sideInputs = sideInputs;
        this.stateInternals = stateInternals;
        this.availableWindowsTags = new HashMap();
        this.sideInputContentsTags = new HashMap();
        for (PCollectionView<?> sideInput : sideInputs) {
            Preconditions.checkArgument((boolean)SUPPORTED_MATERIALIZATIONS.contains(sideInput.getViewFn().getMaterialization().getUrn()), (String)"This handler is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", SUPPORTED_MATERIALIZATIONS, (Object)sideInput.getViewFn().getMaterialization().getUrn(), (Object)sideInput.getTagInternal().getId());
            Coder<?> windowCoder = sideInput.getWindowingStrategyInternal().getWindowFn().windowCoder();
            StateTag<CombiningState<BoundedWindow, Set<BoundedWindow>, Set<BoundedWindow>>> availableTag = StateTags.combiningValue("side-input-available-windows-" + sideInput.getTagInternal().getId(), SetCoder.of(windowCoder), new WindowSetCombineFn());
            this.availableWindowsTags.put(sideInput, availableTag);
            StateTag<ValueState<?>> stateTag = StateTags.value("side-input-data-" + sideInput.getTagInternal().getId(), IterableCoder.of(sideInput.getCoderInternal()));
            this.sideInputContentsTags.put(sideInput, stateTag);
        }
    }

    public void addSideInputValue(PCollectionView<?> sideInput, WindowedValue<Iterable<?>> value) {
        Coder<?> windowCoder = sideInput.getWindowingStrategyInternal().getWindowFn().windowCoder();
        StateTag<ValueState<Iterable<?>>> stateTag = this.sideInputContentsTags.get(sideInput);
        for (BoundedWindow window : value.getWindows()) {
            this.stateInternals.state(StateNamespaces.window(windowCoder, window), stateTag).write(value.getValue());
            this.stateInternals.state(StateNamespaces.global(), this.availableWindowsTags.get(sideInput)).add(window);
        }
    }

    @Override
    public <T> @Nullable T get(PCollectionView<T> view, BoundedWindow window) {
        Iterable elements = this.getIterable(view, window);
        switch (view.getViewFn().getMaterialization().getUrn()) {
            case "beam:side_input:iterable:v1": {
                ViewFn<?, T> viewFn = view.getViewFn();
                return viewFn.apply(() -> elements);
            }
            case "beam:side_input:multimap:v1": {
                ViewFn<?, T> viewFn = view.getViewFn();
                Coder keyCoder = ((KvCoder)view.getCoderInternal()).getKeyCoder();
                return viewFn.apply(InMemoryMultimapSideInputView.fromIterable(keyCoder, elements));
            }
        }
        throw new IllegalStateException(String.format("Unknown side input materialization format requested '%s'", view.getViewFn().getMaterialization().getUrn()));
    }

    public <T> Iterable<?> getIterable(PCollectionView<T> view, BoundedWindow window) {
        Coder<?> windowCoder = view.getWindowingStrategyInternal().getWindowFn().windowCoder();
        StateTag<ValueState<Iterable<?>>> stateTag = this.sideInputContentsTags.get(view);
        ValueState<Iterable<?>> state = this.stateInternals.state(StateNamespaces.window(windowCoder, window), stateTag);
        List elements = (List)state.read();
        return elements != null ? elements : Collections.emptyList();
    }

    @Override
    public boolean isReady(PCollectionView<?> sideInput, BoundedWindow window) {
        Set<BoundedWindow> readyWindows = this.stateInternals.state(StateNamespaces.global(), this.availableWindowsTags.get(sideInput)).read();
        return readyWindows != null && readyWindows.contains(window);
    }

    @Override
    public <T> boolean contains(PCollectionView<T> view) {
        return this.sideInputs.contains(view);
    }

    @Override
    public boolean isEmpty() {
        return this.sideInputs.isEmpty();
    }

    private static class WindowSetCombineFn
    extends Combine.CombineFn<BoundedWindow, Set<BoundedWindow>, Set<BoundedWindow>> {
        private WindowSetCombineFn() {
        }

        @Override
        public Set<BoundedWindow> createAccumulator() {
            return new HashSet<BoundedWindow>();
        }

        @Override
        public Set<BoundedWindow> addInput(Set<BoundedWindow> accumulator, BoundedWindow input) {
            accumulator.add(input);
            return accumulator;
        }

        @Override
        public Set<BoundedWindow> mergeAccumulators(Iterable<Set<BoundedWindow>> accumulators) {
            HashSet<BoundedWindow> result = new HashSet<BoundedWindow>();
            for (Set<BoundedWindow> acc : accumulators) {
                result.addAll(acc);
            }
            return result;
        }

        @Override
        public Set<BoundedWindow> extractOutput(Set<BoundedWindow> accumulator) {
            return accumulator;
        }
    }
}

