/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.StateMerging;
import org.apache.beam.repackaged.direct_java.runners.core.StateTag;
import org.apache.beam.repackaged.direct_java.runners.core.StateTags;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.state.CombiningState;
import org.apache.beam.sdk.state.GroupingState;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Min;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;
import org.joda.time.format.PeriodFormatter;

public abstract class AfterDelayFromFirstElementStateMachine
extends TriggerStateMachine {
    protected static final List<SerializableFunction<Instant, Instant>> IDENTITY = ImmutableList.of();
    protected static final StateTag<CombiningState<Instant, Combine.Holder<Instant>, Instant>> DELAYED_UNTIL_TAG = StateTags.makeSystemTagInternal(StateTags.combiningValueFromInputInternal("delayed", InstantCoder.of(), Min.naturalOrder()));
    private static final PeriodFormatter PERIOD_FORMATTER = PeriodFormat.wordBased((Locale)Locale.ENGLISH);
    protected final List<SerializableFunction<Instant, Instant>> timestampMappers;
    protected final TimeDomain timeDomain;

    public abstract @Nullable Instant getCurrentTime(TriggerStateMachine.TriggerContext var1);

    protected abstract AfterDelayFromFirstElementStateMachine newWith(List<SerializableFunction<Instant, Instant>> var1);

    public AfterDelayFromFirstElementStateMachine(TimeDomain timeDomain, List<SerializableFunction<Instant, Instant>> timestampMappers) {
        super(null);
        this.timestampMappers = timestampMappers;
        this.timeDomain = timeDomain;
    }

    private Instant getTargetTimestamp(TriggerStateMachine.OnElementContext c) {
        return this.computeTargetTimestamp(c.currentProcessingTime());
    }

    public TimeDomain getTimeDomain() {
        return this.timeDomain;
    }

    public List<SerializableFunction<Instant, Instant>> getTimestampMappers() {
        return this.timestampMappers;
    }

    public AfterDelayFromFirstElementStateMachine alignedTo(Duration size, Instant offset) {
        return this.newWith(new AlignFn(size, offset));
    }

    public AfterDelayFromFirstElementStateMachine alignedTo(Duration size) {
        return this.alignedTo(size, new Instant(0L));
    }

    public AfterDelayFromFirstElementStateMachine plusDelayOf(Duration delay) {
        return this.newWith(new DelayFn(delay));
    }

    @Override
    public boolean isCompatible(TriggerStateMachine other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AfterDelayFromFirstElementStateMachine that = (AfterDelayFromFirstElementStateMachine)other;
        return this.timestampMappers.equals(that.timestampMappers);
    }

    private AfterDelayFromFirstElementStateMachine newWith(SerializableFunction<Instant, Instant> timestampMapper) {
        return this.newWith((List<SerializableFunction<Instant, Instant>>)ImmutableList.builder().addAll(this.timestampMappers).add(timestampMapper).build());
    }

    @Override
    public void prefetchOnElement(TriggerStateMachine.PrefetchContext c) {
        c.state().access(DELAYED_UNTIL_TAG).readLater();
    }

    @Override
    public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        GroupingState delayUntilState = c.state().access(DELAYED_UNTIL_TAG);
        Instant oldDelayUntil = (Instant)delayUntilState.read();
        if (oldDelayUntil != null) {
            return;
        }
        Instant targetTimestamp = this.getTargetTimestamp(c);
        delayUntilState.add(targetTimestamp);
        c.setTimer(targetTimestamp, this.timeDomain);
    }

    @Override
    public void prefetchOnMerge(TriggerStateMachine.MergingPrefetchContext c) {
        StateMerging.prefetchCombiningValues(c.state(), DELAYED_UNTIL_TAG);
    }

    @Override
    public void onMerge(TriggerStateMachine.OnMergeContext c) throws Exception {
        if (c.trigger().isFinished()) {
            StateMerging.clear(c.state(), DELAYED_UNTIL_TAG);
            return;
        }
        StateMerging.mergeCombiningValues(c.state(), DELAYED_UNTIL_TAG);
        Instant earliestTargetTime = c.state().access(DELAYED_UNTIL_TAG).read();
        if (earliestTargetTime != null) {
            c.setTimer(earliestTargetTime, this.timeDomain);
        }
    }

    @Override
    public void prefetchShouldFire(TriggerStateMachine.PrefetchContext c) {
        c.state().access(DELAYED_UNTIL_TAG).readLater();
    }

    @Override
    public void clear(TriggerStateMachine.TriggerContext c) throws Exception {
        c.state().access(DELAYED_UNTIL_TAG).clear();
    }

    @Override
    public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
        Instant delayedUntil = context.state().access(DELAYED_UNTIL_TAG).read();
        return delayedUntil != null && this.getCurrentTime(context) != null && this.getCurrentTime(context).isAfter((ReadableInstant)delayedUntil);
    }

    @Override
    public final void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
        this.clear(context);
        context.trigger().setFinished(true);
    }

    protected Instant computeTargetTimestamp(Instant time) {
        Instant result = time;
        for (SerializableFunction<Instant, Instant> timestampMapper : this.timestampMappers) {
            result = timestampMapper.apply(result);
        }
        return result;
    }

    static final class AlignFn
    implements SerializableFunction<Instant, Instant> {
        private final Duration size;
        private final Instant offset;

        public AlignFn(Duration size, Instant offset) {
            this.size = size;
            this.offset = offset;
        }

        @Override
        public Instant apply(Instant point) {
            long millisSinceStart = new Duration((ReadableInstant)this.offset, (ReadableInstant)point).getMillis() % this.size.getMillis();
            return millisSinceStart == 0L ? point : point.plus((ReadableDuration)this.size).minus((ReadableDuration)Duration.millis((long)millisSinceStart));
        }

        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AlignFn)) {
                return false;
            }
            AlignFn other = (AlignFn)object;
            return other.size.equals((Object)this.size) && other.offset.equals((Object)this.offset);
        }

        public int hashCode() {
            return Objects.hash(this.size, this.offset);
        }
    }

    static final class DelayFn
    implements SerializableFunction<Instant, Instant> {
        private final Duration delay;

        public DelayFn(Duration delay) {
            this.delay = delay;
        }

        @Override
        public Instant apply(Instant input) {
            return input.plus((ReadableDuration)this.delay);
        }

        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DelayFn)) {
                return false;
            }
            return this.delay.equals((Object)((DelayFn)object).delay);
        }

        public int hashCode() {
            return Objects.hash(this.delay);
        }

        public String toString() {
            return PERIOD_FORMATTER.print((ReadablePeriod)this.delay.toPeriod());
        }
    }
}

