/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItem;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItems;
import org.apache.beam.repackaged.direct_java.runners.core.TimerInternals;
import org.apache.beam.repackaged.direct_java.runners.local.ExecutionDriver;
import org.apache.beam.repackaged.direct_java.runners.local.PipelineMessageReceiver;
import org.apache.beam.runners.direct.AutoValue_QuiescenceDriver_WorkUpdate;
import org.apache.beam.runners.direct.BundleProcessor;
import org.apache.beam.runners.direct.CommittedBundle;
import org.apache.beam.runners.direct.CommittedResult;
import org.apache.beam.runners.direct.CompletionCallback;
import org.apache.beam.runners.direct.DirectGraph;
import org.apache.beam.runners.direct.EvaluationContext;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.runners.direct.WatermarkManager;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuiescenceDriver
implements ExecutionDriver {
    private static final Logger LOG = LoggerFactory.getLogger(QuiescenceDriver.class);
    private final EvaluationContext evaluationContext;
    private final DirectGraph graph;
    private final BundleProcessor<PCollection<?>, CommittedBundle<?>, AppliedPTransform<?, ?, ?>> bundleProcessor;
    private final PipelineMessageReceiver pipelineMessageReceiver;
    private final CompletionCallback defaultCompletionCallback = new TimerIterableCompletionCallback(Collections.emptyList());
    private final Map<AppliedPTransform<?, ?, ?>, Queue<CommittedBundle<?>>> pendingRootBundles;
    private final Queue<WorkUpdate> pendingWork = new ConcurrentLinkedQueue<WorkUpdate>();
    private final Map<AppliedPTransform<?, ?, ?>, Collection<CommittedBundle<?>>> inflightBundles = new ConcurrentHashMap();
    private final AtomicReference<ExecutorState> state = new AtomicReference<ExecutorState>(ExecutorState.QUIESCENT);
    private final AtomicLong outstandingWork = new AtomicLong(0L);
    private boolean exceptionThrown = false;

    public static ExecutionDriver create(EvaluationContext context, DirectGraph graph, BundleProcessor<PCollection<?>, CommittedBundle<?>, AppliedPTransform<?, ?, ?>> bundleProcessor, PipelineMessageReceiver messageReceiver, Map<AppliedPTransform<?, ?, ?>, Queue<CommittedBundle<?>>> initialBundles) {
        return new QuiescenceDriver(context, graph, bundleProcessor, messageReceiver, initialBundles);
    }

    private QuiescenceDriver(EvaluationContext evaluationContext, DirectGraph graph, BundleProcessor<PCollection<?>, CommittedBundle<?>, AppliedPTransform<?, ?, ?>> bundleProcessor, PipelineMessageReceiver pipelineMessageReceiver, Map<AppliedPTransform<?, ?, ?>, Queue<CommittedBundle<?>>> pendingRootBundles) {
        this.evaluationContext = evaluationContext;
        this.graph = graph;
        this.bundleProcessor = bundleProcessor;
        this.pipelineMessageReceiver = pipelineMessageReceiver;
        this.pendingRootBundles = pendingRootBundles;
    }

    @Override
    public ExecutionDriver.DriverState drive() {
        boolean noWorkOutstanding = this.outstandingWork.get() == 0L;
        ExecutorState startingState = this.state.get();
        if (startingState == ExecutorState.ACTIVE) {
            this.state.compareAndSet(ExecutorState.ACTIVE, ExecutorState.PROCESSING);
        } else if (startingState == ExecutorState.PROCESSING && noWorkOutstanding) {
            this.state.compareAndSet(ExecutorState.PROCESSING, ExecutorState.QUIESCING);
        } else if (startingState == ExecutorState.QUIESCING && noWorkOutstanding) {
            this.state.compareAndSet(ExecutorState.QUIESCING, ExecutorState.QUIESCENT);
        }
        this.fireTimers();
        ArrayList<WorkUpdate> updates = new ArrayList<WorkUpdate>();
        WorkUpdate pendingUpdate = this.pendingWork.poll();
        while (pendingUpdate != null) {
            updates.add(pendingUpdate);
            pendingUpdate = this.pendingWork.poll();
        }
        for (WorkUpdate update : updates) {
            this.applyUpdate(noWorkOutstanding, startingState, update);
        }
        this.addWorkIfNecessary();
        if (this.exceptionThrown) {
            return ExecutionDriver.DriverState.FAILED;
        }
        if (this.evaluationContext.isDone()) {
            return ExecutionDriver.DriverState.SHUTDOWN;
        }
        return ExecutionDriver.DriverState.CONTINUE;
    }

    private void applyUpdate(boolean noWorkOutstanding, ExecutorState startingState, WorkUpdate update) {
        LOG.debug("Executor Update: {}", (Object)update);
        if (update.getBundle().isPresent()) {
            if (ExecutorState.ACTIVE == startingState || ExecutorState.PROCESSING == startingState && noWorkOutstanding) {
                CommittedBundle<?> bundle = update.getBundle().get();
                for (AppliedPTransform<?, ?, ?> consumer : update.getConsumers()) {
                    this.processBundle(bundle, consumer);
                }
            } else {
                this.pendingWork.offer(update);
            }
        } else if (update.getException().isPresent()) {
            this.pipelineMessageReceiver.failed(update.getException().get());
            this.exceptionThrown = true;
        }
    }

    private void processBundle(CommittedBundle<?> bundle, AppliedPTransform<?, ?, ?> consumer) {
        this.processBundle(bundle, consumer, this.defaultCompletionCallback);
    }

    private void processBundle(CommittedBundle<?> bundle, AppliedPTransform<?, ?, ?> consumer, CompletionCallback callback) {
        this.inflightBundles.compute(consumer, (k, v) -> {
            if (v == null) {
                v = new ArrayList<CommittedBundle>();
            }
            v.add(bundle);
            return v;
        });
        this.outstandingWork.incrementAndGet();
        this.bundleProcessor.process(bundle, consumer, callback);
    }

    private void fireTimers() {
        try {
            for (WatermarkManager.FiredTimers<AppliedPTransform<?, ?, ?>> transformTimers : this.evaluationContext.extractFiredTimers(this.inflightBundles.keySet())) {
                Collection<TimerInternals.TimerData> delivery = transformTimers.getTimers();
                KeyedWorkItem work = KeyedWorkItems.timersWorkItem(transformTimers.getKey().getKey(), delivery);
                CommittedBundle bundle = this.evaluationContext.createKeyedBundle(transformTimers.getKey(), (PCollection)Iterables.getOnlyElement(transformTimers.getExecutable().getMainInputs().values())).add(WindowedValue.valueInGlobalWindow(work)).commit(this.evaluationContext.now());
                this.processBundle(bundle, transformTimers.getExecutable(), new TimerIterableCompletionCallback(delivery));
                this.state.set(ExecutorState.ACTIVE);
            }
        }
        catch (Exception e) {
            LOG.error("Internal Error while delivering timers", (Throwable)e);
            this.pipelineMessageReceiver.failed(e);
            this.exceptionThrown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkIfNecessary() {
        if (this.state.get() == ExecutorState.QUIESCENT) {
            Map<AppliedPTransform<?, ?, ?>, Queue<CommittedBundle<?>>> map = this.pendingRootBundles;
            synchronized (map) {
                for (Map.Entry<AppliedPTransform<?, ?, ?>, Queue<CommittedBundle<?>>> pendingRootEntry : this.pendingRootBundles.entrySet()) {
                    ArrayList bundles = new ArrayList();
                    while (!pendingRootEntry.getValue().isEmpty()) {
                        CommittedBundle<?> bundle = pendingRootEntry.getValue().poll();
                        bundles.add(bundle);
                    }
                    for (CommittedBundle committedBundle : bundles) {
                        this.processBundle(committedBundle, pendingRootEntry.getKey());
                        this.state.set(ExecutorState.ACTIVE);
                    }
                }
            }
        }
    }

    @AutoValue
    static abstract class WorkUpdate {
        WorkUpdate() {
        }

        private static WorkUpdate fromBundle(CommittedBundle<?> bundle, Collection<AppliedPTransform<?, ?, ?>> consumers) {
            return new AutoValue_QuiescenceDriver_WorkUpdate(Optional.of(bundle), consumers, Optional.empty());
        }

        private static WorkUpdate fromException(Exception e) {
            return new AutoValue_QuiescenceDriver_WorkUpdate(Optional.empty(), Collections.emptyList(), Optional.of(e));
        }

        public abstract Optional<? extends CommittedBundle<?>> getBundle();

        public abstract Collection<AppliedPTransform<?, ?, ?>> getConsumers();

        public abstract Optional<? extends Exception> getException();
    }

    private class TimerIterableCompletionCallback
    implements CompletionCallback {
        private final Iterable<TimerInternals.TimerData> timers;

        TimerIterableCompletionCallback(Iterable<TimerInternals.TimerData> timers) {
            this.timers = timers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final CommittedResult handleResult(CommittedBundle<?> inputBundle, TransformResult<?> result) {
            CommittedResult<AppliedPTransform<?, ?, ?>> committedResult = QuiescenceDriver.this.evaluationContext.handleResult(inputBundle, this.timers, result);
            for (CommittedBundle<?> outputBundle : committedResult.getOutputs()) {
                QuiescenceDriver.this.pendingWork.offer(WorkUpdate.fromBundle(outputBundle, QuiescenceDriver.this.graph.getPerElementConsumers((PValue)outputBundle.getPCollection())));
            }
            Optional<CommittedBundle<?>> unprocessedInputs = committedResult.getUnprocessedInputs();
            if (unprocessedInputs.isPresent()) {
                if (inputBundle.getPCollection() == null) {
                    Map map = QuiescenceDriver.this.pendingRootBundles;
                    synchronized (map) {
                        ((Queue)QuiescenceDriver.this.pendingRootBundles.get(result.getTransform())).offer(unprocessedInputs.get());
                    }
                } else {
                    QuiescenceDriver.this.pendingWork.offer(WorkUpdate.fromBundle(unprocessedInputs.get(), Collections.singleton(committedResult.getExecutable())));
                }
            }
            if (!committedResult.getProducedOutputTypes().isEmpty()) {
                QuiescenceDriver.this.state.set(ExecutorState.ACTIVE);
            }
            QuiescenceDriver.this.outstandingWork.decrementAndGet();
            QuiescenceDriver.this.inflightBundles.compute(result.getTransform(), (k, v) -> {
                v.remove(inputBundle);
                return v.isEmpty() ? null : v;
            });
            return committedResult;
        }

        @Override
        public void handleEmpty(AppliedPTransform<?, ?, ?> transform) {
            QuiescenceDriver.this.outstandingWork.decrementAndGet();
        }

        @Override
        public final void handleException(CommittedBundle<?> inputBundle, Exception e) {
            QuiescenceDriver.this.pendingWork.offer(WorkUpdate.fromException(e));
            QuiescenceDriver.this.outstandingWork.decrementAndGet();
        }

        @Override
        public void handleError(Error err) {
            QuiescenceDriver.this.pipelineMessageReceiver.failed(err);
        }
    }

    private static enum ExecutorState {
        ACTIVE,
        PROCESSING,
        QUIESCING,
        QUIESCENT;

    }
}

