/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.storage;

import java.io.IOException;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.storage.PathValidator;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class GcsPathValidator
implements PathValidator {
    private GcsOptions gcpOptions;

    private GcsPathValidator(GcsOptions options) {
        this.gcpOptions = options;
    }

    public static GcsPathValidator fromOptions(PipelineOptions options) {
        return new GcsPathValidator((GcsOptions)options.as(GcsOptions.class));
    }

    @Override
    public void validateInputFilePatternSupported(String filepattern) {
        this.getGcsPath(filepattern);
        this.verifyPath(filepattern);
        this.verifyPathIsAccessible(filepattern, "Could not find file %s");
    }

    @Override
    public void validateOutputFilePrefixSupported(String filePrefix) {
        this.verifyPath(filePrefix);
        this.verifyPathIsAccessible(filePrefix, "Output path does not exist or is not writeable: %s");
    }

    @Override
    public void validateOutputResourceSupported(ResourceId resourceId) {
        Preconditions.checkArgument((boolean)"gs".equals(resourceId.getScheme()), (String)"Expected a valid 'gs://' path but was given: '%s'", (Object)resourceId);
        this.verifyPath(resourceId.toString());
    }

    @Override
    public String verifyPath(String path) {
        GcsPath gcsPath = this.getGcsPath(path);
        Preconditions.checkArgument((boolean)gcsPath.isAbsolute(), (Object)"Must provide absolute paths for Dataflow");
        Preconditions.checkArgument((!gcsPath.getObject().isEmpty() ? 1 : 0) != 0, (String)"Missing object or bucket in path: '%s', did you mean: 'gs://some-bucket/%s'?", (Object)gcsPath, (Object)gcsPath.getBucket());
        Preconditions.checkArgument((!gcsPath.getObject().contains("//") ? 1 : 0) != 0, (Object)"Dataflow Service does not allow objects with consecutive slashes");
        return gcsPath.toResourceName();
    }

    private void verifyPathIsAccessible(String path, String errorMessage) {
        GcsPath gcsPath = this.getGcsPath(path);
        try {
            Preconditions.checkArgument((boolean)this.gcpOptions.getGcsUtil().bucketAccessible(gcsPath), (String)errorMessage, (Object)path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to verify that GCS bucket gs://%s exists.", gcsPath.getBucket()), e);
        }
    }

    private GcsPath getGcsPath(String path) {
        try {
            return GcsPath.fromUri(path);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Expected a valid 'gs://' path but was given '%s'", path), e);
        }
    }
}

