/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fuzzymatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.fuzzymatch.FuzzyMatchMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FuzzyMatchDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = FuzzyMatchMeta.class;
    private CCombo wTransform;
    private CCombo wAlgorithm;
    private ComboVar wMainStreamField;
    private ComboVar wLookupField;
    private ColumnInfo[] ciReturn;
    private Label wlReturn;
    private TableView wReturn;
    private TextVar wMatchField;
    private Label wlValueField;
    private TextVar wValueField;
    private Label wlCaseSensitive;
    private Button wCaseSensitive;
    private Label wlGetCloserValue;
    private Button wGetCloserValue;
    private Label wlMinValue;
    private TextVar wMinValue;
    private Label wlMaxValue;
    private TextVar wMaxValue;
    private Label wlSeparator;
    private TextVar wSeparator;
    private Button wGetLU;
    private final FuzzyMatchMeta input;
    private boolean gotPreviousFields = false;
    private boolean gotLookupFields = false;

    public FuzzyMatchDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (FuzzyMatchMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyMatchDialog.this.input.setChanged();
                FuzzyMatchDialog.this.setComboBoxesLookup();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.General.Tab", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wLookupGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wLookupGroup);
        wLookupGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.Lookup.Label", (String[])new String[0]));
        FormLayout lookupgroupLayout = new FormLayout();
        lookupgroupLayout.marginWidth = 10;
        lookupgroupLayout.marginHeight = 10;
        wLookupGroup.setLayout((Layout)lookupgroupLayout);
        Label wlTransform = new Label((Composite)wLookupGroup, 131072);
        wlTransform.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.SourceTransform.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTransform);
        FormData fdlTransform = new FormData();
        fdlTransform.left = new FormAttachment(0, 0);
        fdlTransform.right = new FormAttachment(middle, -margin);
        fdlTransform.top = new FormAttachment((Control)this.wTransformName, margin);
        wlTransform.setLayoutData((Object)fdlTransform);
        this.wTransform = new CCombo((Composite)wLookupGroup, 18436);
        this.props.setLook((Control)this.wTransform);
        List transforms = this.pipelineMeta.findPreviousTransforms(this.pipelineMeta.findTransform(this.transformName), true);
        for (TransformMeta transformMeta : transforms) {
            this.wTransform.add(transformMeta.getName());
        }
        this.wTransform.addModifyListener(lsMod);
        this.wTransform.addSelectionListener((SelectionListener)lsSelection);
        FormData fdTransform = new FormData();
        fdTransform.left = new FormAttachment(middle, 0);
        fdTransform.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTransform.right = new FormAttachment(100, 0);
        this.wTransform.setLayoutData((Object)fdTransform);
        Label wlLookupField = new Label((Composite)wLookupGroup, 131072);
        wlLookupField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.wlLookupField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLookupField);
        FormData fdlLookupField = new FormData();
        fdlLookupField.left = new FormAttachment(0, 0);
        fdlLookupField.top = new FormAttachment((Control)this.wTransform, margin);
        fdlLookupField.right = new FormAttachment(middle, -2 * margin);
        wlLookupField.setLayoutData((Object)fdlLookupField);
        this.wLookupField = new ComboVar(this.variables, (Composite)wLookupGroup, 2056);
        this.wLookupField.setEditable(true);
        this.props.setLook((Control)this.wLookupField);
        this.wLookupField.addModifyListener(lsMod);
        FormData fdLookupField = new FormData();
        fdLookupField.left = new FormAttachment(middle, 0);
        fdLookupField.top = new FormAttachment((Control)this.wTransform, margin);
        fdLookupField.right = new FormAttachment(100, -margin);
        this.wLookupField.setLayoutData((Object)fdLookupField);
        this.wLookupField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                FuzzyMatchDialog.this.setLookupField();
            }
        });
        FormData fdLookupGroup = new FormData();
        fdLookupGroup.left = new FormAttachment(0, margin);
        fdLookupGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdLookupGroup.right = new FormAttachment(100, -margin);
        wLookupGroup.setLayoutData((Object)fdLookupGroup);
        Group wMainStreamGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wMainStreamGroup);
        wMainStreamGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.MainStreamGroup.Label", (String[])new String[0]));
        FormLayout mainStreamgroupLayout = new FormLayout();
        mainStreamgroupLayout.marginWidth = 10;
        mainStreamgroupLayout.marginHeight = 10;
        wMainStreamGroup.setLayout((Layout)mainStreamgroupLayout);
        Label wlMainStreamField = new Label((Composite)wMainStreamGroup, 131072);
        wlMainStreamField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.wlMainStreamField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMainStreamField);
        FormData fdlMainStreamField = new FormData();
        fdlMainStreamField.left = new FormAttachment(0, 0);
        fdlMainStreamField.top = new FormAttachment((Control)wLookupGroup, margin);
        fdlMainStreamField.right = new FormAttachment(middle, -2 * margin);
        wlMainStreamField.setLayoutData((Object)fdlMainStreamField);
        this.wMainStreamField = new ComboVar(this.variables, (Composite)wMainStreamGroup, 2056);
        this.wMainStreamField.setEditable(true);
        this.props.setLook((Control)this.wMainStreamField);
        this.wMainStreamField.addModifyListener(lsMod);
        FormData fdMainStreamField = new FormData();
        fdMainStreamField.left = new FormAttachment(middle, 0);
        fdMainStreamField.top = new FormAttachment((Control)wLookupGroup, margin);
        fdMainStreamField.right = new FormAttachment(100, -margin);
        this.wMainStreamField.setLayoutData((Object)fdMainStreamField);
        this.wMainStreamField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                FuzzyMatchDialog.this.setMainStreamField();
            }
        });
        FormData fdMainStreamGroup = new FormData();
        fdMainStreamGroup.left = new FormAttachment(0, margin);
        fdMainStreamGroup.top = new FormAttachment((Control)wLookupGroup, margin);
        fdMainStreamGroup.right = new FormAttachment(100, -margin);
        wMainStreamGroup.setLayoutData((Object)fdMainStreamGroup);
        Group wSettingsGroup = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.SettingsGroup.Label", (String[])new String[0]));
        FormLayout settingsgroupLayout = new FormLayout();
        settingsgroupLayout.marginWidth = 10;
        settingsgroupLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingsgroupLayout);
        Label wlAlgorithm = new Label((Composite)wSettingsGroup, 131072);
        wlAlgorithm.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Algorithm.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAlgorithm);
        FormData fdlAlgorithm = new FormData();
        fdlAlgorithm.left = new FormAttachment(0, 0);
        fdlAlgorithm.right = new FormAttachment(middle, -margin);
        fdlAlgorithm.top = new FormAttachment((Control)wMainStreamGroup, margin);
        wlAlgorithm.setLayoutData((Object)fdlAlgorithm);
        this.wAlgorithm = new CCombo((Composite)wSettingsGroup, 2056);
        this.props.setLook((Control)this.wAlgorithm);
        this.wAlgorithm.addModifyListener(lsMod);
        FormData fdAlgorithm = new FormData();
        fdAlgorithm.left = new FormAttachment(middle, 0);
        fdAlgorithm.top = new FormAttachment((Control)wMainStreamGroup, margin);
        fdAlgorithm.right = new FormAttachment(100, -margin);
        this.wAlgorithm.setLayoutData((Object)fdAlgorithm);
        this.wAlgorithm.setItems(FuzzyMatchMeta.algorithmDesc);
        this.wAlgorithm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyMatchDialog.this.activeAlgorithm();
            }
        });
        this.wlCaseSensitive = new Label((Composite)wSettingsGroup, 131072);
        this.wlCaseSensitive.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.caseSensitive.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCaseSensitive);
        FormData fdlcaseSensitive = new FormData();
        fdlcaseSensitive.left = new FormAttachment(0, 0);
        fdlcaseSensitive.top = new FormAttachment((Control)this.wAlgorithm, margin);
        fdlcaseSensitive.right = new FormAttachment(middle, -2 * margin);
        this.wlCaseSensitive.setLayoutData((Object)fdlcaseSensitive);
        this.wCaseSensitive = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wCaseSensitive);
        this.wCaseSensitive.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.caseSensitive.Tooltip", (String[])new String[0]));
        FormData fdcaseSensitive = new FormData();
        fdcaseSensitive.left = new FormAttachment(middle, 0);
        fdcaseSensitive.top = new FormAttachment((Control)this.wlCaseSensitive, 0, 0x1000000);
        this.wCaseSensitive.setLayoutData((Object)fdcaseSensitive);
        SelectionAdapter lcaseSensitive = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FuzzyMatchDialog.this.input.setChanged();
            }
        };
        this.wCaseSensitive.addSelectionListener((SelectionListener)lcaseSensitive);
        this.wlGetCloserValue = new Label((Composite)wSettingsGroup, 131072);
        this.wlGetCloserValue.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.getCloserValue.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGetCloserValue);
        FormData fdlgetCloserValue = new FormData();
        fdlgetCloserValue.left = new FormAttachment(0, 0);
        fdlgetCloserValue.top = new FormAttachment((Control)this.wCaseSensitive, margin);
        fdlgetCloserValue.right = new FormAttachment(middle, -2 * margin);
        this.wlGetCloserValue.setLayoutData((Object)fdlgetCloserValue);
        this.wGetCloserValue = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wGetCloserValue);
        this.wGetCloserValue.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.getCloserValue.Tooltip", (String[])new String[0]));
        FormData fdgetCloserValue = new FormData();
        fdgetCloserValue.left = new FormAttachment(middle, 0);
        fdgetCloserValue.top = new FormAttachment((Control)this.wlGetCloserValue, 0, 0x1000000);
        this.wGetCloserValue.setLayoutData((Object)fdgetCloserValue);
        SelectionAdapter lgetCloserValue = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FuzzyMatchDialog.this.activegetCloserValue();
                FuzzyMatchDialog.this.input.setChanged();
            }
        };
        this.wGetCloserValue.addSelectionListener((SelectionListener)lgetCloserValue);
        this.wlMinValue = new Label((Composite)wSettingsGroup, 131072);
        this.wlMinValue.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.minValue.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMinValue);
        FormData fdlminValue = new FormData();
        fdlminValue.left = new FormAttachment(0, 0);
        fdlminValue.top = new FormAttachment((Control)this.wGetCloserValue, margin);
        fdlminValue.right = new FormAttachment(middle, -margin);
        this.wlMinValue.setLayoutData((Object)fdlminValue);
        this.wMinValue = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        this.props.setLook((Control)this.wMinValue);
        this.wMinValue.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.minValue.Tooltip", (String[])new String[0]));
        this.wMinValue.addModifyListener(lsMod);
        FormData fdminValue = new FormData();
        fdminValue.left = new FormAttachment(middle, 0);
        fdminValue.top = new FormAttachment((Control)this.wGetCloserValue, margin);
        fdminValue.right = new FormAttachment(100, 0);
        this.wMinValue.setLayoutData((Object)fdminValue);
        this.wlMaxValue = new Label((Composite)wSettingsGroup, 131072);
        this.wlMaxValue.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.maxValue.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMaxValue);
        FormData fdlmaxValue = new FormData();
        fdlmaxValue.left = new FormAttachment(0, 0);
        fdlmaxValue.top = new FormAttachment((Control)this.wMinValue, margin);
        fdlmaxValue.right = new FormAttachment(middle, -margin);
        this.wlMaxValue.setLayoutData((Object)fdlmaxValue);
        this.wMaxValue = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        this.props.setLook((Control)this.wMaxValue);
        this.wMaxValue.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.maxValue.Tooltip", (String[])new String[0]));
        this.wMaxValue.addModifyListener(lsMod);
        FormData fdmaxValue = new FormData();
        fdmaxValue.left = new FormAttachment(middle, 0);
        fdmaxValue.top = new FormAttachment((Control)this.wMinValue, margin);
        fdmaxValue.right = new FormAttachment(100, 0);
        this.wMaxValue.setLayoutData((Object)fdmaxValue);
        this.wlSeparator = new Label((Composite)wSettingsGroup, 131072);
        this.wlSeparator.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.separator.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSeparator);
        FormData fdlseparator = new FormData();
        fdlseparator.left = new FormAttachment(0, 0);
        fdlseparator.top = new FormAttachment((Control)this.wMaxValue, margin);
        fdlseparator.right = new FormAttachment(middle, -margin);
        this.wlSeparator.setLayoutData((Object)fdlseparator);
        this.wSeparator = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        this.props.setLook((Control)this.wSeparator);
        this.wSeparator.addModifyListener(lsMod);
        FormData fdseparator = new FormData();
        fdseparator.left = new FormAttachment(middle, 0);
        fdseparator.top = new FormAttachment((Control)this.wMaxValue, margin);
        fdseparator.right = new FormAttachment(100, 0);
        this.wSeparator.setLayoutData((Object)fdseparator);
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)wMainStreamGroup, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Fields.Tab", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        Group wOutputFieldsGroup = new Group(wFieldsComp, 32);
        this.props.setLook((Control)wOutputFieldsGroup);
        wOutputFieldsGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.OutputFieldsGroup.Label", (String[])new String[0]));
        FormLayout outputFieldsgroupLayout = new FormLayout();
        outputFieldsgroupLayout.marginWidth = 10;
        outputFieldsgroupLayout.marginHeight = 10;
        wOutputFieldsGroup.setLayout((Layout)outputFieldsgroupLayout);
        Label wlmatchField = new Label((Composite)wOutputFieldsGroup, 131072);
        wlmatchField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.MatchField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlmatchField);
        FormData fdlmatchField = new FormData();
        fdlmatchField.left = new FormAttachment(0, 0);
        fdlmatchField.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdlmatchField.right = new FormAttachment(middle, -margin);
        wlmatchField.setLayoutData((Object)fdlmatchField);
        this.wMatchField = new TextVar(this.variables, (Composite)wOutputFieldsGroup, 18436);
        this.props.setLook((Control)this.wMatchField);
        this.wMatchField.addModifyListener(lsMod);
        FormData fdmatchField = new FormData();
        fdmatchField.left = new FormAttachment(middle, 0);
        fdmatchField.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdmatchField.right = new FormAttachment(100, 0);
        this.wMatchField.setLayoutData((Object)fdmatchField);
        this.wlValueField = new Label((Composite)wOutputFieldsGroup, 131072);
        this.wlValueField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.valueField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlValueField);
        FormData fdlvalueField = new FormData();
        fdlvalueField.left = new FormAttachment(0, 0);
        fdlvalueField.top = new FormAttachment((Control)this.wMatchField, margin);
        fdlvalueField.right = new FormAttachment(middle, -margin);
        this.wlValueField.setLayoutData((Object)fdlvalueField);
        this.wValueField = new TextVar(this.variables, (Composite)wOutputFieldsGroup, 18436);
        this.props.setLook((Control)this.wValueField);
        this.wValueField.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.valueField.Tooltip", (String[])new String[0]));
        this.wValueField.addModifyListener(lsMod);
        FormData fdvalueField = new FormData();
        fdvalueField.left = new FormAttachment(middle, 0);
        fdvalueField.top = new FormAttachment((Control)this.wMatchField, margin);
        fdvalueField.right = new FormAttachment(100, 0);
        this.wValueField.setLayoutData((Object)fdvalueField);
        FormData fdOutputFieldsGroup = new FormData();
        fdOutputFieldsGroup.left = new FormAttachment(0, margin);
        fdOutputFieldsGroup.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdOutputFieldsGroup.right = new FormAttachment(100, -margin);
        wOutputFieldsGroup.setLayoutData((Object)fdOutputFieldsGroup);
        this.wlReturn = new Label(wFieldsComp, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.ReturnFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)wOutputFieldsGroup, margin);
        this.wlReturn.setLayoutData((Object)fdlReturn);
        this.wGetLU = new Button(wFieldsComp, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.GetLookupFields.Button", (String[])new String[0]));
        FormData fdlu = new FormData();
        fdlu.top = new FormAttachment((Control)this.wlReturn, margin);
        fdlu.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)fdlu);
        int upInsCols = 2;
        int upInsRows = this.input.getValue() != null ? this.input.getValue().length : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.ColumnInfo.FieldReturn", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.ColumnInfo.NewName", (String[])new String[0]), 1, false);
        this.wReturn = new TableView(this.variables, wFieldsComp, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)this.wGetLU, -margin);
        fdReturn.bottom = new FormAttachment(100, -3 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGetLU.addListener(13, e -> this.getlookup());
        wTabFolder.setSelection(0);
        this.getData();
        this.setComboBoxesLookup();
        this.activeAlgorithm();
        this.activegetCloserValue();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wAlgorithm.setText(FuzzyMatchMeta.getAlgorithmTypeDesc(this.input.getAlgorithmType()));
        if (this.input.getMainStreamField() != null) {
            this.wMainStreamField.setText(this.input.getMainStreamField());
        }
        if (this.input.getLookupField() != null) {
            this.wLookupField.setText(this.input.getLookupField());
        }
        this.wCaseSensitive.setSelection(this.input.isCaseSensitive());
        this.wGetCloserValue.setSelection(this.input.isGetCloserValue());
        if (this.input.getMinimalValue() != null) {
            this.wMinValue.setText(this.input.getMinimalValue());
        }
        if (this.input.getMaximalValue() != null) {
            this.wMaxValue.setText(this.input.getMaximalValue());
        }
        if (this.input.getOutputMatchField() != null) {
            this.wMatchField.setText(this.input.getOutputMatchField());
        }
        if (this.input.getOutputValueField() != null) {
            this.wValueField.setText(this.input.getOutputValueField());
        }
        if (this.input.getSeparator() != null) {
            this.wSeparator.setText(this.input.getSeparator());
        }
        if (this.input.getValue() != null) {
            for (int i = 0; i < this.input.getValue().length; ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getValue()[i] != null) {
                    item.setText(1, this.input.getValue()[i]);
                }
                if (this.input.getValueName()[i] == null || this.input.getValueName()[i].equals(this.input.getValue()[i])) continue;
                item.setText(2, this.input.getValueName()[i]);
            }
        }
        IStream infoStream = (IStream)this.input.getTransformIOMeta().getInfoStreams().get(0);
        this.wTransform.setText(Const.NVL((String)infoStream.getTransformName(), (String)""));
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setMainStreamField(this.wMainStreamField.getText());
        this.input.setLookupField(this.wLookupField.getText());
        this.input.setAlgorithmType(FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()));
        this.input.setCaseSensitive(this.wCaseSensitive.getSelection());
        this.input.setGetCloserValue(this.wGetCloserValue.getSelection());
        this.input.setMaximalValue(this.wMaxValue.getText());
        this.input.setMinimalValue(this.wMinValue.getText());
        this.input.setOutputMatchField(this.wMatchField.getText());
        this.input.setOutputValueField(this.wValueField.getText());
        this.input.setSeparator(this.wSeparator.getText());
        int nrvalues = this.wReturn.nrNonEmpty();
        this.input.allocate(nrvalues);
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Log.FoundFields", (String[])new String[]{"" + nrvalues}));
        }
        for (int i = 0; i < nrvalues; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            this.input.getValue()[i] = item.getText(1);
            this.input.getValueName()[i] = item.getText(2);
            if (this.input.getValueName()[i] != null && this.input.getValueName()[i].length() != 0) continue;
            this.input.getValueName()[i] = this.input.getValue()[i];
        }
        IStream infoStream = (IStream)this.input.getTransformIOMeta().getInfoStreams().get(0);
        infoStream.setTransformMeta(this.pipelineMeta.findTransform(this.wTransform.getText()));
        if (infoStream.getTransformMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            if (Utils.isEmpty((CharSequence)this.wTransform.getText())) {
                mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.NotTransformSpecified.DialogMessage", (String[])new String[]{this.wTransform.getText()}));
            } else {
                mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.TransformCanNotFound.DialogMessage", (String[])new String[]{this.wTransform.getText()}));
            }
            mb.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.TransformCanNotFound.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void setMainStreamField() {
        if (!this.gotPreviousFields) {
            String field = this.wMainStreamField.getText();
            try {
                this.wMainStreamField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wMainStreamField.setItems(r.getFieldNames());
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            if (field != null) {
                this.wMainStreamField.setText(field);
            }
            this.gotPreviousFields = true;
        }
    }

    private void setLookupField() {
        if (!this.gotLookupFields) {
            String field = this.wLookupField.getText();
            try {
                this.wLookupField.removeAll();
                IRowMeta r = this.pipelineMeta.getTransformFields(this.variables, this.wTransform.getText());
                if (r != null) {
                    this.wLookupField.setItems(r.getFieldNames());
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetLookupFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetLookupFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            if (field != null) {
                this.wLookupField.setText(field);
            }
            this.gotLookupFields = true;
        }
    }

    private void activegetCloserValue() {
        boolean enableRange = (FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 0 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 2 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 1 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 3 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 4 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 5) && !this.wGetCloserValue.getSelection();
        this.wlSeparator.setEnabled(enableRange);
        this.wSeparator.setEnabled(enableRange);
        this.wlValueField.setEnabled(this.wGetCloserValue.getSelection());
        this.wValueField.setEnabled(this.wGetCloserValue.getSelection());
        this.activeAddFields();
    }

    private void activeAddFields() {
        boolean activate = this.wGetCloserValue.getSelection() || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 7 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 8 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 9 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 6;
        this.wlReturn.setEnabled(activate);
        this.wReturn.setEnabled(activate);
        this.wGetLU.setEnabled(activate);
    }

    private void activeAlgorithm() {
        boolean enable = FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 0 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 2 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 1 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 3 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 4 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 5;
        this.wlGetCloserValue.setEnabled(enable);
        this.wGetCloserValue.setEnabled(enable);
        this.wlMinValue.setEnabled(enable);
        this.wMinValue.setEnabled(enable);
        this.wlMaxValue.setEnabled(enable);
        this.wMaxValue.setEnabled(enable);
        if (FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 3 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 4 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 5) {
            if (Const.toDouble((String)this.variables.resolve(this.wMinValue.getText()), (double)0.0) > 1.0) {
                this.wMinValue.setText(String.valueOf(1));
            }
            if (Const.toDouble((String)this.variables.resolve(this.wMaxValue.getText()), (double)0.0) > 1.0) {
                this.wMaxValue.setText(String.valueOf(1));
            }
        }
        boolean enableCaseSensitive = FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 0 || FuzzyMatchMeta.getAlgorithmTypeByDesc(this.wAlgorithm.getText()) == 1;
        this.wlCaseSensitive.setEnabled(enableCaseSensitive);
        this.wCaseSensitive.setEnabled(enableCaseSensitive);
        this.activegetCloserValue();
    }

    private void getlookup() {
        try {
            String transformFrom = this.wTransform.getText();
            if (!Utils.isEmpty((CharSequence)transformFrom)) {
                IRowMeta r = this.pipelineMeta.getTransformFields(this.variables, transformFrom);
                if (r != null && !r.isEmpty()) {
                    BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1}, (int[])new int[]{4}, (int)-1, (int)-1, null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.CouldNotFindFields.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.CouldNotFindFields.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.TransformNameRequired.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.TransformNameRequired.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    protected void setComboBoxesLookup() {
        Runnable fieldLoader = () -> {
            TransformMeta lookupTransformMeta = this.pipelineMeta.findTransform(this.wTransform.getText());
            if (lookupTransformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getTransformFields(this.variables, lookupTransformMeta);
                    HashMap<String, Integer> lookupFields = new HashMap<String, Integer>();
                    for (int i = 0; i < row.size(); ++i) {
                        lookupFields.put(row.getValueMeta(i).getName(), i);
                    }
                    HashMap<String, Integer> fields = new HashMap<String, Integer>();
                    fields.putAll(lookupFields);
                    Set keySet = fields.keySet();
                    ArrayList entries = new ArrayList(keySet);
                    String[] fieldNames = entries.toArray(new String[entries.size()]);
                    Const.sortStrings((String[])fieldNames);
                    this.ciReturn[0].setComboValues(fieldNames);
                }
                catch (HopException e) {
                    this.logError("It was not possible to retrieve the list of fields for transform [" + this.wTransform.getText() + "]!");
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }
}

