/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fuzzymatch;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.Stream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;
import org.apache.hop.pipeline.transforms.fuzzymatch.FuzzyMatch;
import org.apache.hop.pipeline.transforms.fuzzymatch.FuzzyMatchData;
import org.w3c.dom.Node;

@Transform(id="FuzzyMatch", image="fuzzymatch.svg", name="i18n::FuzzyMatch.Name", description="i18n::FuzzyMatch.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", keywords={"i18n::FuzzyMatchMeta.keyword"}, documentationUrl="/pipeline/transforms/fuzzymatch.html")
public class FuzzyMatchMeta
extends BaseTransformMeta<FuzzyMatch, FuzzyMatchData> {
    private static final Class<?> PKG = FuzzyMatchMeta.class;
    public static final String DEFAULT_SEPARATOR = ",";
    private int algorithm;
    public static final String[] algorithmDesc = new String[]{BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.Levenshtein", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.DamerauLevenshtein", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.NeedlemanWunsch", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.Jaro", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.JaroWinkler", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.PairSimilarity", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.Metaphone", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.DoubleMetaphone", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.SoundEx", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.RefinedSoundEx", (String[])new String[0])};
    public static final String[] algorithmCode = new String[]{"levenshtein", "dameraulevenshtein", "needlemanwunsch", "jaro", "jarowinkler", "pairsimilarity", "metaphone", "doublemataphone", "soundex", "refinedsoundex"};
    public static final int OPERATION_TYPE_LEVENSHTEIN = 0;
    public static final int OPERATION_TYPE_DAMERAU_LEVENSHTEIN = 1;
    public static final int OPERATION_TYPE_NEEDLEMAN_WUNSH = 2;
    public static final int OPERATION_TYPE_JARO = 3;
    public static final int OPERATION_TYPE_JARO_WINKLER = 4;
    public static final int OPERATION_TYPE_PAIR_SIMILARITY = 5;
    public static final int OPERATION_TYPE_METAPHONE = 6;
    public static final int OPERATION_TYPE_DOUBLE_METAPHONE = 7;
    public static final int OPERATION_TYPE_SOUNDEX = 8;
    public static final int OPERATION_TYPE_REFINED_SOUNDEX = 9;
    private String lookupfield;
    private String mainstreamfield;
    private String outputmatchfield;
    private String outputvaluefield;
    private boolean caseSensitive;
    private String minimalValue;
    private String maximalValue;
    private String separator;
    private boolean closervalue;
    private String[] value;
    private String[] valueName;

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public void allocate(int nrvalues) {
        this.value = new String[nrvalues];
        this.valueName = new String[nrvalues];
    }

    public Object clone() {
        FuzzyMatchMeta retval = (FuzzyMatchMeta)((Object)super.clone());
        int nrvalues = this.value.length;
        retval.allocate(nrvalues);
        System.arraycopy(this.value, 0, retval.value, 0, nrvalues);
        System.arraycopy(this.valueName, 0, retval.valueName, 0, nrvalues);
        return retval;
    }

    public String getMainStreamField() {
        return this.mainstreamfield;
    }

    public void setMainStreamField(String mainstreamfield) {
        this.mainstreamfield = mainstreamfield;
    }

    public String getLookupField() {
        return this.lookupfield;
    }

    public void setLookupField(String lookupfield) {
        this.lookupfield = lookupfield;
    }

    public String getOutputMatchField() {
        return this.outputmatchfield;
    }

    public void setOutputMatchField(String outputmatchfield) {
        this.outputmatchfield = outputmatchfield;
    }

    public String getOutputValueField() {
        return this.outputvaluefield;
    }

    public void setOutputValueField(String outputvaluefield) {
        this.outputvaluefield = outputvaluefield;
    }

    public boolean isGetCloserValue() {
        return this.closervalue;
    }

    public String[] getValueName() {
        return this.valueName;
    }

    public void setValueName(String[] valueName) {
        this.valueName = valueName;
    }

    public void setGetCloserValue(boolean closervalue) {
        this.closervalue = closervalue;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getMinimalValue() {
        return this.minimalValue;
    }

    public void setMinimalValue(String minimalValue) {
        this.minimalValue = minimalValue;
    }

    public String getMaximalValue() {
        return this.maximalValue;
    }

    public void setMaximalValue(String maximalValue) {
        this.maximalValue = maximalValue;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public int getAlgorithmType() {
        return this.algorithm;
    }

    public void setAlgorithmType(int algorithm) {
        this.algorithm = algorithm;
    }

    public static String getAlgorithmTypeDesc(int i) {
        if (i < 0 || i >= algorithmDesc.length) {
            return algorithmDesc[0];
        }
        return algorithmDesc[i];
    }

    public static int getAlgorithmTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < algorithmDesc.length; ++i) {
            if (!algorithmDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return FuzzyMatchMeta.getAlgorithmTypeByCode(tt);
    }

    private static int getAlgorithmTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < algorithmCode.length; ++i) {
            if (!algorithmCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            String lookupFromTransformName = XmlHandler.getTagValue((Node)transformNode, (String)"from");
            IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromTransformName);
            this.lookupfield = XmlHandler.getTagValue((Node)transformNode, (String)"lookupfield");
            this.mainstreamfield = XmlHandler.getTagValue((Node)transformNode, (String)"mainstreamfield");
            this.caseSensitive = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"caseSensitive"));
            this.closervalue = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"closervalue"));
            this.minimalValue = XmlHandler.getTagValue((Node)transformNode, (String)"minimalValue");
            this.maximalValue = XmlHandler.getTagValue((Node)transformNode, (String)"maximalValue");
            this.separator = XmlHandler.getTagValue((Node)transformNode, (String)"separator");
            this.outputmatchfield = XmlHandler.getTagValue((Node)transformNode, (String)"outputmatchfield");
            this.outputvaluefield = XmlHandler.getTagValue((Node)transformNode, (String)"outputvaluefield");
            this.algorithm = FuzzyMatchMeta.getAlgorithmTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"algorithm"), (String)""));
            Node lookup = XmlHandler.getSubNode((Node)transformNode, (String)"lookup");
            int nrvalues = XmlHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                Node vnode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.value[i] = XmlHandler.getTagValue((Node)vnode, (String)"name");
                this.valueName[i] = XmlHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.valueName[i] != null) continue;
                this.valueName[i] = this.value[i];
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    private static String getAlgorithmTypeCode(int i) {
        if (i < 0 || i >= algorithmCode.length) {
            return algorithmCode[0];
        }
        return algorithmCode[i];
    }

    public void setDefault() {
        this.value = null;
        this.valueName = null;
        this.separator = DEFAULT_SEPARATOR;
        this.closervalue = true;
        this.minimalValue = "0";
        this.maximalValue = "1";
        this.caseSensitive = false;
        this.lookupfield = null;
        this.mainstreamfield = null;
        this.outputmatchfield = BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.OutputMatchFieldname", (String[])new String[0]);
        this.outputvaluefield = BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.OutputValueFieldname", (String[])new String[0]);
        int nrvalues = 0;
        this.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            this.value[i] = "value" + i;
            this.valueName[i] = "valuename" + i;
        }
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        block10: {
            boolean activateAdditionalFields;
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getOutputMatchField()));
            v.setOrigin(name);
            v.setStorageType(0);
            inputRowMeta.addValueMeta((IValueMeta)v);
            String mainField = variables.resolve(this.getOutputValueField());
            if (!Utils.isEmpty((CharSequence)mainField) && this.isGetCloserValue()) {
                switch (this.getAlgorithmType()) {
                    case 0: 
                    case 1: {
                        v = new ValueMetaInteger(mainField);
                        v.setLength(10);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        v = new ValueMetaNumber(mainField);
                        break;
                    }
                    default: {
                        v = new ValueMetaString(mainField);
                    }
                }
                v.setStorageType(0);
                v.setOrigin(name);
                inputRowMeta.addValueMeta((IValueMeta)v);
            }
            boolean bl = activateAdditionalFields = this.isGetCloserValue() || this.getAlgorithmType() == 7 || this.getAlgorithmType() == 8 || this.getAlgorithmType() == 9 || this.getAlgorithmType() == 6;
            if (!activateAdditionalFields) break block10;
            if (info != null && info.length == 1 && info[0] != null) {
                for (int i = 0; i < this.valueName.length; ++i) {
                    v = info[0].searchValueMeta(this.value[i]);
                    if (v == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.Exception.ReturnValueCanNotBeFound", (String[])new String[]{this.value[i]}));
                    }
                    v.setName(this.valueName[i]);
                    v.setOrigin(name);
                    v.setStorageType(0);
                    inputRowMeta.addValueMeta((IValueMeta)v);
                }
            } else {
                for (int i = 0; i < this.valueName.length; ++i) {
                    v = new ValueMetaString(this.valueName[i]);
                    v.setOrigin(name);
                    inputRowMeta.addValueMeta((IValueMeta)v);
                }
            }
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
        retval.append("    " + XmlHandler.addTagValue((String)"from", (String)infoStream.getTransformName()));
        retval.append("    " + XmlHandler.addTagValue((String)"lookupfield", (String)this.lookupfield));
        retval.append("    " + XmlHandler.addTagValue((String)"mainstreamfield", (String)this.mainstreamfield));
        retval.append("    " + XmlHandler.addTagValue((String)"outputmatchfield", (String)this.outputmatchfield));
        retval.append("    " + XmlHandler.addTagValue((String)"outputvaluefield", (String)this.outputvaluefield));
        retval.append("    " + XmlHandler.addTagValue((String)"caseSensitive", (boolean)this.caseSensitive));
        retval.append("    " + XmlHandler.addTagValue((String)"closervalue", (boolean)this.closervalue));
        retval.append("    " + XmlHandler.addTagValue((String)"minimalValue", (String)this.minimalValue));
        retval.append("    " + XmlHandler.addTagValue((String)"maximalValue", (String)this.maximalValue));
        retval.append("    " + XmlHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"algorithm", (String)FuzzyMatchMeta.getAlgorithmTypeCode(this.algorithm)));
        retval.append("    <lookup>" + Const.CR);
        for (int i = 0; i < this.value.length; ++i) {
            retval.append("      <value>" + Const.CR);
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.value[i]));
            retval.append("        " + XmlHandler.addTagValue((String)"rename", (String)this.valueName[i]));
            retval.append("      </value>" + Const.CR);
        }
        retval.append("    </lookup>" + Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int idx;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.TransformReceivingFields", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String mainField = variables.resolve(this.getMainStreamField());
            idx = prev.indexOfValue(mainField);
            cr = idx < 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.MainFieldNotFound", (String[])new String[]{mainField}), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.MainFieldFound", (String[])new String[]{mainField}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.CouldNotFindFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (info != null && info.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.TransformReceivingLookupData", (String[])new String[]{"" + info.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String lookupField = variables.resolve(this.getLookupField());
            idx = info.indexOfValue(lookupField);
            cr = idx < 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldNotFoundInLookupStream", (String[])new String[]{lookupField}), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldFoundInTheLookupStream", (String[])new String[]{lookupField}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.value.length; ++i) {
                idx = info.indexOfValue(this.value[i]);
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.value[i] + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldsNotFoundInLookupStream2", (String[])new String[0]) + Const.CR + Const.CR + (String)errorMessage;
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.AllFieldsFoundInTheLookupStream2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            }
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldsNotFoundFromInLookupSep", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        IStream infoStream = (IStream)this.getTransformIOMeta().getInfoStreams().get(0);
        if (infoStream.getTransformMeta() == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceTransformNotSelected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceTransformIsSelected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            if (info != null) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceTransformExist", (String[])new String[]{infoStream.getTransformName()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceTransformDoesNotExist", (String[])new String[]{infoStream.getTransformName()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length >= 2) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.TransformReceivingInfoFromInputTransforms", (String[])new String[]{"" + input.length}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.NeedAtLeast2InputStreams", (String[])new String[]{Const.CR, Const.CR}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        List infoStreams = this.getTransformIOMeta().getInfoStreams();
        for (IStream stream : infoStreams) {
            stream.setTransformMeta(TransformMeta.findTransform(transforms, (String)stream.getSubject()));
        }
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public ITransformIOMeta getTransformIOMeta() {
        ITransformIOMeta ioMeta = super.getTransformIOMeta(false);
        if (ioMeta == null) {
            ioMeta = new TransformIOMeta(true, true, false, false, false, false);
            Stream stream = new Stream(IStream.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null);
            ioMeta.addStream((IStream)stream);
            this.setTransformIOMeta(ioMeta);
        }
        return ioMeta;
    }

    public void resetTransformIoMeta() {
    }
}

