/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.concatfields;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFields;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFieldsData;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileField;
import org.w3c.dom.Node;

@Transform(id="ConcatFields", image="concatfields.svg", name="i18n::ConcatFields.Name", description="i18n::ConcatFields.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::ConcatFieldsMeta.keyword"}, documentationUrl="/pipeline/transforms/concatfields.html")
public class ConcatFieldsMeta
extends BaseTransformMeta<ConcatFields, ConcatFieldsData> {
    private static final Class<?> PKG = ConcatFieldsMeta.class;
    @Injection(name="SEPARATOR")
    private String separator;
    @Injection(name="ENCLOSURE")
    private String enclosure;
    @Injection(name="FORCE_ENCLOSURE")
    private boolean enclosureForced;
    @Injection(name="DISABLE_ENCLOSURE_FIX")
    private boolean disableEnclosureFix;
    private String fileFormat;
    @Injection(name="SPECIFY_DATE_FORMAT")
    private boolean specifyingFormat;
    @Injection(name="DATE_FORMAT")
    private String dateTimeFormat;
    @Injection(name="RIGHT_PAD_FIELDS")
    private boolean padded;
    @InjectionDeep
    private TextFileField[] outputFields;
    @Injection(name="ENCODING")
    private String encoding;
    private static final String ConcatFieldsNodeNameSpace = "ConcatFields";
    private String targetFieldName;
    private int targetFieldLength;
    private boolean removeSelectedFields;

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public void setTargetFieldName(String targetField) {
        this.targetFieldName = targetField;
    }

    public int getTargetFieldLength() {
        return this.targetFieldLength;
    }

    public void setTargetFieldLength(int targetFieldLength) {
        this.targetFieldLength = targetFieldLength;
    }

    public boolean isRemoveSelectedFields() {
        return this.removeSelectedFields;
    }

    public void setRemoveSelectedFields(boolean removeSelectedFields) {
        this.removeSelectedFields = removeSelectedFields;
    }

    public void setDefault() {
        this.separator = ";";
        this.enclosure = "\"";
        this.setSpecifyingFormat(false);
        this.setDateTimeFormat(null);
        this.enclosureForced = false;
        this.disableEnclosureFix = false;
        this.padded = false;
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.outputFields[i] = new TextFileField();
            this.outputFields[i].setName("field" + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
            this.outputFields[i].setCurrencySymbol("");
            this.outputFields[i].setDecimalSymbol(",");
            this.outputFields[i].setGroupingSymbol(".");
            this.outputFields[i].setNullString("");
            this.outputFields[i].setLength(-1);
            this.outputFields[i].setPrecision(-1);
        }
        this.targetFieldName = "";
        this.targetFieldLength = 0;
        this.removeSelectedFields = false;
    }

    public void getFieldsModifyInput(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        super.getFields(row, name, info, nextTransform, variables, metadataProvider);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.removeSelectedFields) {
            if (this.getOutputFields().length > 0) {
                for (int i = 0; i < this.getOutputFields().length; ++i) {
                    TextFileField field = this.getOutputFields()[i];
                    try {
                        row.removeValueMeta(field.getName());
                        continue;
                    }
                    catch (HopValueException hopValueException) {
                        // empty catch block
                    }
                }
            } else {
                row.clear();
            }
        }
        if (StringUtil.isEmpty((String)this.targetFieldName)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.TargetFieldNameMissing", (String[])new String[0]));
        }
        ValueMetaString vValue = new ValueMetaString(this.targetFieldName, this.targetFieldLength, 0);
        vValue.setOrigin(name);
        if (!StringUtil.isEmpty((String)this.getEncoding())) {
            vValue.setStringEncoding(this.getEncoding());
        }
        row.addValueMeta((IValueMeta)vValue);
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        this.separator = XmlHandler.getTagValue((Node)transformNode, (String)"separator");
        if (this.separator == null) {
            this.separator = "";
        }
        this.enclosure = XmlHandler.getTagValue((Node)transformNode, (String)"enclosure");
        if (this.enclosure == null) {
            this.enclosure = "";
        }
        this.enclosureForced = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"enclosure_forced"));
        this.targetFieldName = XmlHandler.getTagValue((Node)transformNode, (String)ConcatFieldsNodeNameSpace, (String)"targetFieldName");
        this.targetFieldLength = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)ConcatFieldsNodeNameSpace, (String)"targetFieldLength"), (int)0);
        this.removeSelectedFields = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)ConcatFieldsNodeNameSpace, (String)"removeSelectedFields"));
        Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
        int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
            this.outputFields[i] = new TextFileField();
            this.outputFields[i].setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
            this.outputFields[i].setType(XmlHandler.getTagValue((Node)fnode, (String)"type"));
            this.outputFields[i].setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
            this.outputFields[i].setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
            this.outputFields[i].setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
            this.outputFields[i].setGroupingSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
            this.outputFields[i].setTrimType(ValueMetaBase.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
            this.outputFields[i].setNullString(XmlHandler.getTagValue((Node)fnode, (String)"nullif"));
            this.outputFields[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
            this.outputFields[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(800);
        retval.append("    ").append(XmlHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure_forced", (boolean)this.enclosureForced));
        retval.append("    ").append(XmlHandler.addTagValue((String)"enclosure_fix_disabled", (boolean)this.disableEnclosureFix));
        retval.append("    ").append(XmlHandler.addTagValue((String)"format", (String)this.fileFormat));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            TextFileField field = this.outputFields[i];
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"group", (String)field.getGroupingSymbol()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"trim_type", (String)field.getTrimTypeCode()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    <ConcatFields>" + Const.CR);
        retval.append(XmlHandler.addTagValue((String)"targetFieldName", (String)this.targetFieldName));
        retval.append(XmlHandler.addTagValue((String)"targetFieldLength", (int)this.targetFieldLength));
        retval.append(XmlHandler.addTagValue((String)"removeSelectedFields", (boolean)this.removeSelectedFields));
        retval.append("    </ConcatFields>" + Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (StringUtil.isEmpty((String)this.targetFieldName)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.TargetFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.targetFieldLength <= 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.TargetFieldLengthMissingFastDataDump", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.getOutputFields().length; ++i) {
                int idx = prev.indexOfValue(this.getOutputFields()[i].getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.getOutputFields()[i].getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ConcatFieldsMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public TextFileField[] getOutputFields() {
        return this.outputFields;
    }

    public void allocate(int nrFields) {
        this.outputFields = new TextFileField[nrFields];
    }

    public void setSpecifyingFormat(boolean specifyingFormat) {
        this.specifyingFormat = specifyingFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }
}

