/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

@VisibleForTesting
public class ShardedKeyCoder<KeyT>
extends StructuredCoder<ShardedKey<KeyT>> {
    private final Coder<KeyT> keyCoder;
    private final VarIntCoder shardNumberCoder;

    public static <KeyT> ShardedKeyCoder<KeyT> of(Coder<KeyT> keyCoder) {
        return new ShardedKeyCoder<KeyT>(keyCoder);
    }

    protected ShardedKeyCoder(Coder<KeyT> keyCoder) {
        this.keyCoder = keyCoder;
        this.shardNumberCoder = VarIntCoder.of();
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Arrays.asList(this.keyCoder);
    }

    @Override
    public void encode(ShardedKey<KeyT> key, OutputStream outStream) throws IOException {
        this.keyCoder.encode(key.getKey(), outStream);
        this.shardNumberCoder.encode(key.getShardNumber(), outStream);
    }

    @Override
    public ShardedKey<KeyT> decode(InputStream inStream) throws IOException {
        return ShardedKey.of(this.keyCoder.decode(inStream), this.shardNumberCoder.decode(inStream));
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.keyCoder.verifyDeterministic();
    }
}

