/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.ProxyInvocationHandler;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@JsonSerialize(using=ProxyInvocationHandler.Serializer.class)
@JsonDeserialize(using=ProxyInvocationHandler.Deserializer.class)
@ThreadSafe
public interface PipelineOptions
extends HasDisplayData {
    public <T extends PipelineOptions> T as(Class<T> var1);

    @Validation.Required
    @Description(value="The pipeline runner that will be used to execute the pipeline. For registered runners, the class name can be specified, otherwise the fully qualified name needs to be specified.")
    @Default.InstanceFactory(value=DirectRunner.class)
    public Class<? extends PipelineRunner<?>> getRunner();

    public void setRunner(Class<? extends PipelineRunner<?>> var1);

    @Validation.Required
    @Description(value="Whether to check for stable unique names on each transform. This is necessary to support updating of pipelines.")
    @Default.Enum(value="WARNING")
    public CheckEnabled getStableUniqueNames();

    public void setStableUniqueNames(CheckEnabled var1);

    @Description(value="A pipeline level default location for storing temporary files.")
    public String getTempLocation();

    public void setTempLocation(String var1);

    @Description(value="Name of the pipeline execution.It must match the regular expression '[a-z]([-a-z0-9]{0,38}[a-z0-9])?'.It defaults to ApplicationName-UserName-Date-RandomInteger")
    @Default.InstanceFactory(value=JobNameFactory.class)
    public String getJobName();

    public void setJobName(String var1);

    public Map<String, Map<String, Object>> outputRuntimeOptions();

    @Hidden
    @Default.InstanceFactory(value=AtomicLongFactory.class)
    public long getOptionsId();

    public void setOptionsId(long var1);

    @Description(value="A user agent string describing the pipeline to external services. The format should follow RFC2616. This option defaults to \"[name]/[version]\" where name and version are properties of the Apache Beam release.")
    @Default.InstanceFactory(value=UserAgentFactory.class)
    public String getUserAgent();

    public void setUserAgent(String var1);

    public static class UserAgentFactory
    implements DefaultValueFactory<String> {
        @Override
        public String create(PipelineOptions options) {
            ReleaseInfo info = ReleaseInfo.getReleaseInfo();
            return String.format("%s/%s", info.getName(), info.getVersion()).replace(" ", "_");
        }
    }

    public static class AtomicLongFactory
    implements DefaultValueFactory<Long> {
        private static final AtomicLong NEXT_ID = new AtomicLong(0L);

        @Override
        public Long create(PipelineOptions options) {
            return NEXT_ID.getAndIncrement();
        }
    }

    public static class JobNameFactory
    implements DefaultValueFactory<String> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"MMddHHmmss").withZone(DateTimeZone.UTC);

        @Override
        public String create(PipelineOptions options) {
            String appName = options.as(ApplicationNameOptions.class).getAppName();
            String normalizedAppName = appName == null || appName.length() == 0 ? "BeamApp" : appName.toLowerCase().replaceAll("[^a-z0-9]", "0").replaceAll("^[^a-z]", "a");
            String userName = (String)MoreObjects.firstNonNull((Object)System.getProperty("user.name"), (Object)"");
            String normalizedUserName = userName.toLowerCase().replaceAll("[^a-z0-9]", "0");
            String datePart = FORMATTER.print(DateTimeUtils.currentTimeMillis());
            String randomPart = Integer.toHexString(ThreadLocalRandom.current().nextInt());
            return String.format("%s-%s-%s-%s", normalizedAppName, normalizedUserName, datePart, randomPart);
        }
    }

    public static class DirectRunner
    implements DefaultValueFactory<Class<? extends PipelineRunner<?>>> {
        @Override
        public Class<? extends PipelineRunner<?>> create(PipelineOptions options) {
            try {
                Class<?> direct = Class.forName("org.apache.beam.runners.direct.DirectRunner", true, ReflectHelpers.findClassLoader());
                return direct;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("No Runner was specified and the DirectRunner was not found on the classpath.%nSpecify a runner by either:%n    Explicitly specifying a runner by providing the 'runner' property%n    Adding the DirectRunner to the classpath%n    Calling 'PipelineOptions.setRunner(PipelineRunner)' directly", new Object[0]));
            }
        }
    }

    public static enum CheckEnabled {
        OFF,
        WARNING,
        ERROR;

    }
}

