/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptionSpec;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Multimap;

class PipelineOptionsReflector {
    private PipelineOptionsReflector() {
    }

    static Set<PipelineOptionSpec> getOptionSpecs(Class<? extends PipelineOptions> optionsInterface, boolean skipHidden) {
        Iterable<Method> methods = ReflectHelpers.getClosureOfMethodsOnInterface(optionsInterface);
        Multimap<String, Method> propsToGetters = PipelineOptionsReflector.getPropertyNamesToGetters(methods);
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (Map.Entry propAndGetter : propsToGetters.entries()) {
            String prop = (String)propAndGetter.getKey();
            Method getter = (Method)propAndGetter.getValue();
            Class<?> declaringClass = getter.getDeclaringClass();
            if (!PipelineOptions.class.isAssignableFrom(declaringClass) || skipHidden && declaringClass.isAnnotationPresent(Hidden.class)) continue;
            setBuilder.add((Object)PipelineOptionSpec.of(declaringClass, prop, getter));
        }
        return setBuilder.build();
    }

    static Set<PipelineOptionSpec> getOptionSpecs(Iterable<Class<? extends PipelineOptions>> optionsInterfaces) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (Class<? extends PipelineOptions> optionsInterface : optionsInterfaces) {
            setBuilder.addAll(PipelineOptionsReflector.getOptionSpecs(optionsInterface, true));
        }
        return setBuilder.build();
    }

    static Multimap<String, Method> getPropertyNamesToGetters(Iterable<Method> methods) {
        HashMultimap propertyNamesToGetters = HashMultimap.create();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") && !methodName.startsWith("is") || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            String propertyName = Introspector.decapitalize(methodName.startsWith("is") ? methodName.substring(2) : methodName.substring(3));
            propertyNamesToGetters.put((Object)propertyName, (Object)method);
        }
        return propertyNamesToGetters;
    }
}

