/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Combine;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Sum {
    private Sum() {
    }

    public static Combine.Globally<Integer, Integer> integersGlobally() {
        return Combine.globally(Sum.ofIntegers());
    }

    public static <K> Combine.PerKey<K, Integer, Integer> integersPerKey() {
        return Combine.perKey(Sum.ofIntegers());
    }

    public static Combine.Globally<Long, Long> longsGlobally() {
        return Combine.globally(Sum.ofLongs());
    }

    public static <K> Combine.PerKey<K, Long, Long> longsPerKey() {
        return Combine.perKey(Sum.ofLongs());
    }

    public static Combine.Globally<Double, Double> doublesGlobally() {
        return Combine.globally(Sum.ofDoubles());
    }

    public static <K> Combine.PerKey<K, Double, Double> doublesPerKey() {
        return Combine.perKey(Sum.ofDoubles());
    }

    public static Combine.BinaryCombineIntegerFn ofIntegers() {
        return new SumIntegerFn();
    }

    public static Combine.BinaryCombineDoubleFn ofDoubles() {
        return new SumDoubleFn();
    }

    public static Combine.BinaryCombineLongFn ofLongs() {
        return new SumLongFn();
    }

    private static class SumDoubleFn
    extends Combine.BinaryCombineDoubleFn {
        private SumDoubleFn() {
        }

        @Override
        public double apply(double a, double b) {
            return a + b;
        }

        @Override
        public double identity() {
            return 0.0;
        }

        public boolean equals(@Nullable Object other) {
            return other != null && other.getClass().equals(this.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class SumLongFn
    extends Combine.BinaryCombineLongFn {
        private SumLongFn() {
        }

        @Override
        public long apply(long a, long b) {
            return a + b;
        }

        @Override
        public long identity() {
            return 0L;
        }

        public boolean equals(@Nullable Object other) {
            return other != null && other.getClass().equals(this.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static class SumIntegerFn
    extends Combine.BinaryCombineIntegerFn {
        private SumIntegerFn() {
        }

        @Override
        public int apply(int a, int b) {
            return a + b;
        }

        @Override
        public int identity() {
            return 0;
        }

        public boolean equals(@Nullable Object other) {
            return other != null && other.getClass().equals(this.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

