/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.delete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.delete.DeleteKeyField;
import org.apache.hop.pipeline.transforms.delete.DeleteMeta;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DeleteDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = DeleteMeta.class;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TableView wKey;
    private TextVar wSchema;
    private TextVar wTable;
    private TextVar wCommit;
    private final DeleteMeta input;
    private final Map<String, Integer> inputFields;
    private ColumnInfo[] ciKey;
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public DeleteDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (DeleteMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setTableFieldCombo();
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteDialog.this.input.setChanged();
                DeleteDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, databaseMeta, lsMod);
        this.wConnection.addModifyListener(lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbSchema);
        wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.top = new FormAttachment(this.wConnection, 2 * margin);
        fdbSchema.right = new FormAttachment(100, 0);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)wbSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)wbSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)wbSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlCommit = new Label((Composite)this.shell, 131072);
        wlCommit.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.Commit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCommit);
        FormData fdlCommit = new FormData();
        fdlCommit.left = new FormAttachment(0, 0);
        fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdlCommit.right = new FormAttachment(middle, -margin);
        wlCommit.setLayoutData((Object)fdlCommit);
        this.wCommit = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        FormData fdCommit = new FormData();
        fdCommit.left = new FormAttachment(middle, 0);
        fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData((Object)fdCommit);
        Label wlKey = new Label((Composite)this.shell, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.Key.Label", (String[])new String[0]));
        this.props.setLook((Control)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wCommit, margin);
        wlKey.setLayoutData((Object)fdlKey);
        int nrKeyCols = 4;
        List<DeleteKeyField> keyFields = this.input.getLookup().getFields();
        int nrKeyRows = keyFields != null && !keyFields.equals(Collections.emptyList()) ? keyFields.size() : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DeleteDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DeleteDialog.ColumnInfo.Comparator", (String[])new String[0]), 2, new String[]{"=", "<>", "<", "<=", ">", ">=", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL"});
        this.ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DeleteDialog.ColumnInfo.StreamField1", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DeleteDialog.ColumnInfo.StreamField2", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciKey[0]);
        this.wKey = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.GetFields.Button", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.fdGet = new FormData();
        this.fdGet.right = new FormAttachment(100, 0);
        this.fdGet.top = new FormAttachment((Control)wlKey, margin);
        this.wGet.setLayoutData((Object)this.fdGet);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment((Control)this.wGet, -margin);
        fdKey.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wKey.setLayoutData((Object)fdKey);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteDialog.this.getSchemaNames();
            }
        });
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteDialog.this.getTableName();
            }
        });
        this.getData();
        this.setTableFieldCombo();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[2].setComboValues(fieldNames);
        this.ciKey[3].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DeleteDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wCommit.setText(this.input.getCommitSizeVar());
        List<DeleteKeyField> keyFields = this.input.getLookup().getFields();
        if (keyFields != null && !keyFields.equals(Collections.emptyList())) {
            for (int i = 0; i < keyFields.size(); ++i) {
                TableItem item = this.wKey.table.getItem(i);
                DeleteKeyField field = keyFields.get(i);
                if (field.getKeyLookup() != null) {
                    item.setText(1, field.getKeyLookup());
                }
                if (field.getKeyCondition() != null) {
                    item.setText(2, field.getKeyCondition());
                }
                if (field.getKeyStream() != null) {
                    item.setText(3, field.getKeyStream());
                }
                if (field.getKeyStream2() == null) continue;
                item.setText(4, field.getKeyStream2());
            }
        }
        if (this.input.getLookup().getSchemaName() != null) {
            this.wSchema.setText(this.input.getLookup().getSchemaName());
        }
        if (this.input.getLookup().getTableName() != null) {
            this.wTable.setText(this.input.getLookup().getTableName());
        }
        if (this.input.getConnection() != null) {
            this.wConnection.setText(this.input.getConnection());
        }
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            if (!(this.wTable.isDisposed() || this.wConnection.isDisposed() || this.wSchema.isDisposed())) {
                DatabaseMeta databaseMeta;
                String tableName = this.wTable.getText();
                String connectionName = this.wConnection.getText();
                String schemaName = this.wSchema.getText();
                for (ColumnInfo colInfo : this.tableFieldColumns) {
                    colInfo.setComboValues(new String[0]);
                }
                if (!Utils.isEmpty((CharSequence)tableName) && (databaseMeta = this.pipelineMeta.findDatabase(connectionName)) != null) {
                    Database database = new Database(loggingObject, this.variables, databaseMeta);
                    try {
                        String[] fieldNames;
                        database.connect();
                        IRowMeta r = database.getTableFieldsMeta(this.variables.resolve(schemaName), this.variables.resolve(tableName));
                        if (null != r && null != (fieldNames = r.getFieldNames())) {
                            for (ColumnInfo colInfo : this.tableFieldColumns) {
                                colInfo.setComboValues(fieldNames);
                            }
                        }
                    }
                    catch (Exception e) {
                        for (ColumnInfo colInfo : this.tableFieldColumns) {
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                    finally {
                        try {
                            if (database != null) {
                                database.disconnect();
                            }
                        }
                        catch (Exception ignored) {
                            database = null;
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    private void getInfo(DeleteMeta inf) {
        int nrkeys = this.wKey.nrNonEmpty();
        inf.setCommitSize(this.wCommit.getText());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DeleteDialog.Log.FoundKeys", (String[])new String[]{String.valueOf(nrkeys)}));
        }
        List<DeleteKeyField> keyFields = inf.getLookup().getFields();
        keyFields.clear();
        for (int i = 0; i < nrkeys; ++i) {
            TableItem item = this.wKey.getNonEmpty(i);
            DeleteKeyField f = new DeleteKeyField(item.getText(1), item.getText(2), item.getText(3), item.getText(4));
            keyFields.add(f);
        }
        inf.getLookup().setSchemaName(this.wSchema.getText());
        inf.getLookup().setTableName(this.wTable.getText());
        inf.setConnection(this.wConnection.getText());
        this.transformName = this.wTransformName.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        if (databaseMeta == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DeleteDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, this.variables, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"DeleteDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"DeleteDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DeleteDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DeleteDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtils.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName);
        if (databaseMeta != null) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DeleteDialog.Log.LookingAtConnection", (String[])new String[0]) + databaseMeta.toString());
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DeleteDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(2, "=");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wKey, (int)1, (int[])new int[]{1, 3}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DeleteDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DeleteDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

