/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;

@Internal
public class DualInputSemanticProperties
implements SemanticProperties {
    private static final long serialVersionUID = 1L;
    private Map<Integer, FieldSet> fieldMapping1 = new HashMap<Integer, FieldSet>();
    private Map<Integer, FieldSet> fieldMapping2 = new HashMap<Integer, FieldSet>();
    private FieldSet readFields1 = null;
    private FieldSet readFields2 = null;

    @Override
    public FieldSet getForwardingTargetFields(int input, int sourceField) {
        if (input != 0 && input != 1) {
            throw new IndexOutOfBoundsException();
        }
        if (input == 0) {
            return this.fieldMapping1.containsKey(sourceField) ? this.fieldMapping1.get(sourceField) : FieldSet.EMPTY_SET;
        }
        return this.fieldMapping2.containsKey(sourceField) ? this.fieldMapping2.get(sourceField) : FieldSet.EMPTY_SET;
    }

    @Override
    public int getForwardingSourceField(int input, int targetField) {
        if (input != 0 && input != 1) {
            throw new IndexOutOfBoundsException();
        }
        Map<Integer, FieldSet> fieldMapping = input == 0 ? this.fieldMapping1 : this.fieldMapping2;
        for (Map.Entry<Integer, FieldSet> e : fieldMapping.entrySet()) {
            if (!e.getValue().contains(targetField)) continue;
            return e.getKey();
        }
        return -1;
    }

    @Override
    public FieldSet getReadFields(int input) {
        if (input != 0 && input != 1) {
            throw new IndexOutOfBoundsException();
        }
        if (input == 0) {
            return this.readFields1;
        }
        return this.readFields2;
    }

    public void addForwardedField(int input, int sourceField, int targetField) {
        if (input != 0 && input != 1) {
            throw new IndexOutOfBoundsException();
        }
        Map<Integer, FieldSet> fieldMapping = input == 0 ? this.fieldMapping1 : this.fieldMapping2;
        if (this.isTargetFieldPresent(targetField, fieldMapping)) {
            throw new SemanticProperties.InvalidSemanticAnnotationException("Target field " + targetField + " was added twice to input " + input);
        }
        FieldSet targetFields = fieldMapping.get(sourceField);
        if (targetFields != null) {
            fieldMapping.put(sourceField, targetFields.addField(targetField));
        } else {
            fieldMapping.put(sourceField, new FieldSet((Integer)targetField));
        }
    }

    private boolean isTargetFieldPresent(int targetField, Map<Integer, FieldSet> fieldMapping) {
        for (FieldSet targetFields : fieldMapping.values()) {
            if (!targetFields.contains(targetField)) continue;
            return true;
        }
        return false;
    }

    public void addReadFields(int input, FieldSet readFields) {
        if (input != 0 && input != 1) {
            throw new IndexOutOfBoundsException();
        }
        if (input == 0) {
            this.readFields1 = this.readFields1 == null ? readFields.clone() : this.readFields1.addFields(readFields);
        } else {
            this.readFields2 = this.readFields2 == null ? readFields.clone() : this.readFields2.addFields(readFields);
        }
    }

    public String toString() {
        return "DISP(" + this.fieldMapping1 + "; " + this.fieldMapping2 + ")";
    }
}

