/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

@Internal
public class CompressedSerializedValue<T>
extends SerializedValue<T> {
    private static final long serialVersionUID = -4358765382738374654L;

    private CompressedSerializedValue(byte[] compressedSerializedData) {
        super(compressedSerializedData);
    }

    private CompressedSerializedValue(T value) throws IOException {
        super(InstantiationUtil.serializeObjectAndCompress(value));
    }

    @Override
    public T deserializeValue(ClassLoader loader) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull(loader, "No classloader has been passed");
        return InstantiationUtil.decompressAndDeserializeObject(this.getByteArray(), loader);
    }

    public int getSize() {
        return this.getByteArray().length;
    }

    public static <T> CompressedSerializedValue<T> fromObject(T object) throws IOException {
        Preconditions.checkNotNull(object, "Value must not be null");
        return new CompressedSerializedValue<T>(object);
    }

    public static <T> CompressedSerializedValue<T> fromBytes(byte[] compressedSerializedData) {
        return new CompressedSerializedValue<T>(compressedSerializedData);
    }

    @Override
    public String toString() {
        return String.format("Compressed Serialized Value [byte array length: %d]", this.getSize());
    }
}

