/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.actions.index;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.neo4j.actions.index.IndexUpdate;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;

@Action(id="NEO4J_INDEX", name="Neo4j Index", description="Create or delete indexes in a Neo4j database", image="neo4j_index.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Scripting", keywords={"i18n::Neo4jIndex.keyword"}, documentationUrl="/workflow/actions/neo4j-index.html")
public class Neo4jIndex
extends ActionBase
implements IAction {
    @HopMetadataProperty(key="connection", storeWithName=true)
    private NeoConnection connection;
    @HopMetadataProperty(groupKey="updates", key="update")
    private List<IndexUpdate> indexUpdates = new ArrayList<IndexUpdate>();

    public Neo4jIndex() {
        this("", "");
    }

    public Neo4jIndex(String name) {
        this(name, "");
    }

    public Neo4jIndex(String name, String description) {
        super(name, description);
    }

    public org.apache.hop.core.Result execute(org.apache.hop.core.Result result, int nr) throws HopException {
        if (this.connection == null) {
            result.setResult(false);
            result.increaseErrors(1L);
            throw new HopException("Please specify a Neo4j connection to use");
        }
        for (IndexUpdate indexUpdate : this.indexUpdates) {
            if (indexUpdate.getType() == null) {
                throw new HopException("Please make sure to always specify an index update type");
            }
            switch (indexUpdate.getType()) {
                case DROP: {
                    this.dropIndex(indexUpdate);
                    break;
                }
            }
        }
        for (IndexUpdate indexUpdate : this.indexUpdates) {
            switch (indexUpdate.getType()) {
                case CREATE: {
                    this.createIndex(indexUpdate);
                    break;
                }
            }
        }
        return result;
    }

    private void dropIndex(IndexUpdate indexUpdate) throws HopException {
        Object cypher = "DROP INDEX ";
        if (StringUtils.isNotEmpty((String)indexUpdate.getIndexName())) {
            cypher = (String)cypher + indexUpdate.getIndexName();
        } else {
            cypher = (String)cypher + " ON ";
            switch (indexUpdate.getObjectType()) {
                case NODE: {
                    cypher = (String)cypher + ":" + indexUpdate.getObjectName() + "(" + indexUpdate.getObjectProperties() + ")";
                    break;
                }
                case RELATIONSHIP: {
                    throw new HopException("Please drop indexes on relationship properties with their name.  Relationship label: " + indexUpdate.getObjectName() + ", properties: " + indexUpdate.getObjectProperties());
                }
            }
        }
        Object _cypher = cypher = (String)cypher + " IF EXISTS";
        try (Driver driver = this.connection.getDriver(this.log, (IVariables)this);
             Session session = this.connection.getSession(this.log, driver, (IVariables)this);){
            session.writeTransaction(arg_0 -> this.lambda$dropIndex$0((String)_cypher, arg_0));
        }
    }

    private void createIndex(IndexUpdate indexUpdate) throws HopException {
        Object cypher = "CREATE INDEX ";
        if (StringUtils.isNotEmpty((String)indexUpdate.getIndexName())) {
            cypher = (String)cypher + indexUpdate.getIndexName();
        }
        cypher = (String)cypher + " IF NOT EXISTS";
        String[] properties = indexUpdate.getObjectProperties().split(",");
        cypher = (String)cypher + " FOR ";
        switch (indexUpdate.getObjectType()) {
            case NODE: {
                cypher = (String)cypher + "(n:" + indexUpdate.getObjectName() + ") ";
                break;
            }
            case RELATIONSHIP: {
                cypher = (String)cypher + "()-[n:" + indexUpdate.getObjectName() + "]-() ";
            }
        }
        cypher = (String)cypher + "ON (";
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            if (i > 0) {
                cypher = (String)cypher + ", ";
            }
            cypher = (String)cypher + "n." + Const.trim((String)property);
        }
        Object _cypher = cypher = (String)cypher + ")";
        try (Driver driver = this.connection.getDriver(this.log, (IVariables)this);
             Session session = this.connection.getSession(this.log, driver, (IVariables)this);){
            session.writeTransaction(arg_0 -> this.lambda$createIndex$1((String)_cypher, arg_0));
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public NeoConnection getConnection() {
        return this.connection;
    }

    public void setConnection(NeoConnection connection) {
        this.connection = connection;
    }

    public List<IndexUpdate> getIndexUpdates() {
        return this.indexUpdates;
    }

    public void setIndexUpdates(List<IndexUpdate> indexUpdates) {
        this.indexUpdates = indexUpdates;
    }

    private /* synthetic */ Boolean lambda$createIndex$1(String _cypher, Transaction tx) {
        try {
            this.log.logDetailed("Creating index with cypher: " + _cypher);
            Result result = tx.run(_cypher);
            result.consume();
            return true;
        }
        catch (Throwable e) {
            this.log.logError("Error creating index with cypher [" + _cypher + "]", e);
            return false;
        }
    }

    private /* synthetic */ Boolean lambda$dropIndex$0(String _cypher, Transaction tx) {
        try {
            this.log.logDetailed("Dropping index with cypher: " + _cypher);
            Result result = tx.run(_cypher);
            result.consume();
            return true;
        }
        catch (Throwable e) {
            this.log.logError("Error dropping index with cypher [" + _cypher + "]", e);
            return false;
        }
    }
}

