/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.util;

import cc.blynk.clickhouse.settings.ClickHouseProperties;
import cc.blynk.clickhouse.util.guava.LittleEndianDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class ClickHouseRowBinaryStream {
    private static final int U_INT8_MAX = 255;
    private static final int U_INT16_MAX = 65535;
    private static final long U_INT32_MAX = 0xFFFFFFFFL;
    protected static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private final LittleEndianDataOutputStream out;
    private final TimeZone timeZone;

    public ClickHouseRowBinaryStream(OutputStream outputStream, TimeZone timeZone, ClickHouseProperties properties) {
        this.out = new LittleEndianDataOutputStream(outputStream);
        this.timeZone = properties.isUseServerTimeZoneForDates() ? timeZone : TimeZone.getDefault();
    }

    public void writeUnsignedLeb128(int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        for (int remaining = value >>> 7; remaining != 0; remaining >>>= 7) {
            this.out.write((byte)(value & 0x7F | 0x80));
            value = remaining;
        }
        this.out.write((byte)(value & 0x7F));
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    public void writeByte(byte b) throws IOException {
        this.out.write(b);
    }

    public void writeString(String string) throws IOException {
        Objects.requireNonNull(string);
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        this.writeUnsignedLeb128(bytes.length);
        this.out.write(bytes);
    }

    private void validateInt(int value, int minValue, int maxValue, String dataType) {
        if (value < minValue || value > maxValue) {
            throw new IllegalStateException("Not a " + dataType + " value: " + value);
        }
    }

    public void writeUInt8(boolean value) throws IOException {
        this.out.writeByte(value ? 1 : 0);
    }

    public void writeUInt8(int value) throws IOException {
        this.validateInt(value, 0, 255, "UInt8");
        byte unsigned = (byte)((long)value & 0xFFL);
        this.out.writeByte(unsigned);
    }

    public void writeInt8(int value) throws IOException {
        this.validateInt(value, -128, 127, "Int8");
        this.out.writeByte(value);
    }

    public void writeInt8(byte value) throws IOException {
        this.out.writeByte(value);
    }

    public void writeInt16(int value) throws IOException {
        this.validateInt(value, Short.MIN_VALUE, Short.MAX_VALUE, "Int6");
        this.out.writeShort(value);
    }

    public void writeInt16(short value) throws IOException {
        this.out.writeShort(value);
    }

    public void writeUInt16(int value) throws IOException {
        this.validateInt(value, 0, 65535, "UInt16");
        short unsigned = (short)((long)value & 0xFFFFL);
        this.out.writeShort(unsigned);
    }

    public void writeInt32(int value) throws IOException {
        this.out.writeInt(value);
    }

    public void writeUInt32(long value) throws IOException {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalStateException("Not a UInt32 value: " + value);
        }
        int unsigned = (int)(value & 0xFFFFFFFFL);
        this.out.writeInt(unsigned);
    }

    public void writeInt64(long value) throws IOException {
        this.out.writeLong(value);
    }

    public void writeUInt64(long value) throws IOException {
        if (value < 0L) {
            throw new IllegalStateException("Not a UInt64 value: " + value);
        }
        this.out.writeLong(value);
    }

    public void writeUInt64(BigInteger value) throws IOException {
        byte[] bytes = new byte[8];
        System.arraycopy(value.toByteArray(), 1, bytes, 0, 8);
        this.out.write(bytes);
    }

    public void writeDateTime(Date date) throws IOException {
        Objects.requireNonNull(date);
        this.writeUInt32(TimeUnit.MILLISECONDS.toSeconds(date.getTime()));
    }

    public void writeDate(Date date) throws IOException {
        Objects.requireNonNull(date);
        long localMillis = date.getTime() + (long)this.timeZone.getOffset(date.getTime());
        int daysSinceEpoch = (int)(localMillis / MILLIS_IN_DAY);
        this.writeUInt16(daysSinceEpoch);
    }

    public void writeFloat32(float value) throws IOException {
        this.out.writeFloat(value);
    }

    public void writeFloat64(double value) throws IOException {
        this.out.writeDouble(value);
    }

    public void writeDateArray(Date[] dates) throws IOException {
        Objects.requireNonNull(dates);
        this.writeUnsignedLeb128(dates.length);
        for (Date date : dates) {
            this.writeDate(date);
        }
    }

    public void writeDateTimeArray(Date[] dates) throws IOException {
        Objects.requireNonNull(dates);
        this.writeUnsignedLeb128(dates.length);
        for (Date date : dates) {
            this.writeDateTime(date);
        }
    }

    public void writeStringArray(String[] strings) throws IOException {
        Objects.requireNonNull(strings);
        this.writeUnsignedLeb128(strings.length);
        for (String el : strings) {
            this.writeString(el);
        }
    }

    public void writeInt8Array(byte[] bytes) throws IOException {
        Objects.requireNonNull(bytes);
        this.writeUnsignedLeb128(bytes.length);
        for (byte b : bytes) {
            this.writeInt8(b);
        }
    }

    public void writeInt8Array(int[] ints) throws IOException {
        Objects.requireNonNull(ints);
        this.writeUnsignedLeb128(ints.length);
        for (int i : ints) {
            this.writeInt8(i);
        }
    }

    public void writeUInt8Array(int[] ints) throws IOException {
        Objects.requireNonNull(ints);
        this.writeUnsignedLeb128(ints.length);
        for (int i : ints) {
            this.writeUInt8(i);
        }
    }

    public void writeInt16Array(short[] shorts) throws IOException {
        Objects.requireNonNull(shorts);
        this.writeUnsignedLeb128(shorts.length);
        for (short s : shorts) {
            this.writeInt16(s);
        }
    }

    public void writeUInt16Array(int[] ints) throws IOException {
        Objects.requireNonNull(ints);
        this.writeUnsignedLeb128(ints.length);
        for (int i : ints) {
            this.writeUInt16(i);
        }
    }

    public void writeInt32Array(int[] ints) throws IOException {
        Objects.requireNonNull(ints);
        this.writeUnsignedLeb128(ints.length);
        for (int i : ints) {
            this.writeInt32(i);
        }
    }

    public void writeUInt32Array(long[] longs) throws IOException {
        Objects.requireNonNull(longs);
        this.writeUnsignedLeb128(longs.length);
        for (long l : longs) {
            this.writeUInt32(l);
        }
    }

    public void writeInt64Array(long[] longs) throws IOException {
        Objects.requireNonNull(longs);
        this.writeUnsignedLeb128(longs.length);
        for (long l : longs) {
            this.writeInt64(l);
        }
    }

    public void writeUInt64Array(long[] longs) throws IOException {
        Objects.requireNonNull(longs);
        this.writeUnsignedLeb128(longs.length);
        for (long l : longs) {
            this.writeUInt64(l);
        }
    }

    public void writeFloat32Array(float[] floats) throws IOException {
        Objects.requireNonNull(floats);
        this.writeUnsignedLeb128(floats.length);
        for (float f : floats) {
            this.writeFloat32(f);
        }
    }

    public void writeFloat64Array(double[] doubles) throws IOException {
        Objects.requireNonNull(doubles);
        this.writeUnsignedLeb128(doubles.length);
        for (double d : doubles) {
            this.writeFloat64(d);
        }
    }

    void markNextNullable(boolean isNullable) throws IOException {
        this.writeByte(isNullable ? (byte)1 : 0);
    }

    public void writeUUID(UUID uuid) throws IOException {
        Objects.requireNonNull(uuid);
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]).order(ByteOrder.LITTLE_ENDIAN);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        byte[] array = bb.array();
        this.writeBytes(array);
    }
}

